/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class AndroidPreFlightChecks {
    private final AndroidEntryPointManager manager;
    private final IClassHierarchy cha;

    public AndroidPreFlightChecks(AndroidEntryPointManager manager, IClassHierarchy cha) {
        this.manager = manager;
        this.cha = cha;
    }

    public boolean all() {
        return this.allBut(EnumSet.noneOf(Test.class));
    }

    public boolean allBut(Set<Test> skip) {
        boolean pass = true;
        if (!skip.contains((Object)Test.OVERRIDES)) {
            pass &= this.checkOverridesInPlace();
        }
        if (!skip.contains((Object)Test.INTENTS)) {
            pass &= this.checkIntentSpecs();
        }
        if (!skip.contains((Object)Test.REUSE)) {
            pass &= this.checkAllComponentsReuse();
        }
        if (!skip.contains((Object)Test.STUBS_VERSION)) {
            pass &= this.checkStubsVersion();
        }
        if (!skip.contains((Object)Test.OBJECT_IN_EP)) {
            pass &= this.checkNoObjectInEntryPoints();
        }
        return pass;
    }

    public boolean checkOverridesInPlace() {
        boolean pass = true;
        return pass;
    }

    public boolean checkStubsVersion() {
        boolean pass = true;
        if (this.cha.lookupClass(AndroidTypes.Fragment) == null) {
            pass = false;
        }
        if (this.cha.lookupClass(AndroidTypes.UserHandle) == null) {
            pass = false;
        }
        if (this.cha.resolveMethod(this.cha.lookupClass(AndroidTypes.Activity), Selector.make((String)"getLoaderManager()Landroid/app/LoaderManager;")) == null) {
            pass = false;
        }
        if (this.cha.resolveMethod(this.cha.lookupClass(AndroidTypes.Activity), Selector.make((String)"getSystemService(Ljava/lang/String;)Ljava/lang/Object;")) == null) {
            pass = false;
        }
        if (this.cha.resolveMethod(this.cha.lookupClass(AndroidTypes.Context), Selector.make((String)"getSystemService(Ljava/lang/String;)Ljava/lang/Object;")) == null) {
            pass = false;
        }
        return pass;
    }

    public boolean checkIntentSpecs() {
        boolean pass = true;
        List<AndroidEntryPoint> entrypoits = AndroidEntryPointManager.ENTRIES;
        for (AndroidEntryPoint ep : entrypoits) {
            TypeName test = ep.getMethod().getDeclaringClass().getName();
            if (this.manager.existsIntentFor(test) || test.toString().startsWith("Landroid/")) continue;
            pass = false;
        }
        return pass;
    }

    public boolean checkAllComponentsReuse() {
        boolean pass = true;
        IInstantiationBehavior behaviour = this.manager.getInstantiationBehavior(this.cha);
        List<AndroidEntryPoint> entrypoits = AndroidEntryPointManager.ENTRIES;
        for (AndroidEntryPoint ep : entrypoits) {
            TypeName test = ep.getMethod().getDeclaringClass().getName();
            IInstantiationBehavior.InstanceBehavior behave = behaviour.getBehavior(test, null, null, null);
            if (behave == IInstantiationBehavior.InstanceBehavior.REUSE) continue;
            pass = false;
        }
        return pass;
    }

    public boolean checkNoObjectInEntryPoints() {
        boolean pass = true;
        List<AndroidEntryPoint> entrypoits = AndroidEntryPointManager.ENTRIES;
        block0: for (AndroidEntryPoint ep : entrypoits) {
            TypeName[] params = ep.getMethod().getDescriptor().getParameters();
            if (params == null) continue;
            for (TypeName type : params) {
                if (!type.equals((Object)TypeReference.JavaLangObject.getName())) continue;
                pass = false;
                continue block0;
            }
        }
        return pass;
    }

    public static enum Test {
        OVERRIDES,
        INTENTS,
        REUSE,
        STUBS_VERSION,
        OBJECT_IN_EP;

    }
}

