/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.dalvik.util.androidEntryPoints.ActivityEP;
import com.ibm.wala.dalvik.util.androidEntryPoints.ApplicationEP;
import com.ibm.wala.dalvik.util.androidEntryPoints.LoaderCB;
import com.ibm.wala.dalvik.util.androidEntryPoints.LocationEP;
import com.ibm.wala.dalvik.util.androidEntryPoints.ProviderEP;
import com.ibm.wala.dalvik.util.androidEntryPoints.ServiceEP;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndroidEntryPointLocator {
    private static final Logger logger = LoggerFactory.getLogger(AndroidEntryPointLocator.class);
    private final MonitorUtil.IProgressMonitor mon;
    private static final List<AndroidPossibleEntryPoint> possibleEntryPoints = new ArrayList<AndroidPossibleEntryPoint>();
    private final Set<LocatorFlags> flags;

    private static Set<LocatorFlags> defaultFlags() {
        HashSet flags = HashSetFactory.make();
        flags.add(LocatorFlags.INCLUDE_CALLBACKS);
        flags.add(LocatorFlags.EP_HEURISTIC);
        flags.add(LocatorFlags.CB_HEURISTIC);
        return flags;
    }

    public AndroidEntryPointLocator() {
        this(AndroidEntryPointLocator.defaultFlags());
    }

    public AndroidEntryPointLocator(Set<LocatorFlags> flags) {
        this.flags = flags == null ? EnumSet.noneOf(LocatorFlags.class) : flags;
        this.mon = AndroidEntryPointManager.MANAGER.getProgressMonitor();
        this.populatePossibleEntryPoints();
    }

    public List<AndroidEntryPoint> getEntryPoints(IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("I need a ClassHierarchy to search");
        }
        HashSet<AndroidEntryPoint> entryPoints = new HashSet<AndroidEntryPoint>();
        this.mon.beginTask("Locating Entrypoints", -1);
        int dummy = 0;
        for (IClass cls : cha) {
            this.mon.worked(dummy++);
            if (cls.getName().toString().contains("MainActivity")) {
                System.err.println("got here");
            }
            if (AndroidEntryPointLocator.isExcluded(cls) || cls.isInterface() || cls.isAbstract() || cls.getClassLoader().getName().equals((Object)AnalysisScope.PRIMORDIAL) || cls.getClassLoader().getName().equals((Object)AnalysisScope.EXTENSION)) continue;
            block1: for (IMethod m : cls.getDeclaredMethods()) {
                if (cls.getName().toString().contains("MainActivity")) {
                    System.err.println("got here: " + m);
                }
                for (AndroidPossibleEntryPoint e : possibleEntryPoints) {
                    if (!e.name.equals(m.getName().toString())) continue;
                    if (this.flags.contains((Object)LocatorFlags.WITH_ANDROID)) {
                        entryPoints.add(new AndroidEntryPoint(e, m, cha));
                        continue block1;
                    }
                    if (AndroidEntryPointLocator.isAPIComponent(m)) continue block1;
                    entryPoints.add(new AndroidEntryPoint(e, m, cha));
                    continue block1;
                }
            }
        }
        if (this.flags.contains((Object)LocatorFlags.EP_HEURISTIC) || this.flags.contains((Object)LocatorFlags.CB_HEURISTIC)) {
            HashSet<TypeReference> bases = new HashSet<TypeReference>();
            if (this.flags.contains((Object)LocatorFlags.EP_HEURISTIC)) {
                if (this.flags.contains((Object)LocatorFlags.INCLUDE_CALLBACKS)) {
                    for (AndroidComponent compo : AndroidComponent.values()) {
                        if (compo == AndroidComponent.UNKNOWN) continue;
                        if (compo.toReference() == null) {
                            logger.error("Null-Reference for " + (Object)((Object)compo));
                            continue;
                        }
                        bases.add(compo.toReference());
                    }
                } else {
                    bases.add(AndroidTypes.Application);
                    bases.add(AndroidTypes.Activity);
                    bases.add(AndroidTypes.Service);
                    bases.add(AndroidTypes.ContentProvider);
                    bases.add(AndroidTypes.BroadcastReceiver);
                }
                this.heuristicScan(bases, entryPoints, cha);
            }
            if (this.flags.contains((Object)LocatorFlags.CB_HEURISTIC)) {
                this.heuristicAnyAndroid(entryPoints, cha);
            }
        }
        ArrayList<AndroidEntryPoint> ret = new ArrayList<AndroidEntryPoint>(entryPoints);
        ret.sort(new AndroidEntryPoint.ExecutionOrderComperator());
        this.mon.done();
        return ret;
    }

    private void heuristicScan(Collection<? extends TypeReference> bases, Set<? super AndroidEntryPoint> eps, IClassHierarchy cha) {
        for (TypeReference typeReference : bases) {
            Collection candids;
            IClass baseClass = cha.lookupClass(typeReference);
            this.mon.subTask("Heuristic scan in " + typeReference);
            try {
                candids = cha.computeSubClasses(typeReference);
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage());
                continue;
            }
            for (IClass candid : candids) {
                if (AndroidEntryPointLocator.isExcluded(candid) || !this.flags.contains((Object)LocatorFlags.WITH_ANDROID) && AndroidEntryPointLocator.isAPIComponent(candid)) continue;
                Collection methods = candid.getDeclaredMethods();
                for (IMethod method : methods) {
                    AndroidEntryPoint ep;
                    if ((method.isInit() || method.isClinit()) && !this.flags.contains((Object)LocatorFlags.WITH_CTOR)) {
                        logger.debug("Skipping constructor of {}", (Object)method);
                        continue;
                    }
                    if (baseClass.getMethod(method.getSelector()) == null || !eps.add(ep = AndroidEntryPointLocator.makeEntryPointForHeuristic(method, cha))) continue;
                    logger.debug("Heuristic 1: selecting {} for base {}", (Object)method, (Object)typeReference);
                }
            }
        }
    }

    private static AndroidEntryPoint makeEntryPointForHeuristic(IMethod method, IClassHierarchy cha) {
        AndroidComponent compo = AndroidComponent.from(method, cha);
        if (compo == AndroidComponent.UNKNOWN) {
            // empty if block
        }
        AndroidEntryPoint ep = new AndroidEntryPoint(AndroidEntryPointLocator.selectPositionForHeuristic(), method, cha, compo);
        return ep;
    }

    private void heuristicAnyAndroid(Set<AndroidEntryPoint> eps, IClassHierarchy cha) {
        IClass appClass;
        IClassLoader appLoader = cha.getLoader(ClassLoaderReference.Application);
        Iterator appIt = appLoader.iterateAllClasses();
        IClass iClass = appClass = appIt.hasNext() ? (IClass)appIt.next() : null;
        while (appIt.hasNext()) {
            IClass androidClass;
            boolean isAndroidClass = false;
            for (androidClass = appClass; androidClass != null; androidClass = androidClass.getSuperclass()) {
                if (AndroidEntryPointLocator.isAPIComponent(androidClass)) {
                    isAndroidClass = true;
                    break;
                }
                logger.trace("Heuristic: \t {} is {}", (Object)appClass.getName().toString(), (Object)androidClass.getName().toString());
                for (IClass iface : appClass.getAllImplementedInterfaces()) {
                    logger.trace("Heuristic: \t implements {}", (Object)iface.getName().toString());
                    if (!AndroidEntryPointLocator.isAPIComponent(iface)) continue;
                    isAndroidClass = true;
                    break;
                }
                if (isAndroidClass) break;
            }
            if (!isAndroidClass) {
                logger.trace("Heuristic: Skipping non andoid {}", (Object)appClass.getName().toString());
            } else {
                logger.debug("Heuristic: Scanning methods of {}", (Object)appClass.getName().toString());
                if (!AndroidEntryPointLocator.isAPIComponent(appClass) && !AndroidEntryPointLocator.isExcluded(appClass)) {
                    Collection methods = appClass.getDeclaredMethods();
                    for (IMethod method : methods) {
                        if ((method.isInit() || method.isClinit()) && !this.flags.contains((Object)LocatorFlags.WITH_CTOR)) {
                            logger.debug("Skipping constructor of {}", (Object)method);
                            continue;
                        }
                        assert (method.getSelector() != null) : "Method has no selector: " + method;
                        assert (androidClass != null) : "androidClass is null";
                        if (androidClass.getMethod(method.getSelector()) == null) continue;
                        AndroidEntryPoint ep = AndroidEntryPointLocator.makeEntryPointForHeuristic(method, cha);
                        if (eps.add(ep)) {
                            logger.debug("Heuristic 2a: selecting {}", (Object)method);
                            continue;
                        }
                        logger.debug("Heuristic 2a: already selected {}", (Object)method);
                    }
                    Collection iFaces = appClass.getAllImplementedInterfaces();
                    for (IClass iFace : iFaces) {
                        if (AndroidEntryPointLocator.isAPIComponent(iFace)) {
                            logger.debug("Skipping iFace: {}", (Object)iFace);
                            continue;
                        }
                        if (AndroidEntryPointLocator.isExcluded(iFace)) continue;
                        logger.debug("Searching Interface {}", (Object)iFace);
                        Collection ifMethods = iFace.getDeclaredMethods();
                        for (IMethod ifMethod : ifMethods) {
                            AndroidEntryPoint ep;
                            IMethod method = appClass.getMethod(ifMethod.getSelector());
                            if (method != null && method.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                                ep = new AndroidEntryPoint(AndroidEntryPointLocator.selectPositionForHeuristic(), method, cha);
                                if (!eps.add(ep)) continue;
                                logger.debug("Heuristic 2b: selecting {}", (Object)method);
                                continue;
                            }
                            if (method == null) continue;
                            if (this.flags.contains((Object)LocatorFlags.WITH_SUPER)) {
                                ep = AndroidEntryPointLocator.makeEntryPointForHeuristic(method, cha);
                                if (eps.contains((Object)ep) && !method.isStatic()) {
                                    for (AndroidEntryPoint eps_ep : eps) {
                                        if (!eps_ep.equals((Object)ep)) continue;
                                        TypeReference[] oldTypes = eps_ep.getParameterTypes(0);
                                        Object[] newTypes = Arrays.copyOf(oldTypes, oldTypes.length + 1);
                                        newTypes[oldTypes.length] = appClass.getReference();
                                        eps_ep.setParameterTypes(0, (TypeReference[])newTypes);
                                        logger.debug("New This-Types for {} are {}", (Object)method.getSelector(), (Object)Arrays.toString(newTypes));
                                    }
                                    continue;
                                }
                                if (!method.isStatic()) {
                                    ep.setParameterTypes(0, new TypeReference[]{appClass.getReference()});
                                }
                                eps.add(ep);
                                logger.debug("Heuristic 2b: selecting from super {}", (Object)method);
                                continue;
                            }
                            logger.debug("Heuristic 2b: Skipping {}", (Object)method);
                        }
                    }
                }
            }
            appClass = (IClass)appIt.next();
        }
    }

    private static boolean isAPIComponent(IMethod method) {
        return AndroidEntryPointLocator.isAPIComponent(method.getDeclaringClass());
    }

    private static boolean isAPIComponent(IClass cls) {
        ClassLoaderReference clr = cls.getClassLoader().getReference();
        if (!clr.equals((Object)ClassLoaderReference.Primordial) && !clr.equals((Object)ClassLoaderReference.Extension)) {
            return cls.getName().toString().startsWith("Landroid/");
        }
        return true;
    }

    private static boolean isExcluded(IClass cls) {
        SetOfClasses set = cls.getClassHierarchy().getScope().getExclusions();
        if (set == null) {
            return false;
        }
        String clsName = cls.getReference().getName().toString().substring(1);
        return set.contains(clsName);
    }

    private static AndroidEntryPoint.ExecutionOrder selectPositionForHeuristic() {
        return AndroidEntryPoint.ExecutionOrder.MULTIPLE_TIMES_IN_LOOP;
    }

    private void populatePossibleEntryPoints() {
        if (possibleEntryPoints.size() > 0) {
            return;
        }
        ApplicationEP.populate(possibleEntryPoints);
        ActivityEP.populate(possibleEntryPoints);
        ServiceEP.populate(possibleEntryPoints);
        ProviderEP.populate(possibleEntryPoints);
        if (this.flags.contains((Object)LocatorFlags.INCLUDE_CALLBACKS)) {
            LocationEP.populate(possibleEntryPoints);
            LoaderCB.populate(possibleEntryPoints);
        }
        possibleEntryPoints.sort(new AndroidPossibleEntryPoint.ExecutionOrderComperator());
    }

    public static void debugDumpEntryPoints(List<AndroidPossibleEntryPoint> eps) {
        int dfa = 0;
        int indent = 0;
        for (AndroidPossibleEntryPoint ep : eps) {
            if (dfa == 0) {
                System.out.println("AT_FIRST:");
                indent = 1;
                ++dfa;
            }
            if (dfa == 1 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.BEFORE_LOOP.getOrderValue()) {
                System.out.println("BEFORE_LOOP:");
                ++dfa;
            }
            if (dfa == 2 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.START_OF_LOOP.getOrderValue()) {
                System.out.println("START_OF_LOOP:");
                indent = 2;
                ++dfa;
            }
            if (dfa == 3 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.MIDDLE_OF_LOOP.getOrderValue()) {
                System.out.println("MIDDLE_OF_LOOP:");
                ++dfa;
            }
            if (dfa == 4 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.MULTIPLE_TIMES_IN_LOOP.getOrderValue()) {
                System.out.println("MULTIPLE_TIMES_IN_LOOP:");
                indent = 3;
                ++dfa;
            }
            if (dfa == 5 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.END_OF_LOOP.getOrderValue()) {
                System.out.println("END_OF_LOOP:");
                indent = 2;
                ++dfa;
            }
            if (dfa == 6 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.AFTER_LOOP.getOrderValue()) {
                System.out.println("AFTER_LOOP:");
                indent = 1;
                ++dfa;
            }
            if (dfa == 7 && ep.getOrderValue() >= AndroidEntryPoint.ExecutionOrder.AT_LAST.getOrderValue()) {
                System.out.println("AT_LAST:");
                indent = 1;
                ++dfa;
            }
            for (int i = 0; i < indent; ++i) {
                System.out.print("\t");
            }
            System.out.println(ep.name + " metric: " + ep.getOrderValue());
        }
    }

    public static class AndroidPossibleEntryPoint
    implements AndroidEntryPoint.IExecutionOrder {
        private final String name;
        public final AndroidEntryPoint.ExecutionOrder order;

        public AndroidPossibleEntryPoint(String n, AndroidEntryPoint.ExecutionOrder o) {
            this.name = n;
            this.order = o;
        }

        public AndroidPossibleEntryPoint(String n, AndroidPossibleEntryPoint o) {
            this.name = n;
            this.order = o.order;
        }

        @Override
        public int getOrderValue() {
            return this.order.getOrderValue();
        }

        @Override
        public int compareTo(AndroidEntryPoint.IExecutionOrder o) {
            return this.order.compareTo(o);
        }

        @Override
        public AndroidEntryPoint.ExecutionOrder getSection() {
            return this.order.getSection();
        }

        public static class ExecutionOrderComperator
        implements Comparator<AndroidPossibleEntryPoint> {
            @Override
            public int compare(AndroidPossibleEntryPoint a, AndroidPossibleEntryPoint b) {
                return a.order.compareTo(b.order);
            }
        }
    }

    public static enum LocatorFlags {
        INCLUDE_CALLBACKS,
        EP_HEURISTIC,
        CB_HEURISTIC,
        WITH_CTOR,
        WITH_SUPER,
        WITH_ANDROID;

    }
}

