/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.StringStuff;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import java.util.HashMap;
import java.util.Map;

class IntentMap {
    private final Map<InstanceKey, Intent> seen = new HashMap<InstanceKey, Intent>();
    private final Map<Intent, Intent> immutables = new HashMap<Intent, Intent>();

    IntentMap() {
    }

    public Intent findOrCreateImmutable(Intent intent) {
        if (this.immutables.containsKey(intent)) {
            Intent immutable = this.immutables.get(intent);
            assert (immutable.getAction().equals((Object)intent.getAction()));
            return immutable;
        }
        Intent immutable = intent.clone();
        immutable.setImmutable();
        this.immutables.put(intent, immutable);
        return immutable;
    }

    public Intent find(InstanceKey key) throws IndexOutOfBoundsException {
        if (key == null) {
            throw new IllegalArgumentException("InstanceKey may not be null");
        }
        if (!this.seen.containsKey(key)) {
            throw new IndexOutOfBoundsException("No Intent was seen for key " + key);
        }
        return this.seen.get(key);
    }

    public Intent create(InstanceKey key, String action) {
        if (key == null) {
            throw new IllegalArgumentException("InstanceKey may not be null");
        }
        if (this.seen.containsKey(key)) {
            throw new IndexOutOfBoundsException("There may only be one Intent for " + key);
        }
        Intent intent = new Intent(action);
        this.seen.put(key, intent);
        return intent;
    }

    public Intent create(InstanceKey key, Atom action) {
        if (key == null) {
            throw new IllegalArgumentException("InstanceKey may not be null");
        }
        if (this.seen.containsKey(key)) {
            throw new IndexOutOfBoundsException("There may only be one Intent for " + key);
        }
        Intent intent = new Intent(action);
        this.seen.put(key, intent);
        return intent;
    }

    public Intent create(InstanceKey key) {
        if (key == null) {
            throw new IllegalArgumentException("InstanceKey may not be null");
        }
        if (this.seen.containsKey(key)) {
            throw new IndexOutOfBoundsException("There may only be one Intent for " + key);
        }
        Intent intent = new Intent();
        this.seen.put(key, intent);
        return intent;
    }

    public Intent findOrCreate(InstanceKey key) {
        if (this.seen.containsKey(key)) {
            return this.find(key);
        }
        return this.create(key);
    }

    public void put(InstanceKey key, Intent intent) {
        this.seen.put(key, intent);
    }

    public boolean contains(InstanceKey key) {
        return this.seen.containsKey(key);
    }

    public Intent findOrCreate(InstanceKey key, String action) {
        Intent intent = this.findOrCreate(key);
        Atom foundAction = intent.getAction();
        if (!foundAction.equals((Object)Atom.findOrCreateAsciiAtom((String)action))) {
            throw new IllegalArgumentException("Actions differ (" + action + ", " + foundAction + ") for Intent " + key);
        }
        return intent;
    }

    public Intent setAction(InstanceKey key, String action, boolean isExplicit) {
        return this.setAction(key, Atom.findOrCreateAsciiAtom((String)action), isExplicit);
    }

    public Intent unbind(InstanceKey key) {
        Intent intent = this.find(key);
        intent.unbind();
        return intent;
    }

    public Intent setExplicit(InstanceKey key) {
        if (this.contains(key)) {
            Intent intent = this.find(key);
            intent.setExplicit();
            return intent;
        }
        throw new IllegalArgumentException("setAction: No Intent found for key " + key);
    }

    public Intent setAction(InstanceKey key, Atom action, boolean isExplicit) {
        if (this.contains(key)) {
            Intent intent = this.find(key);
            if (isExplicit) {
                intent.setActionExplicit(action);
            } else {
                intent.setAction(action);
            }
            return intent;
        }
        Intent intent = this.create(key, action);
        return intent;
    }

    public Intent setAction(Intent intent, String action, boolean isExplicit) {
        for (Map.Entry<InstanceKey, Intent> entry : this.seen.entrySet()) {
            if (!entry.getValue().equals(intent)) continue;
            return this.setAction(entry.getKey(), action, isExplicit);
        }
        throw new IllegalStateException("The Intent " + intent + " was not registered before!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Intent setAction(InstanceKey key, InstanceKey actionKey, boolean isExplicit) {
        if (actionKey == null) {
            return this.find(key);
        }
        if (actionKey instanceof ConstantKey) {
            String action;
            Object actionO = ((ConstantKey)actionKey).getValue();
            if (actionO instanceof String) {
                action = StringStuff.deployment2CanonicalTypeString((String)((String)actionO));
                return this.setAction(key, action, isExplicit);
            } else {
                if (!(actionO instanceof IClass)) throw new IllegalArgumentException("Wrong action type: " + actionO.getClass());
                action = ((IClass)actionO).getName().toString();
            }
            return this.setAction(key, action, isExplicit);
        } else {
            this.unbind(key);
            return null;
        }
    }
}

