/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LoadedInstantiationBehavior
extends IInstantiationBehavior {
    private IInstantiationBehavior.InstanceBehavior defaultBehavior = null;
    private final Map<BehaviorKey<?>, BehviourValue> behaviours = new HashMap();
    private final IClassHierarchy cha;
    private static final long serialVersionUID = 810020131212L;
    public transient boolean serializationIncludesCache = true;

    public LoadedInstantiationBehavior(IClassHierarchy cha) {
        this.cha = cha;
    }

    public void setDefaultBehavior(IInstantiationBehavior.InstanceBehavior defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    @Override
    public IInstantiationBehavior.InstanceBehavior getBehavior(TypeName type, TypeName asParameterTo, MethodReference inCall, String withName) {
        IClassLoader[] packK;
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        BehaviorKey<TypeName> typeK = BehaviorKey.mk(type);
        if (this.behaviours.containsKey(typeK)) {
            BehviourValue typeV = this.behaviours.get(typeK);
            while (typeV.cacheFrom != null) {
                typeV = typeV.cacheFrom;
            }
            return typeV.behaviour;
        }
        Atom pack = type.getPackage();
        if (pack != null && this.behaviours.containsKey(packK = BehaviorKey.mk(pack))) {
            BehviourValue packV = this.behaviours.get(packK);
            IInstantiationBehavior.InstanceBehavior beh = packV.behaviour;
            this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.PACKAGE, packV));
            return beh;
        }
        if (this.cha != null) {
            IClass testClass = null;
            for (IClassLoader loader : this.cha.getLoaders()) {
                testClass = loader.lookupClass(type);
                if (testClass == null) continue;
                testClass = testClass.getSuperclass();
                break;
            }
            while (testClass != null) {
                BehaviorKey<TypeName> testKey = BehaviorKey.mk(testClass.getName());
                if (this.behaviours.containsKey(testKey)) {
                    BehviourValue value = this.behaviours.get(testKey);
                    IInstantiationBehavior.InstanceBehavior beh = value.behaviour;
                    this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.INHERITED, value));
                    return beh;
                }
                testClass = testClass.getSuperclass();
            }
        }
        String prefix = type.toString();
        while (prefix.contains("/")) {
            BehaviorKey<Atom> prefixKey = BehaviorKey.mk(Atom.findOrCreateAsciiAtom((String)(prefix = prefix.substring(0, prefix.lastIndexOf(47) - 1))));
            if (!this.behaviours.containsKey(prefixKey)) continue;
            BehviourValue value = this.behaviours.get(prefixKey);
            IInstantiationBehavior.InstanceBehavior beh = value.behaviour;
            this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.PREFIX, value));
            return beh;
        }
        IInstantiationBehavior.InstanceBehavior beh = this.getDafultBehavior();
        BehviourValue packV = new BehviourValue(beh, IInstantiationBehavior.Exactness.DEFAULT, null);
        this.behaviours.put(typeK, packV);
        return beh;
    }

    @Override
    public IInstantiationBehavior.Exactness getExactness(TypeName type, TypeName asParameterTo, MethodReference inCall, String withName) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        BehaviorKey<TypeName> typeK = BehaviorKey.mk(type);
        if (!this.behaviours.containsKey(typeK)) {
            this.getBehavior(type, asParameterTo, inCall, withName);
        }
        return this.behaviours.get(typeK).exactness;
    }

    @Override
    public IInstantiationBehavior.InstanceBehavior getDafultBehavior() {
        if (this.defaultBehavior == null) {
            return IInstantiationBehavior.InstanceBehavior.REUSE;
        }
        return this.defaultBehavior;
    }

    public void setBehavior(TypeName type, IInstantiationBehavior.InstanceBehavior beh, IInstantiationBehavior.Exactness exactness) {
        BehaviorKey<TypeName> typeK = BehaviorKey.mk(type);
        BehviourValue val = new BehviourValue(beh, exactness, null);
        this.behaviours.put(typeK, val);
    }

    public void setBehavior(Atom pack, IInstantiationBehavior.InstanceBehavior beh, IInstantiationBehavior.Exactness exactness) {
        BehaviorKey<Atom> typeK = BehaviorKey.mk(pack);
        BehviourValue val = new BehviourValue(beh, exactness, null);
        this.behaviours.put(typeK, val);
    }

    protected static Atom type2atom(TypeName type) {
        return Atom.findOrCreateAsciiAtom((String)type.toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.serializationIncludesCache) {
            stream.writeObject(this.behaviours);
        } else {
            HashMap strippedBehaviours = new HashMap();
            for (Map.Entry<BehaviorKey<?>, BehviourValue> entry : this.behaviours.entrySet()) {
                BehviourValue val = entry.getValue();
                if (val.isCached()) continue;
                strippedBehaviours.put(entry.getKey(), val);
            }
            stream.writeObject(strippedBehaviours);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.behaviours.clear();
        this.behaviours.putAll((Map)stream.readObject());
    }

    private static final class BehaviorKey<T>
    implements Serializable {
        private static final long serialVersionUID = 73530L;
        final T base;

        public BehaviorKey(T base) {
            this.base = base;
        }

        public static BehaviorKey<TypeName> mk(TypeName base) {
            return new BehaviorKey<TypeName>(base);
        }

        public static BehaviorKey<Atom> mk(Atom base) {
            return new BehaviorKey<Atom>(base);
        }

        public boolean equals(Object o) {
            if (o instanceof BehaviorKey) {
                BehaviorKey other = (BehaviorKey)o;
                return this.base.equals(other.base);
            }
            return false;
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public String toString() {
            return "<BehaviorKey of " + this.base.getClass() + ' ' + this.base + " hash=" + this.hashCode() + "/>";
        }
    }

    private static final class BehviourValue
    implements Serializable {
        private static final long serialVersionUID = -7558845015122601212L;
        public final IInstantiationBehavior.InstanceBehavior behaviour;
        public final IInstantiationBehavior.Exactness exactness;
        public final BehviourValue cacheFrom;

        public BehviourValue(IInstantiationBehavior.InstanceBehavior behaviour, IInstantiationBehavior.Exactness exactness, BehviourValue cacheFrom) {
            this.behaviour = behaviour;
            this.exactness = exactness;
            this.cacheFrom = cacheFrom;
        }

        public String toString() {
            return "<BehaviorValue " + (Object)((Object)this.behaviour) + " - " + (Object)((Object)this.exactness) + " = " + this.cacheFrom + '>';
        }

        public boolean isCached() {
            return this.cacheFrom != null;
        }
    }
}

