/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.core.util.ssa.IInstantiator;
import com.ibm.wala.core.util.ssa.ParameterAccessor;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.SpecializedInstantiator;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instantiator
implements IInstantiator {
    private static final Logger logger = LoggerFactory.getLogger(Instantiator.class);
    final IClassHierarchy cha;
    final VolatileMethodSummary body;
    final TypeSafeInstructionFactory instructionFactory;
    final SSAValueManager pm;
    final MethodReference scope;
    final AnalysisScope analysisScope;

    public Instantiator(VolatileMethodSummary body, TypeSafeInstructionFactory instructionFactory, SSAValueManager pm, IClassHierarchy cha, MethodReference scope, AnalysisScope analysisScope) {
        this.body = body;
        this.instructionFactory = instructionFactory;
        this.pm = pm;
        this.cha = cha;
        this.scope = scope;
        this.analysisScope = analysisScope;
    }

    private boolean isExcluded(IClass cls) {
        if (this.analysisScope.getExclusions() != null && this.analysisScope.getExclusions().contains(cls.getName().toString())) {
            logger.info("Hit exclusions with {}", (Object)cls);
            return true;
        }
        return false;
    }

    public SSAValue createInstance(TypeReference T, boolean asManaged, SSAValue.VariableKey key, Set<? extends SSAValue> seen) {
        SSAValue instance;
        if (T == null) {
            throw new IllegalArgumentException("Can't create an instance of null");
        }
        if (seen == null) {
            logger.debug("Empty seen");
            seen = new HashSet<SSAValue>();
        }
        if (SpecializedInstantiator.understands(T)) {
            SpecializedInstantiator sInst = new SpecializedInstantiator(this.body, this.instructionFactory, this.pm, this.cha, this.scope, this.analysisScope, this);
            return sInst.createInstance(T, asManaged, key, seen);
        }
        IClass klass = this.cha.lookupClass(T);
        if (asManaged) {
            if (key == null) {
                throw new IllegalArgumentException("A managed variable needs a key - null given.");
            }
            instance = klass != null && (klass.isAbstract() || klass.isInterface()) ? this.pm.getFree(T, key) : this.pm.getUnallocated(T, key);
        } else {
            if (key == null) {
                key = new SSAValue.UniqueKey();
            }
            instance = this.pm.getUnmanaged(T, key);
        }
        if (AndroidComponent.isAndroidComponent(T, this.cha)) {
            if (AndroidEntryPointManager.MANAGER.doFlatComponents()) {
                Atom fdName;
                AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
                if (mClass.getField(fdName = T.getName().getClassName()) != null) {
                    IField field = mClass.getField(fdName);
                    int n = this.body.getNextProgramCounter();
                    SSAGetInstruction sSAGetInstruction = this.instructionFactory.GetInstruction(n, instance, field.getReference());
                    this.body.addStatement((SSAInstruction)sSAGetInstruction);
                    this.pm.setAllocation(instance, (SSAInstruction)sSAGetInstruction);
                    return instance;
                }
                logger.info("NEW Component {} \n\tbreadCrumb: {}", (Object)instance, (Object)this.pm.breadCrumb);
            } else {
                logger.info("NEW Component {} \n\tbreadCrumb: {}", (Object)instance, (Object)this.pm.breadCrumb);
            }
        }
        if (T.isPrimitiveType()) {
            Instantiator.createPrimitive(instance);
            return instance;
        }
        if (klass == null) {
            if (!T.getName().toString().startsWith("Landroid/")) {
                logger.error("The Type {} is not in the ClassHierarchy! Returning null as instance", (Object)T);
            } else {
                logger.debug("The Type {} is not in the ClassHierarchy! Returning null as instance", (Object)T);
            }
            this.body.addConstant(Integer.valueOf(instance.getNumber()), new ConstantValue(null));
            instance.setAssigned();
            return instance;
        }
        if (this.isExcluded(klass)) {
            this.body.addConstant(Integer.valueOf(instance.getNumber()), new ConstantValue(null));
            instance.setAssigned();
            return instance;
        }
        Set<TypeReference> types = this.getTypes(T);
        logger.info("Creating instance of {} is  {}", (Object)T, types);
        if (types.isEmpty()) {
            throw new IllegalStateException("Types of " + T + " are empty");
        }
        if (!(types.size() != 1 || klass.isAbstract() || klass.isArrayClass() || klass.isInterface())) {
            SSANewInstruction newInst = this.addNew(instance);
            this.selectAndCallCtor(instance, seen);
            if (asManaged) {
                this.pm.setAllocation(instance, (SSAInstruction)newInst);
            }
            assert (newInst.getDef() == instance.getNumber());
            return instance;
        }
        if (klass.isArrayClass()) {
            logger.info("Creating Array-Class {}", (Object)klass);
            TypeReference payloadType = T.getArrayElementType();
            SSAValue payload = null;
            for (SSAValue sSAValue : seen) {
                if (!ParameterAccessor.isAssignable((TypeReference)sSAValue.getType(), (TypeReference)payloadType, (IClassHierarchy)this.cha)) continue;
                logger.trace("Reusing {} for array payload {}", (Object)sSAValue, (Object)payload);
                payload = sSAValue;
            }
            if (payload == null) {
                payload = this.createInstance(payloadType, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), seen);
            }
            int n = this.body.getNextProgramCounter();
            NewSiteReference nRef = NewSiteReference.make((int)n, (TypeReference)instance.getType());
            SSAValue arrayLength = this.pm.getUnmanaged(TypeReference.Int, (SSAValue.VariableKey)new SSAValue.UniqueKey());
            this.body.addConstant(Integer.valueOf(arrayLength.getNumber()), new ConstantValue(1));
            arrayLength.setAssigned();
            ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
            params.add(arrayLength);
            SSANewInstruction sSANewInstruction = this.instructionFactory.NewInstruction(n, instance, nRef, params);
            this.body.addStatement((SSAInstruction)sSANewInstruction);
            assert (instance.getNumber() == sSANewInstruction.getDef());
            int n2 = this.body.getNextProgramCounter();
            SSAArrayStoreInstruction write = this.instructionFactory.ArrayStoreInstruction(n2, instance, 0, payload);
            this.body.addStatement((SSAInstruction)write);
            assert (sSANewInstruction.getDef() == instance.getNumber());
            return instance;
        }
        logger.debug("Not a regular class {}", (Object)T);
        HashSet<SSAValue> subInstances = new HashSet<SSAValue>();
        for (TypeReference typeReference : types) {
            IClass iClass = this.cha.lookupClass(typeReference);
            if (iClass.isAbstract() || iClass.isInterface()) continue;
            SSAValue subInstance = this.pm.getUnmanaged(typeReference, (SSAValue.VariableKey)new SSAValue.UniqueKey());
            SSANewInstruction newInst = this.addNew(subInstance);
            this.selectAndCallCtor(subInstance, seen);
            assert (subInstance.getNumber() == newInst.getDef()) : "Unexpected: number and def differ: " + subInstance.getNumber() + ", " + newInst.getDef();
            HashSet<? extends SSAValue> newSeen = new HashSet<SSAValue>(seen);
            newSeen.add((SSAValue)subInstance);
            seen = newSeen;
            subInstances.add(subInstance);
        }
        PrimitiveType abstraction = null;
        for (TypeReference typeReference : types) {
            IClass cls;
            if (typeReference.isPrimitiveType()) {
                cls = null;
            } else {
                cls = this.cha.lookupClass(typeReference);
                assert (cls != null);
            }
            if (abstraction == null) {
                if (typeReference.isPrimitiveType()) {
                    abstraction = PrimitiveType.getPrimitive((TypeReference)typeReference);
                    continue;
                }
                abstraction = new ConeType(cls);
                continue;
            }
            if (typeReference.isPrimitiveType()) {
                abstraction = abstraction.meet((TypeAbstraction)PrimitiveType.getPrimitive((TypeReference)typeReference));
                continue;
            }
            abstraction = abstraction.meet((TypeAbstraction)new ConeType(cls));
        }
        if (subInstances.size() > 0) {
            int n = this.body.getNextProgramCounter();
            SSAPhiInstruction sSAPhiInstruction = this.instructionFactory.PhiInstruction(n, instance, subInstances);
            this.body.addStatement((SSAInstruction)sSAPhiInstruction);
            if (asManaged) {
                this.pm.setPhi(instance, (SSAInstruction)sSAPhiInstruction);
            }
        } else {
            logger.warn("No sub-instances for: {} - setting to null", (Object)instance);
            this.body.addConstant(Integer.valueOf(instance.getNumber()), new ConstantValue(null));
            instance.setAssigned();
        }
        return instance;
    }

    private static void createPrimitive(SSAValue instance) {
        instance.setAssigned();
    }

    private SSANewInstruction addNew(SSAValue val) {
        int pc = this.body.getNextProgramCounter();
        NewSiteReference nRef = NewSiteReference.make((int)pc, (TypeReference)val.getType());
        SSANewInstruction newInstr = this.instructionFactory.NewInstruction(pc, val, nRef);
        this.body.addStatement((SSAInstruction)newInstr);
        assert (val.getNumber() == newInstr.getDef());
        return newInstr;
    }

    private void addCallCtor(SSAValue self, MethodReference ctor, List<SSAValue> ctorParams) {
        int pc = this.body.getNextProgramCounter();
        SSAValue exception = this.pm.getException();
        CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)ctor, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1 + ctorParams.size());
        params.add(self);
        params.addAll(ctorParams);
        SSAAbstractInvokeInstruction ctorCall = this.instructionFactory.InvokeInstruction(pc, params, exception, site);
        this.body.addStatement((SSAInstruction)ctorCall);
    }

    private MethodReference selectAndCallCtor(SSAValue val, Set<? extends SSAValue> overrides) {
        IMethod cTor = this.lookupConstructor(val.getType());
        ParameterAccessor ctorAcc = new ParameterAccessor(cTor);
        assert (ctorAcc.hasImplicitThis()) : "CTor detected as not having implicit this pointer";
        logger.debug("Acc for: {}", (Object)this.scope);
        ParameterAccessor acc = new ParameterAccessor(this.scope, false);
        SSAValue nullSelf = this.pm.getUnmanaged(val.getType(), (SSAValue.VariableKey)new SSAValue.UniqueKey());
        this.body.addConstant(Integer.valueOf(nullSelf.getNumber()), new ConstantValue(null));
        nullSelf.setAssigned();
        HashSet<Object> seen = new HashSet<Object>(1 + overrides.size());
        seen.add(nullSelf);
        seen.addAll(overrides);
        logger.debug("Recursing for: {}", (Object)cTor);
        logger.debug("With seen: {}", seen);
        List ctorParams = acc.connectThrough(ctorAcc, overrides, null, this.cha, (IInstantiator)this, new Object[]{false, null, seen});
        this.addCallCtor(val, cTor.getReference(), ctorParams);
        return cTor.getReference();
    }

    private Set<TypeReference> getTypes(TypeReference T) {
        IClass cls = this.cha.lookupClass(T);
        if (this.isExcluded(cls)) {
            return new HashSet<TypeReference>();
        }
        return this.getTypes(T, Collections.emptySet());
    }

    private Set<TypeReference> getTypes(TypeReference T, Set<TypeReference> seen) {
        logger.debug("getTypes({}, {})", (Object)T, seen);
        HashSet<TypeReference> ret = new HashSet<TypeReference>();
        ret.add(T);
        if (T.isPrimitiveType()) {
            logger.warn("getTypes called on a primitive");
            return ret;
        }
        IClass cls = this.cha.lookupClass(T);
        if (cls == null) {
            logger.error("The type {} is not in the ClassHierarchy - try continuing anyway", (Object)T);
            return ret;
        }
        if (this.isExcluded(cls)) {
            return ret;
        }
        if (seen.contains(T)) {
            return ret;
        }
        if (cls.isInterface()) {
            Set impls = this.cha.getImplementors(T);
            if (impls.isEmpty()) {
                if (!T.getName().toString().startsWith("Landroid/")) {
                    logger.error("The interface {} has no known implementors - skipping over it", (Object)T);
                } else {
                    logger.debug("The interface {} has no known implementors - skipping over it", (Object)T);
                }
                return ret;
            }
            for (IClass impl : impls) {
                if (impl.isAbstract()) {
                    ret.addAll(this.getTypes(impl.getReference(), ret));
                    continue;
                }
                ret.add(impl.getReference());
            }
        } else if (cls.isAbstract()) {
            Collection subs = this.cha.computeSubClasses(T);
            if (subs.isEmpty()) {
                throw new IllegalStateException("The class " + T + " is abstract but has no subclasses known to the ClassHierarchy");
            }
            for (IClass sub : subs) {
                if (seen.contains(sub.getReference())) {
                    logger.debug("Seen: {}", (Object)sub);
                    continue;
                }
                if (sub.isAbstract()) {
                    ret.addAll(this.getTypes(sub.getReference(), ret));
                    continue;
                }
                ret.add(sub.getReference());
            }
        } else if (cls.isArrayClass()) {
            ArrayClass aCls = (ArrayClass)cls;
            int dim = aCls.getDimensionality();
            if (aCls.isOfPrimitives()) {
                ret.add(aCls.getReference());
            } else {
                IClass inner = aCls.getInnermostElementClass();
                if (inner == null) {
                    throw new IllegalStateException("The array " + T + " has no inner class");
                }
                if (inner.isInterface() || inner.isAbstract()) {
                    Set<TypeReference> innerTypes = this.getTypes(inner.getReference(), Collections.emptySet());
                    for (TypeReference iT : innerTypes) {
                        TypeReference aT = TypeReference.findOrCreateArrayOf((TypeReference)iT);
                        for (int i = 1; i < dim; ++i) {
                            aT = TypeReference.findOrCreateArrayOf((TypeReference)aT);
                        }
                        ret.add(aT);
                    }
                } else {
                    ret.add(TypeReference.findOrCreateArrayOf((TypeReference)inner.getReference()));
                }
            }
        }
        return ret;
    }

    private List<TypeReference> getAllSuper(TypeReference T) {
        if (T.isPrimitiveType()) {
            throw new IllegalArgumentException("Not you that call primitive type on :P");
        }
        ArrayList<TypeReference> ret = new ArrayList<TypeReference>();
        IClass cls = this.cha.lookupClass(T);
        if (cls == null) {
            throw new IllegalArgumentException("The type " + T + " is not in the ClassHierarchy");
        }
        while (cls != null) {
            ret.add(cls.getReference());
            cls = cls.getSuperclass();
        }
        return ret;
    }

    private IMethod lookupConstructor(TypeReference T) {
        IMethod ctor = null;
        int score = -10000;
        IClass klass = this.cha.lookupClass(T);
        if (klass == null) {
            throw new IllegalArgumentException("Unable to look up the class for " + T);
        }
        if (klass.isInterface() || klass.isAbstract()) {
            throw new IllegalArgumentException("Class is interface or abstract");
        }
        for (IMethod im : klass.getDeclaredMethods()) {
            if (!im.isInit()) continue;
            int candidScore = 0;
            int paramCount = im.getNumberOfParameters();
            if (im.isPrivate()) {
                score -= 10;
            } else if (im.isProtected()) {
                --score;
            }
            for (int i = 1; i < paramCount; ++i) {
                TypeReference paramType = im.getParameterType(i);
                if (paramType.isPrimitiveType()) {
                    --candidScore;
                    continue;
                }
                if (paramType.isArrayType()) {
                    candidScore -= 30;
                    if (!paramType.getInnermostElementType().equals((Object)T)) continue;
                    candidScore -= 1000;
                    continue;
                }
                if (paramType.isClassType()) {
                    candidScore -= 101;
                    continue;
                }
                if (paramType.isReferenceType()) {
                    candidScore = paramType.equals((Object)T) ? (candidScore -= 1000) : (candidScore -= 7);
                    if (!paramType.equals((Object)TypeReference.JavaLangObject)) continue;
                    candidScore -= 1500;
                    continue;
                }
                candidScore -= 800;
            }
            if (candidScore > score) {
                ctor = im;
                score = candidScore;
            }
            logger.debug("CTor {} got score {}", (Object)im, (Object)candidScore);
        }
        if (ctor == null) {
            logger.warn("Still found no CTor for {}", (Object)T);
            return this.cha.resolveMethod(klass, MethodReference.initSelector);
        }
        return ctor;
    }

    public int createInstance(TypeReference type, Object ... instantiatorArgs) {
        Object o;
        Set seen;
        if (!(instantiatorArgs[0] instanceof Boolean)) {
            throw new IllegalArgumentException("Argument 0 to createInstance has to be boolean.");
        }
        if (instantiatorArgs[1] != null && !(instantiatorArgs[1] instanceof SSAValue.VariableKey)) {
            throw new IllegalArgumentException("Argument 1 to createInstance has to be null or an instance of VariableKey");
        }
        if (instantiatorArgs[2] != null && !(instantiatorArgs[2] instanceof Set)) {
            throw new IllegalArgumentException("Argument 2 to createInstance has to be null or an instance of Set<? extends SSAValue>, got: " + instantiatorArgs[2].getClass());
        }
        if (instantiatorArgs[2] != null && !(seen = (Set)instantiatorArgs[2]).isEmpty() && !((o = seen.iterator().next()) instanceof SSAValue)) {
            throw new IllegalArgumentException("Argument 2 to createInstance has to be null or an instance of Set<? extends SSAValue>, got Set<" + o.getClass() + '>');
        }
        return this.createInstance(type, (Boolean)instantiatorArgs[0], (SSAValue.VariableKey)instantiatorArgs[1], (Set)instantiatorArgs[2]).getNumber();
    }
}

