/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.dalvik.dex.instructions.SwitchPad;
import org.jf.dexlib2.Opcode;

public class Switch
extends Instruction {
    public final int regA;
    public final int tableAddressOffset;
    public SwitchPad pad;
    private int[] casesAndLabels;
    private int defaultLabel;

    public Switch(int instLoc, int regA, int tableAddressOffset, Opcode opcode, DexIMethod method) {
        super(instLoc, opcode, method);
        this.regA = regA;
        this.tableAddressOffset = tableAddressOffset;
    }

    public void setSwitchPad(SwitchPad pad) {
        this.pad = pad;
        this.computeCasesAndLabels();
    }

    private void computeCasesAndLabels() {
        this.casesAndLabels = this.pad.getLabelsAndOffsets();
        for (int i = 1; i < this.casesAndLabels.length; i += 2) {
            this.casesAndLabels[i] = this.pc + this.casesAndLabels[i];
        }
        this.defaultLabel = this.pc + this.pad.getDefaultOffset();
    }

    public int[] getOffsets() {
        return this.pad.getOffsets();
    }

    public int getDefaultLabel() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    @Override
    public int[] getBranchTargets() {
        int[] r = new int[this.casesAndLabels.length / 2 + 1];
        r[0] = this.method.getInstructionIndex(this.defaultLabel);
        for (int i = 1; i < r.length; ++i) {
            r[i] = this.method.getInstructionIndex(this.casesAndLabels[(i - 1) * 2 + 1]);
        }
        return r;
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitSwitch(this);
    }
}

