/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import org.jf.dexlib2.Opcode;

public abstract class Branch
extends Instruction {
    public final int offset;
    private int label;

    protected Branch(int instLoc, int offset, Opcode opcode, DexIMethod method) {
        super(instLoc, opcode, method);
        this.offset = offset;
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitBranch(this);
    }

    public abstract IConditionalBranchInstruction.IOperator getOperator();

    @Override
    public int[] getBranchTargets() {
        this.label = this.method.getInstructionIndex(this.pc + this.offset);
        int[] r = new int[]{this.label};
        return r;
    }

    public static class BinaryBranch
    extends Branch {
        public final int oper1;
        public final int oper2;
        public final CompareOp op;

        public BinaryBranch(int instLoc, int offset, CompareOp op, int oper1, int oper2, Opcode opcode, DexIMethod method) {
            super(instLoc, offset, opcode, method);
            this.op = op;
            this.oper1 = oper1;
            this.oper2 = oper2;
        }

        @Override
        public IConditionalBranchInstruction.IOperator getOperator() {
            switch (this.op) {
                case EQ: {
                    return IConditionalBranchInstruction.Operator.EQ;
                }
                case NE: {
                    return IConditionalBranchInstruction.Operator.NE;
                }
                case LT: {
                    return IConditionalBranchInstruction.Operator.LT;
                }
                case LE: {
                    return IConditionalBranchInstruction.Operator.LE;
                }
                case GT: {
                    return IConditionalBranchInstruction.Operator.GT;
                }
                case GE: {
                    return IConditionalBranchInstruction.Operator.GE;
                }
            }
            return null;
        }

        public static enum CompareOp {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;

        }
    }

    public static class UnaryBranch
    extends Branch {
        public final int oper1;
        public final CompareOp op;

        public UnaryBranch(int instLoc, int offset, CompareOp op, int oper1, Opcode opcode, DexIMethod method) {
            super(instLoc, offset, opcode, method);
            this.op = op;
            this.oper1 = oper1;
        }

        @Override
        public IConditionalBranchInstruction.IOperator getOperator() {
            switch (this.op) {
                case EQZ: {
                    return IConditionalBranchInstruction.Operator.EQ;
                }
                case NEZ: {
                    return IConditionalBranchInstruction.Operator.NE;
                }
                case LTZ: {
                    return IConditionalBranchInstruction.Operator.LT;
                }
                case LEZ: {
                    return IConditionalBranchInstruction.Operator.LE;
                }
                case GTZ: {
                    return IConditionalBranchInstruction.Operator.GT;
                }
                case GEZ: {
                    return IConditionalBranchInstruction.Operator.GE;
                }
            }
            return null;
        }

        public static enum CompareOp {
            EQZ,
            NEZ,
            LTZ,
            LEZ,
            GTZ,
            GEZ;

        }
    }
}

