/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.core.util.warnings.Warning;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.dalvik.classLoader.DexIClass;
import com.ibm.wala.dalvik.classLoader.DexModuleEntry;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WDexClassLoaderImpl
extends ClassLoaderImpl {
    private final IClassLoader lParent;
    private final SetOfClasses exclusions;

    public WDexClassLoaderImpl(ClassLoaderReference loader, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) {
        super(loader, cha.getScope().getArrayClassLoader(), parent, exclusions, cha);
        this.lParent = parent;
        this.exclusions = exclusions;
    }

    public void init(List<Module> modules) throws IOException {
        super.init(modules);
        HashSet classModuleEntries = HashSetFactory.make();
        for (Module archive : modules) {
            Set<ModuleEntry> classFiles = WDexClassLoaderImpl.getDexFiles(archive);
            WDexClassLoaderImpl.removeClassFiles(classFiles, classModuleEntries);
            this.loadAllDexClasses(classFiles);
            classModuleEntries.addAll(classFiles);
        }
    }

    private static void removeClassFiles(Set<ModuleEntry> s, Set<ModuleEntry> t) {
        s.removeAll(t);
    }

    private static Set<ModuleEntry> getDexFiles(Module M) {
        HashSet result = HashSetFactory.make();
        for (ModuleEntry entry : Iterator2Iterable.make((Iterator)M.getEntries())) {
            if (!(entry instanceof DexModuleEntry)) continue;
            result.add(entry);
        }
        return result;
    }

    private void loadAllDexClasses(Collection<ModuleEntry> moduleEntries) {
        for (ModuleEntry entry : moduleEntries) {
            if (!(entry instanceof DexModuleEntry)) continue;
            DexModuleEntry dexEntry = (DexModuleEntry)entry;
            String className = dexEntry.getClassName();
            TypeName tName = TypeName.string2TypeName((String)className);
            if (this.loadedClasses.get(tName) != null) {
                Warnings.add((Warning)MultipleDexImplementationsWarning.create(className));
                continue;
            }
            if (this.lParent != null && this.lParent.lookupClass(tName) != null) {
                Warnings.add((Warning)MultipleDexImplementationsWarning.create(className));
                continue;
            }
            DexIClass iClass = new DexIClass((IClassLoader)this, this.cha, dexEntry);
            if (iClass.getReference().getName().equals((Object)tName)) {
                if (this.exclusions != null && this.exclusions.contains(className.substring(1))) continue;
                this.loadedClasses.put(tName, iClass);
                continue;
            }
            Warnings.add((Warning)InvalidDexFile.create(className));
        }
    }

    public IClassHierarchy getClassHierarcy() {
        return this.cha;
    }

    private static class InvalidDexFile
    extends Warning {
        final String className;

        InvalidDexFile(String className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return ((Object)((Object)this)).getClass().toString() + " : " + this.className;
        }

        public static InvalidDexFile create(String className) {
            return new InvalidDexFile(className);
        }
    }

    private static class MultipleDexImplementationsWarning
    extends Warning {
        final String className;

        MultipleDexImplementationsWarning(String className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return ((Object)((Object)this)).getClass().toString() + " : " + this.className;
        }

        public static MultipleDexImplementationsWarning create(String className) {
            return new MultipleDexImplementationsWarning(className);
        }
    }
}

