/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.strings.ImmutableByteArray;
import com.ibm.wala.dalvik.classLoader.DexFileModule;
import com.ibm.wala.dalvik.classLoader.DexIField;
import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.classLoader.DexModuleEntry;
import com.ibm.wala.dalvik.classLoader.DexUtil;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.AnnotationVisibility;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;

public class DexIClass
extends BytecodeClass<IClassLoader> {
    private final ClassDef classDef;
    private final int modifiers;
    private IMethod[] methods = null;
    private int clinitId = -1;
    private final DexModuleEntry dexModuleEntry;

    public DexIClass(IClassLoader loader, IClassHierarchy cha, DexModuleEntry dexEntry) {
        super(loader, cha);
        String descriptor;
        this.dexModuleEntry = dexEntry;
        this.classDef = dexEntry.getClassDefItem();
        this.modifiers = this.classDef.getAccessFlags();
        this.typeReference = TypeReference.findOrCreate((ClassLoaderReference)loader.getReference(), (String)dexEntry.getClassName());
        this.hashCode = 2161 * this.getReference().hashCode();
        String string = descriptor = this.classDef.getSuperclass() != null ? this.classDef.getSuperclass() : null;
        if (descriptor != null && descriptor.endsWith(";")) {
            descriptor = descriptor.substring(0, descriptor.length() - 1);
        }
        this.superName = descriptor != null ? ImmutableByteArray.make((String)descriptor) : null;
        List intfList = this.classDef.getInterfaces();
        int size = intfList == null ? 0 : intfList.size();
        this.interfaceNames = new ImmutableByteArray[size];
        for (int i = 0; i < size; ++i) {
            descriptor = (String)intfList.get(i);
            if (descriptor.endsWith(";")) {
                descriptor = descriptor.substring(0, descriptor.length() - 1);
            }
            this.interfaceNames[i] = ImmutableByteArray.make((String)descriptor);
        }
        Iterable encInstFields = this.classDef.getInstanceFields();
        ArrayList<DexIField> ifs = new ArrayList<DexIField>();
        for (Field dexf : encInstFields) {
            ifs.add(new DexIField(dexf, this));
        }
        this.instanceFields = ifs.toArray(new IField[0]);
        Iterable encStatFields = this.classDef.getStaticFields();
        ArrayList<DexIField> sfs = new ArrayList<DexIField>();
        for (Field dexf : encStatFields) {
            sfs.add(new DexIField(dexf, this));
        }
        this.staticFields = sfs.toArray(new IField[0]);
    }

    public ClassDef getClassDefItem() {
        return this.classDef;
    }

    public boolean isPublic() {
        return (this.modifiers & AccessFlags.PUBLIC.getValue()) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & AccessFlags.PRIVATE.getValue()) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & AccessFlags.INTERFACE.getValue()) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & AccessFlags.ABSTRACT.getValue()) != 0;
    }

    public boolean isSynthetic() {
        return (this.modifiers & AccessFlags.SYNTHETIC.getValue()) != 0;
    }

    public int getModifiers() throws UnsupportedOperationException {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DexIClass) {
            return this.getReference().equals((Object)((DexIClass)((Object)obj)).getReference());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    Collection<Annotation> getAnnotations(Set<String> types) {
        HashSet result = HashSetFactory.make();
        for (org.jf.dexlib2.iface.Annotation a : this.classDef.getAnnotations()) {
            if (types != null && !types.contains(AnnotationVisibility.getVisibility((int)a.getVisibility()))) continue;
            result.add(DexUtil.getAnnotation(a, this.getClassLoader().getReference()));
        }
        return result;
    }

    public Collection<Annotation> getAnnotations() {
        return this.getAnnotations((Set<String>)null);
    }

    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) {
        return this.getAnnotations(DexIClass.getTypes(runtimeInvisible));
    }

    static Set<String> getTypes(boolean runtimeInvisible) {
        HashSet types = HashSetFactory.make();
        types.add(AnnotationVisibility.getVisibility((int)2));
        if (runtimeInvisible) {
            types.add(AnnotationVisibility.getVisibility((int)0));
        } else {
            types.add(AnnotationVisibility.getVisibility((int)1));
        }
        return types;
    }

    List<Annotation> getAnnotations(Method m, Set<String> set) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (org.jf.dexlib2.iface.Annotation a : m.getAnnotations()) {
            if (set != null && !set.contains(AnnotationVisibility.getVisibility((int)a.getVisibility()))) continue;
            result.add(DexUtil.getAnnotation(a, this.getClassLoader().getReference()));
        }
        return result;
    }

    Collection<Annotation> getAnnotations(Field m) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (org.jf.dexlib2.iface.Annotation a : m.getAnnotations()) {
            result.add(DexUtil.getAnnotation(a, this.getClassLoader().getReference()));
        }
        return result;
    }

    Map<Integer, List<Annotation>> getParameterAnnotations(Method m) {
        HashMap result = HashMapFactory.make();
        int i = 0;
        for (MethodParameter as : m.getParameters()) {
            for (org.jf.dexlib2.iface.Annotation a : as.getAnnotations()) {
                if (!result.containsKey(i)) {
                    result.put(i, new ArrayList());
                }
                ((List)result.get(i)).add(DexUtil.getAnnotation(a, this.getClassLoader().getReference()));
            }
            ++i;
        }
        return result;
    }

    protected IMethod[] computeDeclaredMethods() {
        ArrayList<DexIMethod> methodsAL = new ArrayList<DexIMethod>();
        if (this.methods == null) {
            Iterable directMethods = this.classDef.getDirectMethods();
            Iterable virtualMethods = this.classDef.getVirtualMethods();
            int i = 0;
            for (Method dMethod : directMethods) {
                DexIMethod method = new DexIMethod(dMethod, this);
                methodsAL.add(method);
                if (method.isClinit()) {
                    this.clinitId = i;
                }
                ++i;
            }
            for (Method dexm : virtualMethods) {
                methodsAL.add(new DexIMethod(dexm, this));
            }
        }
        if (this.methods == null) {
            this.methods = methodsAL.toArray(new IMethod[0]);
        }
        return this.methods;
    }

    public IMethod getClassInitializer() {
        if (this.methods == null) {
            this.computeDeclaredMethods();
        }
        return this.clinitId != -1 ? this.methods[this.clinitId] : null;
    }

    public DexFileModule getContainer() {
        return this.dexModuleEntry.getContainer();
    }
}

