/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.dalvik.analysis.typeInference.DalvikTypeVariable;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;

public class DalvikTypeInference
extends TypeInference {
    private static final AbstractOperator<TypeVariable> dalvikPhiOp = new DalvikPhiOperator();

    protected TypeVariable[] makeStmtRHS(int size) {
        return new DalvikTypeVariable[size];
    }

    protected DalvikTypeInference(IR ir, boolean doPrimitives) {
        super(ir, doPrimitives);
    }

    protected void initialize() {
        this.init(this.ir, (SSAInference.VariableFactory)new DalvikTypeVarFactory(), (SSAInference.OperatorFactory)new TypeOperatorFactory());
    }

    public static DalvikTypeInference make(IR ir, boolean doPrimitives) {
        return new DalvikTypeInference(ir, doPrimitives);
    }

    private static final class DalvikPhiOperator
    extends AbstractOperator<TypeVariable> {
        private DalvikPhiOperator() {
        }

        public byte evaluate(TypeVariable _lhs, TypeVariable[] _rhs) {
            assert (_lhs instanceof DalvikTypeVariable);
            assert (_rhs instanceof DalvikTypeVariable[]);
            DalvikTypeVariable lhs = (DalvikTypeVariable)_lhs;
            DalvikTypeVariable[] rhs = (DalvikTypeVariable[])_rhs;
            TypeAbstraction lhsType = lhs.getType();
            TypeAbstraction meet = TypeAbstraction.TOP;
            boolean ignoreZero = DalvikPhiOperator.containsNonPrimitiveAndZero(rhs);
            for (DalvikTypeVariable rh : rhs) {
                if (rh == null || rh.getType() == null || ignoreZero && rh.isIntZeroConstant()) continue;
                meet = meet.meet(rh.getType());
            }
            if (lhsType.equals((Object)meet)) {
                return 0;
            }
            lhs.setType(meet);
            return 1;
        }

        private static boolean containsNonPrimitiveAndZero(DalvikTypeVariable[] types) {
            boolean containsNonPrimitive = false;
            boolean containsZero = false;
            for (DalvikTypeVariable type : types) {
                if (type == null) continue;
                if (type.getType() != null && type.getType().getTypeReference() != null && !type.getType().getTypeReference().isPrimitiveType()) {
                    containsNonPrimitive = true;
                }
                if (!type.isIntZeroConstant()) continue;
                containsZero = true;
            }
            return containsNonPrimitive && containsZero;
        }

        public String toString() {
            return "phi meet (dalvik)";
        }

        public int hashCode() {
            return 2297;
        }

        public boolean equals(Object o) {
            return o instanceof DalvikPhiOperator;
        }
    }

    protected class TypeOperatorFactory
    extends TypeInference.TypeOperatorFactory {
        protected TypeOperatorFactory() {
            super((TypeInference)DalvikTypeInference.this);
        }

        public void visitPhi(SSAPhiInstruction instruction) {
            assert (dalvikPhiOp != null);
            this.result = dalvikPhiOp;
        }
    }

    public class DalvikTypeVarFactory
    extends TypeInference.TypeVarFactory {
        public DalvikTypeVarFactory() {
            super((TypeInference)DalvikTypeInference.this);
        }

        public TypeVariable makeVariable(int valueNumber) {
            SymbolTable st = DalvikTypeInference.this.ir.getSymbolTable();
            if (st.isIntegerConstant(valueNumber) && st.isZero(valueNumber)) {
                return new DalvikTypeVariable((TypeAbstraction)DalvikTypeInference.this.language.getPrimitive(DalvikTypeInference.this.language.getConstantType((Object)0)), true);
            }
            if (DalvikTypeInference.this.doPrimitives && st.isConstant(valueNumber) && st.isBooleanConstant(valueNumber)) {
                return new DalvikTypeVariable((TypeAbstraction)DalvikTypeInference.this.language.getPrimitive(DalvikTypeInference.this.language.getConstantType((Object)Boolean.TRUE)));
            }
            return new DalvikTypeVariable(TypeAbstraction.TOP);
        }
    }
}

