/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public class CAstPrinter {
    private static CAstPrinter instance = new CAstPrinter();

    public static void setPrinter(CAstPrinter printer) {
        instance = printer;
    }

    public static String kindAsString(int kind) {
        return instance.getKindAsString(kind);
    }

    public String getKindAsString(int kind) {
        switch (kind) {
            case 1: {
                return "SWITCH";
            }
            case 2: {
                return "LOOP";
            }
            case 3: {
                return "BLOCK";
            }
            case 4: {
                return "TRY";
            }
            case 5: {
                return "EXPR_STMT";
            }
            case 6: {
                return "DECL_STMT";
            }
            case 7: {
                return "RETURN";
            }
            case 8: {
                return "GOTO";
            }
            case 9: {
                return "BREAK";
            }
            case 10: {
                return "CONTINUE";
            }
            case 11: {
                return "IF_STMT";
            }
            case 12: {
                return "THROW";
            }
            case 13: {
                return "FUNCTION_STMT";
            }
            case 14: {
                return "ASSIGN";
            }
            case 15: {
                return "ASSIGN_PRE_OP";
            }
            case 16: {
                return "ASSIGN_POST_OP";
            }
            case 17: {
                return "LABEL_STMT";
            }
            case 18: {
                return "IFGOTO";
            }
            case 19: {
                return "EMPTY";
            }
            case 26: {
                return "YIELD";
            }
            case 21: {
                return "CATCH";
            }
            case 22: {
                return "UNWIND";
            }
            case 23: {
                return "MONITOR_ENTER";
            }
            case 24: {
                return "MONITOR_EXIT";
            }
            case 25: {
                return "ECHO";
            }
            case 27: {
                return "FOR..IN";
            }
            case 100: {
                return "FUNCTION_EXPR";
            }
            case 101: {
                return "EXPR_LIST";
            }
            case 102: {
                return "CALL";
            }
            case 103: {
                return "EXCEPTION";
            }
            case 104: {
                return "BLOCK_EXPR";
            }
            case 105: {
                return "BINARY_EXPR";
            }
            case 106: {
                return "UNARY_EXPR";
            }
            case 107: {
                return "IF_EXPR";
            }
            case 108: {
                return "ANDOR_EXPR";
            }
            case 109: {
                return "NEW";
            }
            case 131: {
                return "NEW_ENCLOSING";
            }
            case 110: {
                return "OBJECT_LITERAL";
            }
            case 111: {
                return "VAR";
            }
            case 112: {
                return "OBJECT_REF";
            }
            case 113: {
                return "CHOICE_EXPR";
            }
            case 114: {
                return "CHOICE_CASE";
            }
            case 115: {
                return "SUPER";
            }
            case 116: {
                return "THIS";
            }
            case 117: {
                return "ARRAY_LITERAL";
            }
            case 118: {
                return "CAST";
            }
            case 119: {
                return "INSTANCEOF";
            }
            case 120: {
                return "ARRAY_REF";
            }
            case 121: {
                return "ARRAY_LENGTH";
            }
            case 122: {
                return "TYPE_OF";
            }
            case 123: {
                return "EACH_ELEMENT_HAS_NEXT";
            }
            case 124: {
                return "EACH_ELEMENT_GET";
            }
            case 125: {
                return "LIST_EXPR";
            }
            case 126: {
                return "EMPTY_LIST_EXPR";
            }
            case 128: {
                return "IS_DEFINED_EXPR";
            }
            case 130: {
                return "NARY_EXPR";
            }
            case 200: {
                return "SCOPE";
            }
            case 201: {
                return "SPECIAL PARENT SCOPE";
            }
            case 300: {
                return "CONSTANT";
            }
            case 301: {
                return "OPERATOR";
            }
            case 400: {
                return "PRIMITIVE";
            }
            case 402: {
                return "VOID";
            }
            case 401: {
                return "ERROR";
            }
            case 403: {
                return "ASSERT";
            }
        }
        return "UNKNOWN(" + kind + ')';
    }

    public static String print(CAstNode top) {
        return instance.doPrint(top);
    }

    public String doPrint(CAstNode top) {
        return CAstPrinter.print(top, null);
    }

    public static String print(CAstNode top, CAstSourcePositionMap pos) {
        return instance.doPrint(top, pos);
    }

    public String doPrint(CAstNode top, CAstSourcePositionMap pos) {
        StringBuilder sb = new StringBuilder();
        try (StringWriter writer = new StringWriter(sb);){
            CAstPrinter.printTo(top, pos, writer);
        }
        return sb.toString();
    }

    public String doPrint(CAstEntity ce) {
        StringBuilder sb = new StringBuilder();
        try (StringWriter writer = new StringWriter(sb);){
            CAstPrinter.printTo(ce, (Writer)writer);
        }
        return sb.toString();
    }

    public static String print(CAstEntity ce) {
        return instance.doPrint(ce);
    }

    public static void printTo(CAstNode top, Writer w) {
        instance.doPrintTo(top, w);
    }

    public void doPrintTo(CAstNode top, Writer w) {
        CAstPrinter.printTo(top, null, w, 0, false);
    }

    public static void printTo(CAstNode top, CAstSourcePositionMap pos, Writer w) {
        instance.doPrintTo(top, pos, w);
    }

    public void doPrintTo(CAstNode top, CAstSourcePositionMap pos, Writer w) {
        CAstPrinter.printTo(top, pos, w, 0, false);
    }

    public static void xmlTo(CAstNode top, Writer w) {
        instance.doXmlTo(top, w);
    }

    public void doXmlTo(CAstNode top, Writer w) {
        CAstPrinter.printTo(top, null, w, 0, true);
    }

    public static void xmlTo(CAstNode top, CAstSourcePositionMap pos, Writer w) {
        CAstPrinter.doXmlTo(top, pos, w);
    }

    private static void doXmlTo(CAstNode top, CAstSourcePositionMap pos, Writer w) {
        CAstPrinter.printTo(top, pos, w, 0, true);
    }

    private static String escapeForXML(String x, char from, String to) {
        return x.indexOf(from) != -1 ? x.replaceAll(Character.toString(from), to) : x;
    }

    public static String escapeForXML(String x) {
        return CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(x, '&', "&amp;"), '\"', "&quot;"), '<', "&lt;"), '>', "&gt;");
    }

    public static void printTo(CAstNode top, CAstSourcePositionMap pos, Writer w, int depth, boolean uglyBrackets) {
        instance.doPrintTo(top, pos, w, depth, uglyBrackets);
    }

    public void doPrintTo(CAstNode top, CAstSourcePositionMap pos, Writer w, int depth, boolean uglyBrackets) {
        try {
            CAstSourcePositionMap.Position p = pos != null ? pos.getPosition(top) : null;
            for (int i = 0; i < depth; ++i) {
                w.write("  ");
            }
            if (top == null) {
                w.write("(null)\n");
            } else if (top.getValue() != null) {
                if (uglyBrackets) {
                    w.write("<constant value=\"");
                    w.write(CAstPrinter.escapeForXML(top.getValue().toString()));
                    w.write("\" type=\"");
                    w.write(top.getValue().getClass().toString());
                    w.write("\"");
                } else {
                    w.write("\"");
                    w.write(top.getValue().toString());
                    w.write("\"");
                }
                if (p != null) {
                    if (uglyBrackets) {
                        w.write(" lineNumber=\"" + p + '\"');
                    } else {
                        w.write(" at " + p);
                    }
                }
                if (uglyBrackets) {
                    w.write("/>");
                }
                w.write("\n");
            } else {
                if (uglyBrackets) {
                    w.write("<");
                }
                w.write(CAstPrinter.kindAsString(top.getKind()));
                if (p != null) {
                    if (uglyBrackets) {
                        w.write(" position=\"" + p + '\"');
                    } else {
                        w.write(" at " + p);
                    }
                }
                if (uglyBrackets) {
                    w.write(">");
                }
                w.write("\n");
                for (CAstNode child : top.getChildren()) {
                    this.doPrintTo(child, pos, w, depth + 1, uglyBrackets);
                }
                if (uglyBrackets) {
                    for (int i = 0; i < depth; ++i) {
                        w.write("  ");
                    }
                    w.write("</" + CAstPrinter.kindAsString(top.getKind()) + ">\n");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String entityKindAsString(int kind) {
        return instance.getEntityKindAsString(kind);
    }

    public String getEntityKindAsString(int kind) {
        switch (kind) {
            case 1: {
                return "function";
            }
            case 4: {
                return "field";
            }
            case 5: {
                return "unit";
            }
            case 3: {
                return "type";
            }
            case 2: {
                return "script";
            }
            case 6: {
                return "rule";
            }
        }
        return "<unknown entity kind>";
    }

    public static void printTo(CAstEntity e, Writer w) {
        if (w != null) {
            instance.doPrintTo(e, w);
        }
    }

    protected void doPrintTo(CAstEntity e, Writer w) {
        try {
            w.write(this.getEntityKindAsString(e.getKind()));
            w.write(": ");
            w.write(e.getName());
            w.write(10);
            if (e.getArgumentNames().length > 0) {
                w.write("(");
                String[] names = e.getArgumentNames();
                for (String name : names) {
                    w.write("  " + name);
                }
                w.write("  )\n");
            }
            if (e.getAST() != null) {
                this.doPrintTo(e.getAST(), e.getSourceMap(), w);
                w.write(10);
            }
            for (Collection collection : e.getAllScopedEntities().values()) {
                for (CAstEntity entity : collection) {
                    this.doPrintTo(entity, w);
                }
            }
            w.flush();
        }
        catch (IOException e1) {
            System.err.println("unexpected I/O exception " + e1);
        }
    }

    private static final class StringWriter
    extends Writer {
        private final StringBuilder sb;

        private StringWriter(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.sb.append(new String(cbuf, off, len));
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

