/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import java.util.Collection;
import java.util.Collections;

public class AstDynamicField
implements IField {
    private final boolean isStatic;
    private final TypeReference descriptor;
    private final IClass cls;
    private final Atom name;

    public AstDynamicField(boolean isStatic, IClass cls, Atom name, TypeReference descriptor) {
        this.isStatic = isStatic;
        this.descriptor = descriptor;
        this.cls = cls;
        this.name = name;
    }

    public String toString() {
        return "<field " + this.name + '>';
    }

    public IClass getDeclaringClass() {
        return this.cls;
    }

    public Atom getName() {
        return this.name;
    }

    public TypeReference getFieldTypeReference() {
        return this.descriptor;
    }

    public FieldReference getReference() {
        return FieldReference.findOrCreate((TypeReference)this.cls.getReference(), (Atom)this.name, (TypeReference)this.descriptor);
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cls.getClassHierarchy();
    }

    public Collection<Annotation> getAnnotations() {
        return Collections.emptySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AstDynamicField other = (AstDynamicField)obj;
        if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
            return false;
        }
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals((Object)other.descriptor)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals((Object)other.name));
    }
}

