/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.util.IfxErrMsg;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class UDRMetaData {
    protected Locale locale = Locale.getDefault();
    protected Hashtable udrs = null;
    protected String jarFileSQLName = null;

    public void setUDR(Method method, String string) throws SQLException {
        udrinfo udrinfo2;
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.udrs == null) {
            this.udrs = new Hashtable(10);
        }
        if (!this.udrs.contains(udrinfo2 = new udrinfo(method, string))) {
            this.udrs.put(method, udrinfo2);
        }
    }

    public Method[] getUDRs() {
        Method[] methodArray = null;
        int n = 0;
        if (this.udrs == null) {
            return null;
        }
        n = this.udrs.size();
        if (n == 0) {
            return null;
        }
        methodArray = new Method[n];
        int n2 = 0;
        Enumeration enumeration = this.udrs.keys();
        while (enumeration.hasMoreElements()) {
            methodArray[n2] = (Method)enumeration.nextElement();
            ++n2;
        }
        return methodArray;
    }

    public String getUDRSQLName(Method method) throws SQLException {
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.udrs == null) {
            return null;
        }
        udrinfo udrinfo2 = (udrinfo)this.udrs.get(method);
        return udrinfo2 == null ? null : udrinfo2.sqlname;
    }

    public void setJarFileSQLName(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.jarFileSQLName = string;
    }

    public String getJarFileSQLName() {
        return this.jarFileSQLName;
    }

    class udrinfo {
        Method method = null;
        String sqlname = null;

        udrinfo(Method method, String string) {
            this.method = method;
            this.sqlname = string;
        }
    }
}

