/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.mesg.SyntaxErrors;
import sqlj.util.io.CharStream;
import sqlj.util.io.UCodeEscape;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

public class UCode_CharStream
implements CharStream {
    protected static final int DEFAULT_BUFFERSIZE = 4096;
    private static final String DEFAULT_ENCODING = "8859_1";
    private static final char LF_CHAR = '\n';
    private static final char CR_CHAR = '\r';
    private static final int EOF_CHAR = 65535;
    private static final int EOF_LINE = -999;
    private boolean CR_SEEN;
    private int escapesSeen;
    private boolean m_processUEscapes;
    private int m_bufpos;
    private int m_bufsize;
    private int m_backup;
    private char[] m_buf;
    private int[] m_bufcol;
    private int[] m_bufline;
    private int m_line;
    private int m_col;
    private int m_token_begin;
    private int tokenSize;
    private int tokenBeginLine;
    private int tokenBeginColumn;
    protected Reader m_r = null;
    protected CharToByteConverter m_charconv = null;
    private BufferedReader m_br = null;
    protected ErrorLog m_el = null;
    private static final int CONV_BUFFER_SIZE = 50;
    private int[] convBuffer = new int[50];
    private int convBufferIndex = 0;
    private int convBufferNext = 0;

    public UCode_CharStream() {
        this((Reader)null, null);
    }

    public UCode_CharStream(Reader reader, int n, boolean bl, ErrorLog errorLog) {
        this.m_r = reader;
        this.m_bufsize = n;
        this.m_el = errorLog;
        this.initialize();
        this.m_processUEscapes = bl;
    }

    public UCode_CharStream(Reader reader, int n, ErrorLog errorLog) {
        this.m_r = reader;
        this.m_bufsize = n;
        this.m_el = errorLog;
        this.initialize();
    }

    private void initialize() {
        this.m_buf = new char[this.m_bufsize];
        this.m_bufcol = new int[this.m_bufsize];
        this.m_bufline = new int[this.m_bufsize];
        this.m_bufpos = -1;
        this.m_backup = 0;
        this.m_line = 1;
        this.m_col = 0;
        this.tokenBeginLine = 1;
        this.tokenBeginColumn = 0;
        this.tokenSize = 0;
        this.m_token_begin = 0;
        if (this.m_r != null) {
            this.m_br = new BufferedReader(this.m_r, 4096);
        }
        this.CR_SEEN = false;
        this.escapesSeen = 0;
        this.m_processUEscapes = true;
    }

    public UCode_CharStream(Reader reader, ErrorLog errorLog) {
        this(reader, 4096, errorLog);
    }

    public UCode_CharStream(Reader reader, boolean bl, ErrorLog errorLog) {
        this(reader, 4096, bl, errorLog);
    }

    public UCode_CharStream(InputStream inputStream, int n, String string, ErrorLog errorLog) throws UnsupportedEncodingException {
        this.m_el = errorLog;
        if (string == null || string.equals("")) {
            string = System.getProperty("file.encoding", DEFAULT_ENCODING);
        }
        this.m_charconv = CharToByteConverter.getConverter((String)string);
        this.m_r = new InputStreamReader(inputStream, string);
        this.m_bufsize = n;
        this.initialize();
    }

    public UCode_CharStream(InputStream inputStream, ErrorLog errorLog) throws UnsupportedEncodingException {
        this(inputStream, 4096, null, errorLog);
    }

    public UCode_CharStream(InputStream inputStream, String string, ErrorLog errorLog) throws UnsupportedEncodingException {
        this(inputStream, 4096, string, errorLog);
    }

    public UCode_CharStream(InputStream inputStream, int n, ErrorLog errorLog) throws UnsupportedEncodingException {
        this(inputStream, n, null, errorLog);
    }

    public char BeginToken() throws IOException {
        this.tokenSize = 0;
        this.read();
        char c = this.m_buf[this.m_bufpos];
        if (c == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
            throw new IOException("EOF");
        }
        this.tokenBeginLine = this.m_bufline[this.m_bufpos];
        this.tokenBeginColumn = this.m_bufcol[this.m_bufpos];
        this.m_token_begin = this.m_bufpos;
        return c;
    }

    private void read() throws IOException {
        ++this.tokenSize;
        if (this.m_backup > 0) {
            --this.m_backup;
            this.m_bufpos = (this.m_bufpos + 1) % this.m_bufsize;
            if (this.m_buf[this.m_bufpos] == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
                throw new IOException("EOF");
            }
        } else {
            int n = this.readUnicodeCharacter();
            if (n == -1) {
                throw new IOException("EOF");
            }
            this.m_bufpos = (this.m_bufpos + 1) % this.m_bufsize;
            if (this.tokenSize >= this.m_bufsize) {
                char[] cArray = new char[this.m_bufsize + this.m_bufsize];
                int[] nArray = new int[this.m_bufsize + this.m_bufsize];
                int[] nArray2 = new int[this.m_bufsize + this.m_bufsize];
                int n2 = 0;
                int n3 = this.m_token_begin;
                while (n3 < this.m_bufsize) {
                    cArray[n2] = this.m_buf[n3];
                    nArray[n2] = this.m_bufline[n3];
                    nArray2[n2] = this.m_bufcol[n3];
                    ++n3;
                    ++n2;
                }
                n3 = 0;
                while (n3 < this.m_token_begin) {
                    cArray[n2] = this.m_buf[n3];
                    nArray[n2] = this.m_bufline[n3];
                    nArray2[n2] = this.m_bufcol[n3];
                    ++n3;
                    ++n2;
                }
                this.m_token_begin = 0;
                this.m_bufpos = this.m_bufsize - 1;
                this.m_bufsize += this.m_bufsize;
                this.m_buf = cArray;
                this.m_bufline = nArray;
                this.m_bufcol = nArray2;
            }
            this.m_buf[this.m_bufpos] = (char)n;
            if (n == 10) {
                this.m_bufline[this.m_bufpos] = this.m_line++;
                this.m_bufcol[this.m_bufpos] = this.m_col;
                if (this.CR_SEEN) {
                    this.CR_SEEN = false;
                    --this.tokenSize;
                    --this.m_bufpos;
                    this.read();
                }
                this.m_col = 0;
            } else if (n == 13) {
                this.m_buf[this.m_bufpos] = 10;
                this.CR_SEEN = true;
                this.m_bufline[this.m_bufpos] = this.m_line++;
                this.m_bufcol[this.m_bufpos] = this.m_col;
                this.m_col = 0;
            } else {
                this.CR_SEEN = false;
                this.m_bufline[this.m_bufpos] = n < 0 ? -999 : this.m_line;
                this.m_bufcol[this.m_bufpos] = this.m_col;
            }
        }
    }

    private int readUnicodeCharacter() throws IOException {
        int n;
        if (this.convBufferIndex < this.convBufferNext) {
            n = this.convBuffer[this.convBufferIndex++];
            ++this.m_col;
            if (this.convBufferIndex == this.convBufferNext) {
                this.convBufferIndex = 0;
                this.convBufferNext = 0;
            }
        } else {
            try {
                n = this.m_br.read();
                ++this.m_col;
                if (n == 92 && this.escapesSeen == 0) {
                    int n2 = this.m_br.read();
                    this.convBuffer[this.convBufferNext++] = n2;
                    if (n2 == 117) {
                        while ((n2 = this.m_br.read()) == 117) {
                            this.convBuffer[this.convBufferNext++] = n2;
                        }
                        this.convBuffer[this.convBufferNext++] = n2;
                        int n3 = 0;
                        int n4 = 0;
                        n3 = this.hex(n2);
                        if (n3 >= 0) {
                            n2 = this.m_br.read();
                            this.convBuffer[this.convBufferNext++] = n2;
                            n4 = this.hex(n2);
                            if (n4 >= 0) {
                                n3 = n3 * 16 + n4;
                                n2 = this.m_br.read();
                                this.convBuffer[this.convBufferNext++] = n2;
                                n4 = this.hex(n2);
                                if (n4 >= 0) {
                                    n3 = n3 * 16 + n4;
                                    n2 = this.m_br.read();
                                    this.convBuffer[this.convBufferNext++] = n2;
                                    n4 = this.hex(n2);
                                    if (n4 >= 0) {
                                        n3 = n3 * 16 + n4;
                                        this.m_col += this.convBufferNext;
                                        this.convBufferNext = 0;
                                        this.convBufferIndex = 0;
                                        return n3;
                                    }
                                    this.illegalUcodeCharacter(n2, this.convBufferNext - 1);
                                } else {
                                    this.illegalUcodeCharacter(n2, this.convBufferNext - 1);
                                }
                            } else {
                                this.illegalUcodeCharacter(n2, this.convBufferNext - 1);
                            }
                        } else {
                            this.illegalUcodeCharacter(n2, this.convBufferNext - 1);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (iOException instanceof MalformedInputException) {
                    this.illegallyEncodedCharacter();
                }
                throw iOException;
            }
        }
        if (n == 92) {
            ++this.escapesSeen;
            this.escapesSeen %= 2;
        } else {
            this.escapesSeen = 0;
        }
        return n;
    }

    int hex(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    public final char readChar() throws IOException {
        this.read();
        char c = this.m_buf[this.m_bufpos];
        if (c == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
            throw new IOException("EOF");
        }
        return c;
    }

    public int getColumn() {
        return this.getEndColumn();
    }

    public int getLine() {
        return this.getEndLine();
    }

    public int getEndColumn() {
        if (this.m_bufpos < 0) {
            return -1;
        }
        return this.m_bufcol[this.m_bufpos];
    }

    public int getEndLine() {
        if (this.m_bufpos < 0) {
            return -1;
        }
        return this.m_bufline[this.m_bufpos];
    }

    public int getBeginColumn() {
        return this.tokenBeginColumn;
    }

    public int getBeginLine() {
        return this.tokenBeginLine;
    }

    public void backup(int n) throws IllegalArgumentException {
        if (this.m_bufsize < n) {
            throw new IllegalArgumentException("backup(" + n + ") " + "exceeds buffer size " + this.m_bufsize);
        }
        this.m_bufpos -= n;
        if (this.m_bufpos < 0) {
            this.m_bufpos += this.m_bufsize;
        }
        this.tokenSize -= n;
        this.m_backup += n;
    }

    public String GetImage() throws IllegalArgumentException {
        if (this.tokenSize < 0) {
            throw new IllegalArgumentException("GetImage(): invalid token boundary");
        }
        StringBuffer stringBuffer = new StringBuffer(this.tokenSize);
        if (this.m_bufpos + 1 >= this.tokenSize) {
            stringBuffer.append(this.m_buf, this.m_bufpos - this.tokenSize + 1, this.tokenSize);
        } else {
            stringBuffer.append(this.m_buf, this.m_bufsize - (this.tokenSize - this.m_bufpos - 1), this.tokenSize - this.m_bufpos - 1);
            stringBuffer.append(this.m_buf, 0, this.m_bufpos + 1);
        }
        return stringBuffer.toString();
    }

    public char[] GetSuffix(int n) throws IllegalArgumentException {
        if (n > this.m_bufsize) {
            throw new IllegalArgumentException("GetSuffix(" + n + ") " + "exceeds buffer size " + this.m_bufsize);
        }
        char[] cArray = new char[n];
        if (this.m_bufpos + 1 >= n) {
            System.arraycopy(this.m_buf, this.m_bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(this.m_buf, this.m_bufsize - (n - this.m_bufpos - 1), cArray, 0, n - this.m_bufpos - 1);
            System.arraycopy(this.m_buf, 0, cArray, n - this.m_bufpos - 1, this.m_bufpos + 1);
        }
        return cArray;
    }

    public void Done() {
        this.m_buf = null;
        this.m_bufcol = null;
        this.m_bufline = null;
    }

    public Reader getReader() {
        return this.m_r;
    }

    private void message(String string, int n, int n2) {
        if (this.m_el != null) {
            this.m_el.addEntry(new JSError(string), n, n2);
        }
    }

    private void illegalCharacter(char c) {
        String string = SyntaxErrors.illegalInputCharacter(c, UCodeEscape.getEscape(c));
        this.message(string, this.getEndLine(), this.getEndColumn());
    }

    private void illegalUcodeCharacter(int n, int n2) {
        String string = SyntaxErrors.illegalCharacterInUnicode((char)n);
        this.message(string, this.getEndLine(), this.getEndColumn() + n2);
    }

    private void illegallyEncodedCharacter() {
        String string = SyntaxErrors.malformedInputCharacter();
        this.message(string, this.getEndLine(), this.getEndColumn());
    }
}

