/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util;

import java.util.Vector;
import sqlj.framework.BaseJSClass;
import sqlj.util.ClassNameResolver;
import sqlj.util.ClassNameResolverWrapper;
import sqlj.util.NestedClassResolver;

public class BlockClassResolver
extends ClassNameResolverWrapper {
    private BlockInfo m_info;
    private Snapshot m_snapshot = null;
    private Vector m_classes = new Vector();

    public ClassNameResolver getSnapshot() {
        if (this.m_snapshot == null) {
            this.m_snapshot = new Snapshot(this.m_classes.size());
        }
        return this.m_snapshot;
    }

    ClassNameResolver getWindow() {
        this.m_snapshot = null;
        return new Window(this.m_classes.size());
    }

    public static BlockClassResolver newInstance(ClassNameResolver classNameResolver) {
        if (classNameResolver instanceof BlockClassResolver) {
            return new BlockClassResolver((BlockClassResolver)classNameResolver);
        }
        if (classNameResolver instanceof NestedClassResolver) {
            return new BlockClassResolver((NestedClassResolver)classNameResolver);
        }
        throw new IllegalArgumentException("unknown resolver type " + classNameResolver);
    }

    public BlockClassResolver(BlockClassResolver blockClassResolver) {
        super(blockClassResolver.getSnapshot());
        this.m_info = blockClassResolver.m_info;
    }

    public BlockClassResolver(NestedClassResolver nestedClassResolver) {
        super(nestedClassResolver);
        this.m_info = new BlockInfo(nestedClassResolver);
    }

    private BaseJSClass lookupClass(String string, int n) {
        for (int i = 0; i < n; ++i) {
            BaseJSClass baseJSClass = (BaseJSClass)this.m_classes.elementAt(i);
            if (!baseJSClass.getName().equals(string)) continue;
            return baseJSClass;
        }
        return null;
    }

    private int addClass(BaseJSClass baseJSClass, int n) {
        if (n != this.m_classes.size()) {
            throw new IllegalArgumentException("illegal call to addClass");
        }
        if (!baseJSClass.getName().startsWith(this.m_info.m_enclosingClass)) {
            throw new IllegalArgumentException("illegal class name");
        }
        this.m_classes.addElement(baseJSClass);
        return n + 1;
    }

    class Window
    extends Snapshot {
        Window(int n) {
            super(n);
        }

        public void addClass(BaseJSClass baseJSClass) {
            if (this.isLoadedClass(baseJSClass.getName())) {
                throw new ClassCircularityError(baseJSClass.getName());
            }
            this.m_classNum = BlockClassResolver.this.addClass(baseJSClass, this.m_classNum);
        }
    }

    private class Snapshot
    extends ClassNameResolverWrapper {
        int m_classNum;

        public Snapshot(int n) {
            super(BlockClassResolver.this.m_base);
            this.m_classNum = n;
        }

        public BaseJSClass getClass(String string) throws ClassNotFoundException {
            BaseJSClass baseJSClass = this.getArray(string);
            if (baseJSClass != null) {
                return baseJSClass;
            }
            baseJSClass = BlockClassResolver.this.lookupClass(string, this.m_classNum);
            if (baseJSClass != null) {
                return baseJSClass;
            }
            baseJSClass = BlockClassResolver.this.lookupClass(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass + string.replace('.', '$'), this.m_classNum);
            if (baseJSClass != null) {
                return baseJSClass;
            }
            return this.m_base.getClass(string);
        }

        public BaseJSClass getQualifiedClass(String string) {
            BaseJSClass baseJSClass = BlockClassResolver.this.lookupClass(string, this.m_classNum);
            if (baseJSClass != null) {
                return baseJSClass;
            }
            return this.m_base.getQualifiedClass(string);
        }

        public String getShortName(BaseJSClass baseJSClass) {
            if (baseJSClass.getName().startsWith(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass)) {
                return baseJSClass.getName().substring(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClassLen);
            }
            return this.m_base.getShortName(baseJSClass);
        }

        public StringBuffer getClassQualification() {
            return new StringBuffer(((BlockClassResolver)BlockClassResolver.this).m_info.m_enclosingClass);
        }

        public boolean isLoadedClass(String string) {
            return BlockClassResolver.this.lookupClass(string, this.m_classNum) != null || this.m_base.isLoadedClass(string);
        }

        public void addClass(BaseJSClass baseJSClass) {
            throw new IllegalArgumentException("can't add classes to snapshot");
        }
    }

    private static class BlockInfo {
        String m_enclosingClass;
        int m_enclosingClassLen;

        BlockInfo(NestedClassResolver nestedClassResolver) {
            this.m_enclosingClass = nestedClassResolver.getClassQualification().append(nestedClassResolver.newBlockCount()).append("$").toString();
            this.m_enclosingClassLen = this.m_enclosingClass.length();
        }
    }
}

