/*
 * Decompiled with CFR 0.152.
 */
package sqlj.translator;

import java.util.Hashtable;
import sqlj.framework.BaseJSClass;
import sqlj.framework.ClassResolver;
import sqlj.framework.JSClass;
import sqlj.mesg.TranslatorErrors;

public class ClassResolverImpl
implements ClassResolver {
    private Hashtable m_classes = new Hashtable();

    public BaseJSClass getClass(String string) throws ClassNotFoundException {
        BaseJSClass baseJSClass = this.getQualifiedClass(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        throw new ClassNotFoundException(string);
    }

    public synchronized BaseJSClass getQualifiedClass(String string) {
        BaseJSClass baseJSClass = (BaseJSClass)this.m_classes.get(string);
        if (baseJSClass == null) {
            baseJSClass = ClassResolver.SYSTEM_CLASSES.getQualifiedClass(string);
        }
        if (baseJSClass == null) {
            try {
                baseJSClass = JSClass.reflect(Class.forName(string), this).getBaseJSClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                try {
                    baseJSClass = JSClass.reflect(Class.forName(string), this).getBaseJSClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ExceptionInInitializerError exceptionInInitializerError2) {
                    // empty catch block
                }
            }
        }
        return baseJSClass;
    }

    public boolean isLoadedClass(String string) {
        return this.m_classes.containsKey(string) || ClassResolver.SYSTEM_CLASSES.isLoadedClass(string);
    }

    public synchronized void addClass(BaseJSClass baseJSClass) {
        BaseJSClass baseJSClass2 = this.m_classes.put(baseJSClass.getName(), baseJSClass);
        if (baseJSClass2 != null && baseJSClass2 != baseJSClass) {
            throw new ClassCircularityError(TranslatorErrors.classAlreadyDefined(baseJSClass.getName()));
        }
    }
}

