/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import sqlj.tools.SourceMapper;

public class ClassMapper {
    private DataInputStream m_in;
    private String[] m_cpStrings = null;
    private int[] m_cpStringsIdx = null;
    private String m_sourceFileName;
    private SourceMapper m_sourceMapper;
    private Vector m_lineNumberTables = new Vector();
    private boolean m_alreadyInstrumented;
    private ClassBuffer m_classBytes;
    private static final int CLASS_ATTRIBUTE = 1;
    private static final int FIELD_ATTRIBUTE = 2;
    private static final int METHOD_ATTRIBUTE = 3;
    private static final int CODE_ATTRIBUTE = 4;

    public void mapClass(Class clazz) {
        this.m_classBytes = new ClassBuffer();
        this.m_in = this.getInputStream(clazz, (OutputStream)this.m_classBytes);
        this.m_sourceMapper = this.getSourceMapper(clazz);
        if (this.m_sourceMapper.size() == 0) {
            System.out.println("Not an original sqlj file - no instrumentation.");
        } else {
            try {
                this.readClass();
                if (this.m_alreadyInstrumented) {
                    System.out.println("No instrumentation: class already instrumented.");
                } else if (this.m_lineNumberTables.size() == 0) {
                    System.out.println("No instrumentation: no line info in class.");
                } else {
                    this.m_classBytes.adjustLineNumbers();
                    this.writeBuffer(this.m_classBytes, clazz);
                }
            }
            catch (IOException iOException) {
                throw new ClassFormatError(clazz.getName());
            }
            finally {
                try {
                    this.m_in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeBuffer(ClassBuffer classBuffer, Class clazz) throws IOException {
        String string = clazz.getName().replace('.', '/') + ".class";
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        classBuffer.writeTo(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    protected DataInputStream getInputStream(Class clazz, OutputStream outputStream) throws SecurityException {
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        BufferedInputStream bufferedInputStream = new BufferedInputStream(clazz.getResourceAsStream(string));
        return this.getInputStream(bufferedInputStream, outputStream);
    }

    protected DataInputStream getInputStream(InputStream inputStream, final OutputStream outputStream) throws SecurityException {
        if (inputStream == null) {
            throw new SecurityException("could not find class file ");
        }
        return new DataInputStream(new FilterInputStream(inputStream){

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 != -1) {
                    outputStream.write(byArray, n, n3);
                }
                return n3;
            }

            public int read() throws IOException {
                int n = super.read();
                if (n != -1) {
                    outputStream.write(n);
                }
                return n;
            }

            public long skip(long l) throws IOException {
                long l2;
                int n = 0;
                for (l2 = 0L; n != -1 && l2 < l; ++l2) {
                    n = this.read();
                }
                return l2;
            }
        });
    }

    protected SourceMapper getSourceMapper(Class clazz) throws SecurityException {
        String string = "/" + clazz.getName().replace('.', '/') + ".java";
        InputStream inputStream = clazz.getResourceAsStream(string);
        return this.getSourceMapper(inputStream);
    }

    protected SourceMapper getSourceMapper(InputStream inputStream) throws SecurityException {
        if (inputStream == null) {
            throw new SecurityException("could not find java file");
        }
        return new SourceMapper(new InputStreamReader(inputStream));
    }

    public void readClass() throws IOException {
        this.m_in.skipBytes(8);
        int n = this.u2();
        this.m_cpStrings = new String[n];
        this.m_cpStringsIdx = new int[n];
        int n2 = 1;
        while (n2 < n) {
            n2 = this.cp_info(n2);
        }
        this.m_in.skipBytes(4);
        this.m_in.skipBytes(2);
        n = this.u2();
        this.m_in.skipBytes(n * 2);
        n = this.u2();
        for (n2 = 0; n2 < n; ++n2) {
            this.field_info();
        }
        n = this.u2();
        for (n2 = 0; n2 < n; ++n2) {
            this.method_info();
        }
        n = this.u2();
        for (n2 = 0; n2 < n; ++n2) {
            this.attribute_info(1);
        }
    }

    public int cp_info(int n) throws IOException {
        int n2 = this.u1();
        switch (n2) {
            case 7: {
                this.m_in.skipBytes(2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.m_in.skipBytes(4);
                break;
            }
            case 8: {
                this.m_in.skipBytes(2);
                break;
            }
            case 5: 
            case 6: {
                this.m_in.skipBytes(8);
                ++n;
                break;
            }
            case 1: {
                this.m_cpStrings[n] = this.m_in.readUTF();
                this.m_cpStringsIdx[n] = this.m_classBytes.getCount();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag " + n2 + " at ndx " + n);
            }
        }
        return n + 1;
    }

    public void field_info() throws IOException {
        this.m_in.skipBytes(6);
        int n = this.u2();
        for (int i = 0; i < n; ++i) {
            this.attribute_info(2);
        }
    }

    public void method_info() throws IOException {
        this.m_in.skipBytes(6);
        int n = this.u2();
        for (int i = 0; i < n; ++i) {
            this.attribute_info(3);
        }
    }

    public void attribute_info(int n) throws IOException {
        int n2 = this.u2();
        int n3 = this.u4();
        if (n == 1 && this.m_cpStrings[n2].equals("SourceFile")) {
            int n4 = this.u2();
            this.m_sourceFileName = this.m_cpStrings[n4];
            if (this.m_sourceFileName.endsWith(".java")) {
                this.m_classBytes.writeASCIIStringAt("sqlj", this.m_cpStringsIdx[n4] - 4);
                this.m_alreadyInstrumented = false;
            } else {
                this.m_alreadyInstrumented = true;
            }
        } else if (n == 4 && this.m_cpStrings[n2].equals("LineNumberTable")) {
            int n5 = this.u2();
            int n6 = this.m_classBytes.getCount();
            this.m_lineNumberTables.addElement(new LineTable(n5, n6));
            for (int i = 0; i < n5; ++i) {
                this.m_in.skipBytes(4);
            }
        } else if (n == 3 && this.m_cpStrings[n2].equals("Code")) {
            this.code_attribute();
        } else {
            this.m_in.skipBytes(n3);
        }
    }

    public void code_attribute() throws IOException {
        long l;
        this.m_in.skipBytes(4);
        for (l = (long)this.u4(); l > Integer.MAX_VALUE; l -= Integer.MAX_VALUE) {
            this.m_in.skipBytes(Integer.MAX_VALUE);
        }
        this.m_in.skipBytes((int)l);
        int n = this.u2();
        this.m_in.skipBytes(n * 8);
        int n2 = this.u2();
        for (int i = 0; i < n2; ++i) {
            this.attribute_info(4);
        }
    }

    public int u4() throws IOException {
        return this.m_in.readInt();
    }

    public int u2() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public int u1() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public static void main(String string, String string2) {
        System.exit(ClassMapper.mainStatus(string, string2));
    }

    public static int mainStatus(String string, String string2) {
        ClassMapper classMapper = new ClassMapper();
        return classMapper.runMain(string, string2);
    }

    public int runMain(String string, String string2) {
        int n;
        block16: {
            n = 0;
            try {
                this.m_classBytes = new ClassBuffer();
                this.m_in = this.getInputStream(new BufferedInputStream(new FileInputStream(string)), (OutputStream)this.m_classBytes);
                this.m_sourceMapper = this.getSourceMapper(new BufferedInputStream(new FileInputStream(string2)));
                if (this.m_sourceMapper.size() == 0) {
                    System.out.println("Not an original sqlj file - no instrumentation.");
                    n = 1;
                    break block16;
                }
                try {
                    this.readClass();
                    if (this.m_alreadyInstrumented) {
                        System.out.println("No instrumentation: class already instrumented.");
                        n = 1;
                    } else if (this.m_lineNumberTables.size() == 0) {
                        System.out.println("No instrumentation: no line info in class.");
                        n = 1;
                    } else {
                        this.m_classBytes.adjustLineNumbers();
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        this.m_classBytes.writeTo(fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    throw new ClassFormatError(string);
                }
                finally {
                    try {
                        this.m_in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Unable to instrument " + string + ": " + exception.getMessage());
                n = 1;
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        System.exit(ClassMapper.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        ClassMapper classMapper = new ClassMapper();
        if (stringArray.length == 0) {
            System.out.println("java sqlj.tools.ClassMapper <classname> ... <classname>");
            System.out.println();
            System.out.println("Instruments class files to point to original SQLJ file positions.");
            System.out.println("Current directory must be at the root of the class hierarchy,");
            System.out.println("and *.class files, as well as SQLJ-generated *.java files must");
            System.out.println("be accessible.");
            return 1;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i].endsWith(".class")) {
                    stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - ".class".length());
                }
                System.out.println("----------------------");
                try {
                    Class<?> clazz = Class.forName(stringArray[i]);
                    System.out.println("[Instrumenting class " + clazz.getName() + "]");
                    try {
                        classMapper.mapClass(clazz);
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Unable to instrument: " + securityException.getMessage());
                        n = 1;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.out.println("No class definition found error: " + noClassDefFoundError.getMessage());
                    n = 1;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("An Exception occurred: " + exception.getMessage());
                n = 1;
            }
        }
        return n;
    }

    class LineTable {
        private int m_numEntries;
        private int m_position;

        LineTable(int n, int n2) {
            this.m_numEntries = n;
            this.m_position = n2;
        }

        int getNumEntries() {
            return this.m_numEntries;
        }

        int getPosition() {
            return this.m_position;
        }
    }

    class ClassBuffer
    extends ByteArrayOutputStream {
        ClassBuffer() {
        }

        void setIntAt(int n, int n2) {
            int n3 = n / 256;
            int n4 = n - 256 * n3;
            this.buf[n2] = (byte)n3;
            this.buf[n2 + 1] = (byte)n4;
        }

        int getIntAt(int n) {
            int n2 = this.buf[n];
            int n3 = this.buf[n + 1];
            int n4 = 256 * (n2 < 0 ? n2 + 256 : n2);
            return n4 + n3 < 0 ? n3 + 256 : n3;
        }

        void writeASCIIStringAt(String string, int n) {
            for (int i = 0; i < string.length(); ++i) {
                this.buf[n + i] = (byte)string.charAt(i);
            }
        }

        int getCount() {
            return this.count;
        }

        void adjustLineNumbers() {
            int n = 0;
            for (int i = 0; i < ClassMapper.this.m_lineNumberTables.size(); ++i) {
                LineTable lineTable = (LineTable)ClassMapper.this.m_lineNumberTables.elementAt(i);
                int n2 = lineTable.getPosition();
                for (int j = 0; j < lineTable.getNumEntries(); ++j) {
                    int n3 = this.getIntAt(n2);
                    int n4 = this.getIntAt(n2 += 2);
                    ClassMapper.this.m_sourceMapper.tgtLineToSrc(n4, 1);
                    this.setIntAt(ClassMapper.this.m_sourceMapper.startLine(), n2);
                    n2 += 2;
                    ++n;
                }
            }
            System.out.println("[Mapped " + n + " line positions]");
        }
    }
}

