/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.Elem;
import sqlj.util.UnitDescriptor;

class BaseAnalysis
implements SemanticAnalyzer {
    protected static final int UNKNOWN = -999;
    protected Elem elem;
    protected int errcount;
    protected boolean unpreparable;
    protected SemanticAnalyzerFactory saf;
    private static final String sQLJPrefix = "__sJT_";
    private static final String sQLJInfix = "_SJ";

    BaseAnalysis(Elem elem, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        this.elem = elem;
        this.saf = semanticAnalyzerFactory;
        this.errcount = 0;
        this.unpreparable = false;
        this.saf.m_tp.setErrorLog(elem.getErrorLog());
    }

    protected void logInfo(Object object) {
        if (this.saf.getVerbose()) {
            this.elem.getErrorLog().addEntry(new Info(object));
        }
    }

    protected void logWarning(Object object) {
        this.elem.getErrorLog().addEntry(new Warning(object));
    }

    protected void logError(Object object) {
        this.elem.getErrorLog().addEntry(new JSError(object));
        this.unpreparable = true;
    }

    protected String getBaseName() {
        try {
            UnitDescriptor unitDescriptor = (UnitDescriptor)this.elem.getScope().getDefiningUnit().getDescriptor();
            return unitDescriptor.getFileName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean checkSQLJPrefix(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(sQLJPrefix)) {
            this.logError(SemanticErrors.sQLJPrefix(string));
            return true;
        }
        return false;
    }

    protected boolean checkSQLJClassPrefix(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(this.getBaseName() + sQLJInfix)) {
            this.logError(SemanticErrors.sQLJClassPrefix(this.getBaseName() + sQLJInfix));
            return true;
        }
        return false;
    }

    public boolean prepare() {
        return true;
    }
}

