/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import sqlj.framework.JSClass;
import sqlj.framework.checker.SQLOperation;
import sqlj.semantics.SQLOperationImpl;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.ReturnBindExpr;
import sqlj.syntax.SQLUnit;

class AnalysisCache {
    public static Integer version = new Integer(980807);
    private String m_orig_sql;
    private String m_url;
    private String m_return_type;
    private String[] m_host_item_type;
    private int[] m_orig_modes;
    private Integer m_insert_pos;
    private String m_new_sql;
    private Integer m_categ;
    private Boolean m_prepend;
    private int[] m_modes;
    private Object m_descriptor;
    private SemanticAnalyzerFactory m_saf;
    private static final char separator = '&';

    AnalysisCache(SQLOperation sQLOperation, String string, String string2, int[] nArray, boolean bl, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        this.m_orig_sql = string;
        this.m_url = string2;
        this.m_saf = semanticAnalyzerFactory;
        JSClass jSClass = sQLOperation.getResultType();
        this.m_return_type = jSClass == null ? null : jSClass.getName();
        this.m_host_item_type = new String[sQLOperation.hostItemCount()];
        this.m_modes = new int[sQLOperation.hostItemCount()];
        for (int i = 0; i < this.m_host_item_type.length; ++i) {
            this.m_host_item_type[i] = sQLOperation.hostItem(i + 1).getHostItemType().getName();
            this.m_modes[i] = sQLOperation.hostItem(i + 1).getHostItemMode();
        }
        this.m_orig_modes = nArray;
        this.m_insert_pos = new Integer(sQLOperation.getResultParamIndex());
        this.m_categ = new Integer(sQLOperation.getOperationCode());
        this.m_prepend = new Boolean(bl);
        this.m_new_sql = sQLOperation.getSQLString();
        this.m_descriptor = null;
        if (sQLOperation instanceof SQLOperationImpl) {
            SQLOperationImpl sQLOperationImpl = (SQLOperationImpl)sQLOperation;
            this.m_descriptor = sQLOperationImpl.getDescriptor();
        }
    }

    void writeObject(ObjectOutput objectOutput) throws IOException {
        Object[] objectArray = new Object[]{this.m_orig_sql, this.m_url, this.m_host_item_type, this.m_orig_modes, this.m_return_type, this.m_insert_pos, this.m_categ, this.m_modes, this.m_new_sql, this.m_prepend, this.m_descriptor};
        objectOutput.writeObject(objectArray);
    }

    AnalysisCache(ObjectInput objectInput, SemanticAnalyzerFactory semanticAnalyzerFactory) throws IOException, ClassNotFoundException {
        this.m_saf = semanticAnalyzerFactory;
        Object[] objectArray = (Object[])objectInput.readObject();
        this.m_orig_sql = (String)objectArray[0];
        this.m_url = (String)objectArray[1];
        this.m_host_item_type = (String[])objectArray[2];
        this.m_orig_modes = (int[])objectArray[3];
        this.m_return_type = (String)objectArray[4];
        this.m_insert_pos = (Integer)objectArray[5];
        this.m_categ = (Integer)objectArray[6];
        this.m_modes = (int[])objectArray[7];
        this.m_new_sql = (String)objectArray[8];
        this.m_prepend = (Boolean)objectArray[9];
        this.m_descriptor = objectArray[10];
    }

    String key() {
        StringBuffer stringBuffer = new StringBuffer(this.m_orig_sql);
        stringBuffer.append('&');
        stringBuffer.append(this.m_url);
        stringBuffer.append('&');
        for (int i = 0; i < this.m_host_item_type.length; ++i) {
            stringBuffer.append(this.m_host_item_type[i]);
            stringBuffer.append('&');
            stringBuffer.append(String.valueOf(this.m_orig_modes[i]));
            stringBuffer.append('&');
        }
        stringBuffer.append(this.m_return_type);
        return stringBuffer.toString();
    }

    static String key(SQLOperation sQLOperation, String string, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        StringBuffer stringBuffer = new StringBuffer(sQLOperation.getSQLString());
        stringBuffer.append('&');
        stringBuffer.append(string);
        stringBuffer.append('&');
        for (int i = 1; i <= sQLOperation.hostItemCount(); ++i) {
            stringBuffer.append(sQLOperation.hostItem(i).getHostItemType().getName());
            stringBuffer.append('&');
            stringBuffer.append(String.valueOf(sQLOperation.hostItem(i).getHostItemMode()));
            stringBuffer.append('&');
        }
        JSClass jSClass = sQLOperation.getResultType();
        if (jSClass == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(jSClass.getName());
        }
        return stringBuffer.toString();
    }

    void replay(SQLOperation sQLOperation, SQLUnit sQLUnit) {
        sQLOperation.setSQLString(this.m_new_sql);
        sQLOperation.setOperationCode(this.m_categ);
        if (this.m_descriptor != null) {
            sQLOperation.setDescriptor(this.m_descriptor);
        }
        for (int i = 0; i < this.m_modes.length; ++i) {
            sQLOperation.hostItem(i + 1).setHostItemMode(this.m_modes[i]);
        }
        if (this.m_insert_pos > 0) {
            sQLOperation.setResultParamIndex(this.m_insert_pos);
        }
        if (this.m_prepend.booleanValue()) {
            sQLUnit.insertBindExprAt(sQLOperation.getOperationCode() == 2 ? ReturnBindExpr.QUERY_RETURN : ReturnBindExpr.COLUMN_RETURN, 1);
        }
    }
}

