/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.LogEntry;
import sqlj.framework.error.Position;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.options.ConnectionFactory;
import sqlj.mesg.CustomizerHarnessErrors;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.util.ProfileCustomizer;
import sqlj.runtime.profile.util.ProfileIOContext;
import sun.misc.BASE64Encoder;

public class CustomizerHarness {
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private ProfileCustomizer m_customizer = null;
    private boolean m_help = false;
    private boolean m_backup = false;
    private String m_contextList = null;
    private Hashtable m_contextTable = new Hashtable();
    private String m_driverList = null;
    private Hashtable m_driverTable = new Hashtable();
    private String m_digests;
    private MessageDigest[] m_digestArray;
    private Connection m_conn = null;
    private boolean m_verbose = false;
    private static final String[] SHARED_OPTIONS = new String[]{"verbose"};
    static /* synthetic */ Class class$java$lang$Object;

    public CustomizerHarness() {
        this.setDigests("SHA,MD5");
        this.setDriver(ConnectionFactory.DRIVER_DEFAULT);
    }

    public ProfileCustomizer getCustomizer() {
        return this.m_customizer;
    }

    public void setCustomizer(ProfileCustomizer profileCustomizer) {
        this.m_customizer = profileCustomizer;
    }

    public boolean getHelp() {
        return this.m_help;
    }

    public void setHelp(boolean bl) {
        this.m_help = bl;
    }

    public boolean getBackup() {
        return this.m_backup;
    }

    public void setBackup(boolean bl) {
        this.m_backup = bl;
    }

    public int customize(String string, ErrorLog errorLog) {
        int n;
        String string2 = errorLog.getFileName();
        errorLog.setFileName(string);
        if (string.endsWith(".jar")) {
            n = this.customizeJar(string, errorLog);
        } else if (string.endsWith(".ser")) {
            n = this.customizeSer(string, errorLog);
        } else {
            throw new IllegalArgumentException(CustomizerHarnessErrors.bad_filename(string));
        }
        this.logStatus(errorLog, n);
        errorLog.setFileName(string2);
        return n;
    }

    public int customizeJar(String string, ErrorLog errorLog) {
        try {
            JarIOContext jarIOContext = new JarIOContext(string, this.getBackup(), errorLog);
            return this.customizeJar(jarIOContext);
        }
        catch (IOException iOException) {
            this.logError(errorLog, iOException);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int customizeJar(ProfileIOContext profileIOContext) {
        int n;
        block8: {
            n = 5;
            JarProfiles jarProfiles = new JarProfiles(profileIOContext, this.getDigestArray());
            n = this.customizeProfiles(jarProfiles);
            jarProfiles.close(n);
            Object var5_5 = null;
            try {
                profileIOContext.close(n);
            }
            catch (IOException iOException) {
                this.logError(profileIOContext.getErrorLog(), iOException);
                n = 5;
            }
            break block8;
            {
                catch (IOException iOException) {
                    this.logError(profileIOContext.getErrorLog(), iOException);
                    n = 5;
                    Object var5_6 = null;
                    try {
                        profileIOContext.close(n);
                    }
                    catch (IOException iOException2) {
                        this.logError(profileIOContext.getErrorLog(), iOException2);
                        n = 5;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    profileIOContext.close(n);
                }
                catch (IOException iOException) {
                    this.logError(profileIOContext.getErrorLog(), iOException);
                    n = 5;
                }
                throw throwable;
            }
        }
        return n;
    }

    private void logError(ErrorLog errorLog, Exception exception) {
        errorLog.addEntry(new JSError(exception.toString()));
    }

    public int customizeProfiles(Enumeration enumeration) {
        int n = 3;
        block4: while (enumeration.hasMoreElements()) {
            int n2 = this.customizeProfile((ProfileIOContext)enumeration.nextElement());
            switch (n2) {
                case 5: {
                    return 5;
                }
                case 4: {
                    n = 4;
                    continue block4;
                }
            }
        }
        return n;
    }

    private void logStatus(ErrorLog errorLog, int n) {
        if (!this.isVerbose()) {
            return;
        }
        switch (n) {
            case 4: {
                errorLog.addEntry(new Info(CustomizerHarnessErrors.customized()));
                break;
            }
            case 3: {
                errorLog.addEntry(new Info(CustomizerHarnessErrors.unchanged()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int customizeProfile(ProfileIOContext profileIOContext) {
        Status status;
        block24: {
            ErrorLog errorLog;
            block22: {
                Profile profile;
                block20: {
                    errorLog = profileIOContext.getErrorLog();
                    Loader loader = profileIOContext.getLoader();
                    status = new Status(errorLog);
                    profile = Profile.instantiate(loader, profileIOContext.getInputStream());
                    if (this.hasValidContext(profile)) break block20;
                    if (this.isVerbose()) {
                        errorLog.addEntry(new Info(CustomizerHarnessErrors.ignoring_context(profile.getContextName())));
                    }
                    int n = status.getStatus();
                    Object var11_12 = null;
                    try {
                        profileIOContext.close(status.getStatus());
                    }
                    catch (IOException iOException) {
                        this.logError(errorLog, iOException);
                    }
                    return n;
                }
                Connection connection = this.getConnection(errorLog);
                boolean bl = this.getCustomizer().customize(profile, connection, errorLog);
                if (!bl || status.getStatus() == 5) break block22;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(profileIOContext.getOutputStream());
                try {
                    objectOutputStream.writeObject(profile);
                }
                finally {
                    objectOutputStream.close();
                }
                status.setStatus(4);
            }
            Object var11_13 = null;
            try {
                profileIOContext.close(status.getStatus());
            }
            catch (IOException iOException) {
                this.logError(errorLog, iOException);
            }
            break block24;
            {
                catch (NoClassDefFoundError noClassDefFoundError) {
                    errorLog.addEntry(new JSError(noClassDefFoundError.toString()));
                    Object var11_14 = null;
                    try {
                        profileIOContext.close(status.getStatus());
                    }
                    catch (IOException iOException) {
                        this.logError(errorLog, iOException);
                    }
                    break block24;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logError(errorLog, classNotFoundException);
                    Object var11_15 = null;
                    try {
                        profileIOContext.close(status.getStatus());
                    }
                    catch (IOException iOException) {
                        this.logError(errorLog, iOException);
                    }
                    break block24;
                }
                catch (IOException iOException) {
                    this.logError(errorLog, iOException);
                    Object var11_16 = null;
                    try {
                        profileIOContext.close(status.getStatus());
                    }
                    catch (IOException iOException2) {
                        this.logError(errorLog, iOException2);
                    }
                    break block24;
                }
                catch (SQLException sQLException) {
                    this.logError(errorLog, sQLException);
                    Object var11_17 = null;
                    try {
                        profileIOContext.close(status.getStatus());
                    }
                    catch (IOException iOException) {
                        this.logError(errorLog, iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                try {
                    profileIOContext.close(status.getStatus());
                }
                catch (IOException iOException) {
                    this.logError(errorLog, iOException);
                }
                throw throwable;
            }
        }
        return status.getStatus();
    }

    static File createUnique(String string, String string2) {
        String string3 = string + "." + string2;
        File file = new File(string3);
        int n = 1;
        while (file.exists()) {
            string3 = string + "." + string2 + n;
            file = new File(string3);
            ++n;
        }
        return file;
    }

    static void createBackup(String string, ErrorLog errorLog) throws IOException {
        File file = new File(string);
        File file2 = CustomizerHarness.createUnique(string, "bak");
        if (!file.renameTo(file2)) {
            throw new IOException(CustomizerHarnessErrors.cannot_create_backup());
        }
        errorLog.addEntry(new Info(CustomizerHarnessErrors.backup_created(file2.getPath())));
    }

    public int customizeSer(String string, ErrorLog errorLog) {
        return this.customizeProfile(new FileIOContext(string, this.getBackup(), errorLog, null));
    }

    public String getContext() {
        return this.m_contextList;
    }

    public void setContext(String string) {
        this.m_contextList = string;
        this.parseListString(string, this.m_contextTable);
    }

    public boolean hasValidContext(Profile profile) {
        return this.m_contextList == null || this.m_contextTable.containsKey(profile.getContextName());
    }

    private void parseListString(String string, Hashtable hashtable) {
        String[] stringArray = this.listToArray(string, ',');
        hashtable.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], stringArray[i]);
        }
    }

    private String[] listToArray(String string, char c) {
        Object object;
        int n;
        Vector vector = new Vector();
        if (string != null && string.trim().length() > 0) {
            while ((n = string.indexOf(c)) != -1) {
                object = string.substring(0, n);
                string = string.substring(n + 1);
                this.addListItem((String)object, vector);
            }
            this.addListItem(string, vector);
        }
        n = vector.size();
        object = new String[n];
        vector.copyInto((Object[])object);
        return object;
    }

    public String getDriver() {
        return this.m_driverList;
    }

    public void setDriver(String string) {
        this.resetConnection();
        this.m_driverList = string;
        this.parseListString(string, this.m_driverTable);
        this.m_connFact.setDrivers(this.m_driverTable.keys());
    }

    public String getDigests() {
        return this.m_digests;
    }

    public void setDigests(String string) {
        this.m_digests = string;
        this.setDigestArray(this.listToArray(string, ','));
    }

    private MessageDigest[] getDigestArray() {
        return this.m_digestArray;
    }

    private void setDigestArray(String[] stringArray) {
        this.m_digestArray = new MessageDigest[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.m_digestArray[i] = MessageDigest.getInstance(stringArray[i]);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException(CustomizerHarnessErrors.unknown_digest(stringArray[i]));
            }
        }
    }

    private void addListItem(String string, Vector vector) {
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException(CustomizerHarnessErrors.empty_list_item());
        }
        vector.addElement(string);
    }

    public Connection getConnection(ErrorLog errorLog) throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = this.m_connFact.getConnection(errorLog);
        }
        return this.m_conn;
    }

    public void setOptionsQuery(TranslationOptionsQuery translationOptionsQuery) {
        this.m_connFact.setOptionsQuery(translationOptionsQuery);
    }

    public TranslationOptionsQuery getOptionsQuery() {
        return this.m_connFact.getOptionsQuery();
    }

    public String getUrl() {
        return this.m_connFact.getURL();
    }

    public void setUrl(String string) {
        this.resetConnection();
        this.m_connFact.setURL(string);
    }

    public String getUrlPrefix() {
        return this.m_connFact.getURLPrefix();
    }

    public void setUrlPrefix(String string) {
        this.resetConnection();
        this.m_connFact.setURLPrefix(string);
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
        this.m_connFact.setVerbose(bl);
    }

    public String getUser() {
        return this.m_connFact.getUser();
    }

    public void setUser(String string) {
        this.resetConnection();
        this.m_connFact.setUser(string);
    }

    public String getPassword() {
        return this.m_connFact.getPassword();
    }

    public void setPassword(String string) {
        this.resetConnection();
        this.m_connFact.setPassword(string);
    }

    private void resetConnection() {
        if (this.m_conn != null) {
            try {
                Connection connection = this.m_conn;
                this.m_conn = null;
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean isValidFilename(String string) {
        return string.endsWith(".ser") || string.endsWith(".jar");
    }

    private boolean checkCustomizer(ErrorLog errorLog) {
        ProfileCustomizer profileCustomizer = this.getCustomizer();
        if (profileCustomizer == null) {
            errorLog.addEntry(new JSError(CustomizerHarnessErrors.no_customizer()));
            return false;
        }
        try {
            if (this.getCustomizer().acceptsConnection(this.getConnection(errorLog))) {
                return true;
            }
            errorLog.addEntry(new JSError(CustomizerHarnessErrors.connection_not_accepted(this.getConnectString())));
        }
        catch (SQLException sQLException) {
            errorLog.addEntry(new JSError(sQLException.toString()));
        }
        return false;
    }

    private String getConnectString() {
        return this.m_connFact.toString();
    }

    public static void main(String[] stringArray) {
        System.exit(CustomizerHarness.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        Log log = new Log(printWriter);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-C")) {
                vector.addElement(stringArray[i].substring(2));
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                vector2.addElement(stringArray[i].substring(1));
                continue;
            }
            if (CustomizerHarness.isValidFilename(stringArray[i])) {
                vector3.addElement(stringArray[i]);
                continue;
            }
            log.addEntry(new JSError(CustomizerHarnessErrors.invalid_option(stringArray[i])));
        }
        BeanEditor beanEditor = null;
        BeanEditor beanEditor2 = null;
        CustomizerHarness customizerHarness = new CustomizerHarness();
        ProfileCustomizer profileCustomizer = null;
        try {
            int n2;
            beanEditor = new BeanEditor((ErrorLog)log, customizerHarness);
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                beanEditor.setProperty((String)vector2.elementAt(n2));
            }
            profileCustomizer = customizerHarness.getCustomizer();
            if (profileCustomizer != null) {
                beanEditor2 = new BeanEditor((ErrorLog)log, customizerHarness.getCustomizer());
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    beanEditor2.setProperty((String)vector.elementAt(n2));
                }
                for (n2 = 0; n2 < SHARED_OPTIONS.length; ++n2) {
                    beanEditor2.setFrom(SHARED_OPTIONS[n2], beanEditor);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            log.addEntry(new JSError(CustomizerHarnessErrors.cannot_load_harness()));
        }
        if (customizerHarness.getHelp()) {
            CustomizerHarness.printUsage(printWriter, false);
            CustomizerHarness.printOptionSyntax(printWriter);
            if (beanEditor != null) {
                CustomizerHarness.printHelp(beanEditor.getPropertyInfo(), CustomizerHarnessErrors.general_options(), "  -", printWriter);
            }
            if (profileCustomizer != null) {
                CustomizerHarness.printHelp(beanEditor2.getPropertyInfo(), CustomizerHarnessErrors.customizer_options(), "  -C", printWriter);
            }
        } else if (vector3.size() == 0 || log.errorCount() > 0) {
            CustomizerHarness.printUsage(printWriter, true);
            n = 1;
        } else {
            if (customizerHarness.checkCustomizer(log)) {
                for (int i = 0; i < vector3.size(); ++i) {
                    customizerHarness.customize((String)vector3.elementAt(i), log);
                }
            }
            log.printSummary();
            if (log.errorCount() > 0) {
                n = 1;
            }
        }
        customizerHarness.resetConnection();
        return n;
    }

    private static void printUsage(PrintWriter printWriter, boolean bl) {
        String string = CustomizerHarnessErrors.usage();
        String string2 = CustomizerHarnessErrors.options();
        String string3 = CustomizerHarnessErrors.file();
        printWriter.println(string + ": [" + string2 + "] " + string3 + ".ser " + string3 + ".jar ...");
        if (bl) {
            printWriter.println(CustomizerHarnessErrors.help_desc("-help"));
        }
    }

    private static void printOptionSyntax(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(CustomizerHarnessErrors.summary_format());
    }

    private static void printHelp(String[][] stringArray, String string, String string2, PrintWriter printWriter) {
        if (stringArray.length == 0) {
            return;
        }
        printWriter.println();
        if (string != null) {
            printWriter.println(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            CustomizerHarness.printHelp(stringArray[i], string2, printWriter);
        }
    }

    private static void printHelp(String[] stringArray, String string, PrintWriter printWriter) {
        printWriter.print(string + stringArray[0]);
        if (stringArray[1] != null) {
            printWriter.print(" : " + stringArray[1]);
        }
        if (stringArray[2] != null) {
            printWriter.print(" = " + stringArray[2]);
        }
        printWriter.println();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BeanEditor {
        private Object m_bean;
        private Class m_beanClass;
        private BeanInfo m_info;
        private PropertyDescriptor[] m_props;
        private Hashtable m_propTable;
        private ErrorLog m_log;

        public BeanEditor(ErrorLog errorLog, ClassLoader classLoader, String string) throws IOException, ClassNotFoundException, IntrospectionException {
            this(errorLog, Beans.instantiate(classLoader, string));
        }

        public BeanEditor(ErrorLog errorLog, String string) throws IOException, ClassNotFoundException, IntrospectionException {
            this(errorLog, null, string);
        }

        public BeanEditor(ErrorLog errorLog, Object object) throws IntrospectionException {
            this.m_log = errorLog;
            this.m_bean = object;
            this.m_beanClass = this.m_bean.getClass();
            this.m_info = Introspector.getBeanInfo(this.m_beanClass, class$java$lang$Object == null ? (class$java$lang$Object = CustomizerHarness.class$("java.lang.Object")) : class$java$lang$Object);
            this.m_props = this.m_info.getPropertyDescriptors();
            this.m_propTable = new Hashtable();
            for (int i = 0; i < this.m_props.length; ++i) {
                this.m_propTable.put(this.m_props[i].getName(), new Integer(i));
            }
        }

        public void setFrom(String string, BeanEditor beanEditor) {
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                return;
            }
            PropertyDescriptor propertyDescriptor2 = beanEditor.getProp(string);
            if (propertyDescriptor2 == null) {
                return;
            }
            String[] stringArray = beanEditor.getPropertyInfo(propertyDescriptor2);
            this.setProperty(string, stringArray[2]);
        }

        public boolean setProperty(String string) {
            String string2 = string;
            String string3 = "";
            int n = string.indexOf("=");
            if (n != -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            return this.setProperty(string2, string3);
        }

        private PropertyDescriptor getProp(String string) {
            Integer n = (Integer)this.m_propTable.get(string);
            if (n == null) {
                return null;
            }
            return this.m_props[n];
        }

        public boolean setProperty(String string, String string2) {
            PropertyEditor propertyEditor;
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.invalid_option(string)));
                return false;
            }
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz == Boolean.TYPE && string2.equals("")) {
                string2 = "true";
            }
            if ((propertyEditor = this.getPropertyEditor(propertyDescriptor)) == null) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.unknown_option_type(string)));
                return false;
            }
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.option_read_only(string)));
                return false;
            }
            try {
                propertyEditor.setAsText(string2);
                method.invoke(this.m_bean, propertyEditor.getValue());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.invalid_option_value(string + "=" + string2)));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.cannot_access_option(string)));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.m_log.addEntry(new JSError(string + "=" + string2 + ": " + invocationTargetException.getTargetException()));
            }
            return false;
        }

        private PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor) {
            PropertyEditor propertyEditor = null;
            Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
            if (clazz != null) {
                try {
                    propertyEditor = (PropertyEditor)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else {
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                propertyEditor = PropertyEditorManager.findEditor(clazz2);
            }
            return propertyEditor;
        }

        public String[][] getPropertyInfo() {
            String[][] stringArray = new String[this.m_props.length][];
            for (int i = 0; i < this.m_props.length; ++i) {
                stringArray[i] = this.m_props[i].isHidden() ? null : this.getPropertyInfo(this.m_props[i]);
            }
            return stringArray;
        }

        public String[] getPropertyInfo(String string) {
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                this.m_log.addEntry(new JSError(CustomizerHarnessErrors.invalid_option(string)));
                return null;
            }
            return this.getPropertyInfo(propertyDescriptor);
        }

        private String[] getPropertyInfo(PropertyDescriptor propertyDescriptor) {
            PropertyEditor propertyEditor;
            String string;
            String string2 = propertyDescriptor.getName();
            if (string2.equals(string = propertyDescriptor.getShortDescription())) {
                string = null;
            }
            String string3 = null;
            Method method = propertyDescriptor.getReadMethod();
            if (method != null && (propertyEditor = this.getPropertyEditor(propertyDescriptor)) != null) {
                try {
                    Object object = method.invoke(this.m_bean, new Object[0]);
                    propertyEditor.setValue(object);
                    string3 = propertyEditor.getAsText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.m_log.addEntry(new JSError(string2 + ": " + invocationTargetException.getTargetException()));
                }
            }
            return new String[]{string2, string, string3};
        }

        public Object getAs(Class clazz) {
            return Beans.getInstanceOf(this.m_bean, clazz);
        }
    }

    public static class JarIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private File m_outfile;

        public JarIOContext(String string, boolean bl, ErrorLog errorLog) throws IOException {
            this.m_filename = string;
            this.m_createBackup = bl;
            this.m_log = errorLog;
            this.m_loader = new DefaultLoader(new JarFileClassLoader(new ZipFile(string)));
        }

        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        public Loader getLoader() {
            return this.m_loader;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        public OutputStream getOutputStream() throws IOException {
            this.m_outfile = CustomizerHarness.createUnique(this.m_filename, "tmp");
            return new FileOutputStream(this.m_outfile);
        }

        public void close(int n) throws IOException {
            if (n == 4) {
                this.saveFile();
            } else {
                this.removeFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_outfile != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                if (!this.m_outfile.renameTo(new File(this.m_filename))) {
                    throw new IOException(CustomizerHarnessErrors.cannot_rename(this.m_outfile, this.m_filename));
                }
            }
        }

        private void removeFile() throws IOException {
            if (this.m_outfile != null && !this.m_outfile.delete()) {
                throw new IOException(CustomizerHarnessErrors.cannot_delete(this.m_outfile));
            }
        }
    }

    private static class JarFileClassLoader
    extends ClassLoader {
        private ZipFile m_zip;
        private Hashtable m_classes = new Hashtable();

        public JarFileClassLoader(ZipFile zipFile) {
            this.m_zip = zipFile;
        }

        public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            long l;
            Class<?> clazz = (Class<?>)this.m_classes.get(string);
            if (clazz != null) {
                return clazz;
            }
            String string2 = string.replace('.', '/') + ".class";
            ZipEntry zipEntry = this.m_zip.getEntry(string2);
            if (zipEntry != null && (l = zipEntry.getSize()) != -1L && l <= Integer.MAX_VALUE) {
                byte[] byArray = new byte[(int)l];
                try {
                    InputStream inputStream = this.m_zip.getInputStream(zipEntry);
                    inputStream.read(byArray);
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    this.m_classes.put(string, clazz);
                    return clazz;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.findSystemClass(string);
        }

        public InputStream getResourceAsStream(String string) {
            ZipEntry zipEntry = this.m_zip.getEntry(string);
            if (zipEntry != null) {
                try {
                    return this.m_zip.getInputStream(zipEntry);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return JarFileClassLoader.getSystemResourceAsStream(string);
        }
    }

    public static class FileIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private ByteArrayOutputStream m_output = null;

        public FileIOContext(String string, boolean bl, ErrorLog errorLog, Loader loader) {
            this.m_filename = string;
            this.m_createBackup = bl;
            this.m_loader = loader;
            this.m_log = errorLog;
        }

        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        public Loader getLoader() {
            return this.m_loader;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        public OutputStream getOutputStream() throws IOException {
            this.m_output = new ByteArrayOutputStream(1024);
            return this.m_output;
        }

        public void close(int n) throws IOException {
            if (n == 4) {
                this.saveFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_output != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_filename);
                this.m_output.writeTo(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private static class Status {
        private int m_origErrorCount;
        private ErrorLog m_log;
        private int m_status = 3;

        public Status(ErrorLog errorLog) {
            this.m_origErrorCount = errorLog.errorCount();
            this.m_log = errorLog;
        }

        public int getStatus() {
            if (this.m_log.errorCount() > this.m_origErrorCount) {
                return 5;
            }
            return this.m_status;
        }

        public void setStatus(int n) {
            this.m_status = n;
        }
    }

    private static class JarProfiles
    implements Enumeration {
        ProfileIOContext m_jarContext;
        ZipInputStream m_jarInput;
        ZipOutputStream m_jarOutput;
        private static final int BUFFER_LEN = 1024;
        byte[] m_dataBuffer = new byte[1024];
        ZipEntry m_entry;
        private String m_origFilename;
        private ManifestData m_manifest;
        private ZipEntry m_manifestEntry;
        private MessageDigest[] m_digests;

        JarProfiles(ProfileIOContext profileIOContext, MessageDigest[] messageDigestArray) throws IOException {
            this.m_manifest = this.readManifest(profileIOContext);
            this.m_jarContext = profileIOContext;
            this.m_jarInput = new ZipInputStream(profileIOContext.getInputStream());
            try {
                this.m_jarOutput = new ZipOutputStream(profileIOContext.getOutputStream());
            }
            catch (IOException iOException) {
                this.m_jarInput.close();
                throw iOException;
            }
            this.m_origFilename = profileIOContext.getErrorLog().getFileName();
            this.m_digests = messageDigestArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManifestData readManifest(ProfileIOContext profileIOContext) throws IOException {
            ZipInputStream zipInputStream = new ZipInputStream(profileIOContext.getInputStream());
            try {
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (ManifestData.isManifest(zipEntry)) {
                            ManifestData manifestData = new ManifestData(zipInputStream);
                            return manifestData;
                        }
                        zipInputStream.closeEntry();
                    }
                }
                finally {
                    zipInputStream.close();
                }
            }
            finally {
                profileIOContext.close(3);
            }
            throw new IOException(CustomizerHarnessErrors.no_manifest());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(int n) throws IOException {
            try {
                if (n == 4) {
                    ProfileIOContext profileIOContext = this.getContextForEntry(this.m_manifestEntry);
                    this.m_manifest.toStream(profileIOContext.getOutputStream());
                    profileIOContext.close(4);
                }
                Object var4_3 = null;
                this.m_jarContext.getErrorLog().setFileName(this.m_origFilename);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_jarContext.getErrorLog().setFileName(this.m_origFilename);
                this.m_jarInput.close();
                this.m_jarOutput.close();
                throw throwable;
            }
            this.m_jarInput.close();
            this.m_jarOutput.close();
        }

        public boolean hasMoreElements() {
            try {
                while ((this.m_entry = this.m_jarInput.getNextEntry()) != null) {
                    if (this.isProfile(this.m_entry)) {
                        return true;
                    }
                    if (ManifestData.isManifest(this.m_entry)) {
                        this.m_manifestEntry = this.m_entry;
                        continue;
                    }
                    this.copyZipEntry(this.m_entry);
                }
            }
            catch (IOException iOException) {
                this.m_jarContext.getErrorLog().addEntry(new JSError(iOException.toString()));
            }
            return false;
        }

        private boolean isProfile(ZipEntry zipEntry) {
            return this.m_manifest.isProfile(zipEntry.getName());
        }

        private void copyZipEntry(ZipEntry zipEntry) throws IOException {
            int n;
            this.m_jarOutput.putNextEntry(zipEntry);
            while ((n = this.m_jarInput.read(this.m_dataBuffer, 0, 1024)) != -1) {
                this.m_jarOutput.write(this.m_dataBuffer, 0, n);
            }
            this.m_jarOutput.closeEntry();
            this.m_jarInput.closeEntry();
        }

        private ZipEntry createNewEntry(ZipEntry zipEntry) {
            ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
            zipEntry2.setComment(zipEntry.getComment());
            zipEntry2.setExtra(zipEntry.getExtra());
            zipEntry2.setMethod(zipEntry.getMethod());
            return zipEntry2;
        }

        public Object nextElement() {
            return this.getContextForEntry(this.m_entry);
        }

        private ProfileIOContext getContextForEntry(ZipEntry zipEntry) {
            this.m_jarContext.getErrorLog().setFileName(zipEntry.getName());
            return new JarEntryIOContext(zipEntry);
        }

        int getEntrySize(ZipEntry zipEntry) throws IOException {
            long l = zipEntry.getSize();
            if (l == -1L) {
                l = 1024L;
            } else if (l > Integer.MAX_VALUE) {
                throw new IOException(CustomizerHarnessErrors.file_too_big());
            }
            return (int)l;
        }

        private class JarEntryIOContext
        implements ProfileIOContext {
            private ByteArrayOutputStream m_savedInput;
            private ByteArrayOutputStream m_savedOutput;
            private Checksum m_outputChecksum = null;
            private DigestOutputStream[] m_digestStreams;
            private ZipEntry m_entry;

            public JarEntryIOContext(ZipEntry zipEntry) {
                this.m_entry = zipEntry;
            }

            private ZipEntry getEntry() {
                return this.m_entry;
            }

            public InputStream getInputStream() throws IOException {
                this.m_savedInput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                return new FilterInputStream(this, JarProfiles.this.m_jarInput){
                    private final /* synthetic */ JarEntryIOContext this$1;
                    {
                        this.this$1 = jarEntryIOContext;
                    }

                    public void close() throws IOException {
                        JarEntryIOContext.access$000((JarEntryIOContext)this.this$1).m_jarInput.closeEntry();
                    }

                    public int read() throws IOException {
                        int n = JarEntryIOContext.access$000((JarEntryIOContext)this.this$1).m_jarInput.read();
                        if (n != -1) {
                            JarEntryIOContext.access$100(this.this$1).write(n);
                        }
                        return n;
                    }

                    public int read(byte[] byArray) throws IOException {
                        int n = JarEntryIOContext.access$000((JarEntryIOContext)this.this$1).m_jarInput.read(byArray);
                        if (n != -1) {
                            JarEntryIOContext.access$100(this.this$1).write(byArray, 0, n);
                        }
                        return n;
                    }

                    public int read(byte[] byArray, int n, int n2) throws IOException {
                        int n3 = JarEntryIOContext.access$000((JarEntryIOContext)this.this$1).m_jarInput.read(byArray, n, n2);
                        if (n3 != -1) {
                            JarEntryIOContext.access$100(this.this$1).write(byArray, n, n3);
                        }
                        return n3;
                    }
                };
            }

            public OutputStream getOutputStream() throws IOException {
                this.m_savedOutput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                this.m_outputChecksum = new CRC32();
                FilterOutputStream filterOutputStream = new CheckedOutputStream(this.m_savedOutput, this.m_outputChecksum);
                this.m_digestStreams = new DigestOutputStream[JarProfiles.this.m_digests.length];
                for (int i = 0; i < JarProfiles.this.m_digests.length; ++i) {
                    JarProfiles.this.m_digests[i].reset();
                    this.m_digestStreams[i] = new DigestOutputStream(filterOutputStream, JarProfiles.this.m_digests[i]);
                    filterOutputStream = this.m_digestStreams[i];
                }
                return filterOutputStream;
            }

            public ErrorLog getErrorLog() {
                return JarProfiles.this.m_jarContext.getErrorLog();
            }

            public Loader getLoader() {
                return JarProfiles.this.m_jarContext.getLoader();
            }

            public void close(int n) throws IOException {
                switch (n) {
                    case 4: {
                        ZipEntry zipEntry = JarProfiles.this.createNewEntry(this.getEntry());
                        zipEntry.setCrc(this.m_outputChecksum.getValue());
                        zipEntry.setSize(this.m_savedOutput.size());
                        JarProfiles.this.m_jarOutput.putNextEntry(zipEntry);
                        this.m_savedOutput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        String string = zipEntry.getName();
                        if (!JarProfiles.this.m_manifest.isProfile(string)) break;
                        JarProfiles.this.m_manifest.clearDigests(string);
                        for (int i = 0; i < JarProfiles.this.m_digests.length; ++i) {
                            JarProfiles.this.m_manifest.addDigest(string, this.m_digestStreams[i].getMessageDigest());
                        }
                        break;
                    }
                    case 3: {
                        JarProfiles.this.m_jarOutput.putNextEntry(this.getEntry());
                        this.m_savedInput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        break;
                    }
                }
            }

            static /* synthetic */ JarProfiles access$000(JarEntryIOContext jarEntryIOContext) {
                return jarEntryIOContext.JarProfiles.this;
            }

            static /* synthetic */ ByteArrayOutputStream access$100(JarEntryIOContext jarEntryIOContext) {
                return jarEntryIOContext.m_savedInput;
            }
        }
    }

    private static class ManifestData {
        private Hashtable m_profiles = new Hashtable();
        private Vector m_attributes = new Vector();
        private InputStreamReader m_stream;
        private int m_nextChar;
        private static final String MANIFEST_ENCODING = "UTF8";
        private static final int CR = 13;
        private static final int LF = 10;
        private int eofCount = 0;

        public ManifestData(InputStream inputStream) throws IOException {
            this.m_stream = new InputStreamReader(inputStream, MANIFEST_ENCODING);
            this.m_nextChar = -1;
            this.readManifest();
            this.m_stream = null;
            this.findProfiles();
        }

        private void findProfiles() {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                Section section = (Section)enumeration.nextElement();
                if (!section.isProfile() || this.m_profiles.get(string = section.getName()) != null) continue;
                this.m_profiles.put(string, section);
            }
        }

        private void readManifest() throws IOException {
            if (this.readSection(this.m_attributes) == null) {
                this.raise_invalid_manifest();
            }
            this.checkRequired((Section)this.m_attributes.elementAt(0));
            while (this.readSection(this.m_attributes) != null) {
            }
        }

        private void checkRequired(Section section) throws IOException {
            String string = section.getRequiredVersion();
            if (string != null && !string.equals("1.0")) {
                this.raise_invalid_manifest();
            }
        }

        private String readSection(Vector vector) throws IOException {
            Section section = new Section();
            String string = this.readHeader(section);
            if (string != null) {
                vector.addElement(section);
                while (this.readHeader(section) != null) {
                }
                if (!this.readEOL()) {
                    this.raise_invalid_manifest();
                }
                while (this.readEOL()) {
                }
            }
            return string;
        }

        private String readHeader(Section section) throws IOException {
            String string = this.readKey();
            if (string == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.readContinuation(stringBuffer)) {
                this.raise_invalid_manifest();
            }
            while (this.readContinuation(stringBuffer)) {
            }
            section.put(string, stringBuffer.toString());
            return string;
        }

        private boolean readContinuation(StringBuffer stringBuffer) throws IOException {
            if (!this.isSpace(this.peekNextChar())) {
                return false;
            }
            this.getNextChar();
            while (!this.readEOL()) {
                this.getNextChar(stringBuffer);
            }
            return true;
        }

        private boolean readEOL() throws IOException {
            boolean bl = false;
            int n = this.peekNextChar();
            if (n == 13) {
                this.getNextChar();
                bl = true;
                n = this.peekNextChar();
            }
            if (n == 10) {
                this.getNextChar();
                bl = true;
            }
            return bl;
        }

        private boolean isSpace(int n) {
            return n == 32 || n == 9;
        }

        private String readKey() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.readAlphaNum(stringBuffer)) {
                return null;
            }
            while (this.readHeaderChar(stringBuffer)) {
            }
            if (this.getNextChar() != 58) {
                this.raise_invalid_manifest();
            }
            return stringBuffer.toString();
        }

        private void raise_invalid_manifest() throws IOException {
            throw new IOException(CustomizerHarnessErrors.invalid_manifest_syntax());
        }

        private boolean readAlphaNum(StringBuffer stringBuffer) throws IOException {
            int n = this.peekNextChar();
            if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57) {
                this.getNextChar(stringBuffer);
                return true;
            }
            return false;
        }

        private boolean readHeaderChar(StringBuffer stringBuffer) throws IOException {
            if (this.readAlphaNum(stringBuffer)) {
                return true;
            }
            int n = this.peekNextChar();
            if (n == 45 || n == 95) {
                this.getNextChar(stringBuffer);
                return true;
            }
            return false;
        }

        private int peekNextChar() throws IOException {
            if (this.m_nextChar == -1) {
                this.m_nextChar = this.read();
            }
            return this.m_nextChar;
        }

        private int read() throws IOException {
            int n = this.m_stream.read();
            if (n == -1 && this.eofCount++ < 2) {
                return 10;
            }
            return n;
        }

        private int getNextChar() throws IOException {
            int n;
            if (this.m_nextChar != -1) {
                n = this.m_nextChar;
                this.m_nextChar = -1;
            } else {
                n = this.read();
            }
            return n;
        }

        private void getNextChar(StringBuffer stringBuffer) throws IOException {
            stringBuffer.append((char)this.getNextChar());
        }

        public boolean isProfile(String string) {
            return this.m_profiles.containsKey(string);
        }

        public void clearDigests(String string) throws IOException {
            this.getProfile(string).clearDigests();
        }

        public void addDigest(String string, MessageDigest messageDigest) throws IOException {
            this.getProfile(string).addDigest(messageDigest);
        }

        private Section getProfile(String string) throws IOException {
            Section section = (Section)this.m_profiles.get(string);
            if (section == null) {
                throw new IOException(CustomizerHarnessErrors.invalid_profile_name(string));
            }
            return section;
        }

        public void toStream(OutputStream outputStream) throws IOException {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, MANIFEST_ENCODING);
            PrintWriter printWriter = new PrintWriter(new LineBreakFilter(outputStreamWriter, 72));
            int n = this.m_attributes.size();
            for (int i = 0; i < n; ++i) {
                ((Section)this.m_attributes.elementAt(i)).toStream(printWriter);
            }
            printWriter.flush();
        }

        public static boolean isManifest(ZipEntry zipEntry) {
            String string = zipEntry.getName();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return string.equalsIgnoreCase("META-INF/MANIFEST.MF");
        }

        private static class LineBreakFilter
        extends FilterWriter {
            private int m_numBytesInLine = 0;
            private int m_bytesPerLine;
            private static final String CONTINUATION = "\n ";
            private static final int CONTINUATION_LEN = 2;

            public LineBreakFilter(Writer writer, int n) {
                super(writer);
                this.m_bytesPerLine = n;
            }

            public void write(int n) throws IOException {
                if (n == 10 || n == 13) {
                    this.m_numBytesInLine = 0;
                    super.write(n);
                } else {
                    if (this.m_numBytesInLine >= this.m_bytesPerLine) {
                        super.write(CONTINUATION, 0, 2);
                        this.m_numBytesInLine = this.numBytesForChar(32);
                    }
                    this.m_numBytesInLine += this.numBytesForChar(n);
                    super.write(n);
                }
            }

            public void write(char[] cArray, int n, int n2) throws IOException {
                for (int i = 0; i < n2; ++i) {
                    this.write(cArray[i + n]);
                }
            }

            public void write(String string, int n, int n2) throws IOException {
                for (int i = 0; i < n2; ++i) {
                    this.write(string.charAt(i + n));
                }
            }

            private int numBytesForChar(int n) {
                if (n < 128) {
                    return 1;
                }
                if (n < 2048) {
                    return 2;
                }
                return 3;
            }
        }

        private static class Section {
            private BASE64Encoder m_encoder = new BASE64Encoder();
            private Vector m_keys = new Vector();
            private Vector m_origKeys = new Vector();
            private Vector m_values = new Vector();
            private static final String ALGORITHM_KEY = "DIGEST-ALGORITHMS";

            public void put(String string, String string2) {
                String string3 = string.toUpperCase();
                int n = this.m_keys.indexOf(string3);
                if (n == -1) {
                    this.m_keys.addElement(string3);
                    this.m_origKeys.addElement(string);
                    this.m_values.addElement(string2);
                } else {
                    this.m_values.setElementAt(string2, n);
                }
            }

            private String get(String string) {
                int n = this.m_keys.indexOf(string);
                if (n == -1) {
                    return null;
                }
                return (String)this.m_values.elementAt(n);
            }

            private String remove(String string) {
                int n = this.m_keys.indexOf(string);
                if (n == -1) {
                    return null;
                }
                this.m_keys.removeElementAt(n);
                this.m_origKeys.removeElementAt(n);
                String string2 = (String)this.m_values.elementAt(n);
                this.m_values.removeElementAt(n);
                return string2;
            }

            public boolean isProfile() {
                String string = this.get("SQLJPROFILE");
                return string != null && string.equalsIgnoreCase("TRUE") && this.getName() != null;
            }

            public String getDigestAlgorithms() {
                return this.get(ALGORITHM_KEY);
            }

            public String getName() {
                return this.get("NAME");
            }

            public String getRequiredVersion() {
                return this.get("REQUIRED-VERSION");
            }

            public void toStream(PrintWriter printWriter) {
                int n = this.m_keys.size();
                for (int i = 0; i < n; ++i) {
                    printWriter.print(this.m_origKeys.elementAt(i));
                    printWriter.print(": ");
                    printWriter.println(this.m_values.elementAt(i));
                }
                printWriter.println();
            }

            public void clearDigests() {
                String string = this.getDigestAlgorithms();
                if (string == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = string.length();
                while (n2 != -1 && n < n3) {
                    n2 = string.indexOf(32, n + 1);
                    String string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
                    this.remove(string2 + "-DIGEST");
                    n = n2 + 1;
                }
                this.remove(ALGORITHM_KEY);
            }

            public void addDigest(MessageDigest messageDigest) {
                String string = this.getDigestAlgorithms();
                String string2 = messageDigest.getAlgorithm();
                string = string == null ? string2 : string + " " + string2;
                this.put("Digest-Algorithms", string);
                this.put(string2 + "-Digest", this.m_encoder.encode(messageDigest.digest()));
            }
        }
    }

    public static class Log
    implements ErrorLog {
        private PrintWriter m_out;
        private int m_numWarnings = 0;
        private int m_numErrors = 0;
        private String m_filename = null;

        public Log(PrintWriter printWriter) {
            this.m_out = printWriter;
        }

        public void addEntry(LogEntry logEntry) {
            logEntry.setFileName(this.m_filename);
            if (logEntry instanceof JSError) {
                this.incErrorCount();
            } else if (logEntry instanceof Warning) {
                this.incWarningCount();
            }
            this.m_out.println(logEntry);
        }

        public void addEntry(LogEntry logEntry, int n, int n2) {
            logEntry.setPosition(new Position(n, n2));
            this.addEntry(logEntry);
        }

        public void addEntryRegion(LogEntry logEntry, int n, int n2, int n3, int n4) {
            logEntry.setRegion(n, n2, n3, n4);
            this.addEntry(logEntry);
        }

        public int errorCount() {
            return this.m_numErrors;
        }

        public void incErrorCount() {
            ++this.m_numErrors;
        }

        public int warningCount() {
            return this.m_numWarnings;
        }

        public void incWarningCount() {
            ++this.m_numWarnings;
        }

        public void setFileName(String string) {
            this.m_filename = string;
        }

        public String getFileName() {
            return this.m_filename;
        }

        public Position getDefaultRegion() {
            return null;
        }

        public void printSummary() {
            this.m_out.print(CustomizerHarnessErrors.error_count(this.errorCount()));
            if (this.errorCount() > 0 && this.warningCount() > 0) {
                this.m_out.print(", ");
            }
            this.m_out.print(CustomizerHarnessErrors.warning_count(this.warningCount()));
            if (this.errorCount() > 0 || this.warningCount() > 0) {
                this.m_out.println();
            }
        }
    }
}

