/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTResultSetJDBC;

public class RTStatementJDBCBase {
    protected PreparedStatement preparedStmt;
    private boolean m_executeComplete = false;
    private RTResultSetJDBC m_openResultSet = null;
    private boolean m_isClosed = false;

    public RTStatementJDBCBase(PreparedStatement preparedStatement) {
        this.preparedStmt = preparedStatement;
    }

    public PreparedStatement getJDBCPreparedStatement() {
        return this.preparedStmt;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.preparedStmt.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.preparedStmt.setMaxRows(n);
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.preparedStmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.preparedStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStmt.clearWarnings();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_openResultSet != null) {
            this.m_openResultSet.close();
            this.m_openResultSet = null;
        }
        return this.preparedStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStmt.getMoreResults();
    }

    public RTResultSet executeRTQuery() throws SQLException {
        RTResultSetJDBC rTResultSetJDBC;
        this.m_openResultSet = rTResultSetJDBC = new RTResultSetJDBC(this.preparedStmt.executeQuery(), this);
        return rTResultSetJDBC;
    }

    public int executeUpdate() throws SQLException {
        return this.preparedStmt.executeUpdate();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.preparedStmt.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.preparedStmt.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.preparedStmt.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.preparedStmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.preparedStmt.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.preparedStmt.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.preparedStmt.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.preparedStmt.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.preparedStmt.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.preparedStmt.setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.preparedStmt.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.preparedStmt.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.preparedStmt.setTimestamp(n, timestamp);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.preparedStmt.setObject(n, object);
    }

    public boolean execute() throws SQLException {
        return this.preparedStmt.execute();
    }

    public void executeComplete() throws SQLException {
        this.m_executeComplete = true;
        this.checkClose();
    }

    void notifyClosed(RTResultSetJDBC rTResultSetJDBC) throws SQLException {
        this.m_openResultSet = null;
        this.checkClose();
    }

    private void checkClose() throws SQLException {
        if (!this.m_isClosed && this.m_executeComplete && this.m_openResultSet == null) {
            this.m_isClosed = true;
            this.preparedStmt.close();
        }
    }

    public void setBooleanWrapper(int n, Boolean bl) throws SQLException {
        if (bl == null) {
            this.preparedStmt.setNull(n, -7);
        } else {
            this.preparedStmt.setBoolean(n, bl);
        }
    }

    public void setByteWrapper(int n, Byte by) throws SQLException {
        if (by == null) {
            this.preparedStmt.setNull(n, -6);
        } else {
            this.preparedStmt.setByte(n, by);
        }
    }

    public void setShortWrapper(int n, Short s) throws SQLException {
        if (s == null) {
            this.preparedStmt.setNull(n, 5);
        } else {
            this.preparedStmt.setShort(n, s);
        }
    }

    public void setIntWrapper(int n, Integer n2) throws SQLException {
        if (n2 == null) {
            this.preparedStmt.setNull(n, 4);
        } else {
            this.preparedStmt.setInt(n, n2);
        }
    }

    public void setLongWrapper(int n, Long l) throws SQLException {
        if (l == null) {
            this.preparedStmt.setNull(n, -5);
        } else {
            this.preparedStmt.setLong(n, l);
        }
    }

    public void setFloatWrapper(int n, Float f) throws SQLException {
        if (f == null) {
            this.preparedStmt.setNull(n, 6);
        } else {
            this.preparedStmt.setFloat(n, f.floatValue());
        }
    }

    public void setDoubleWrapper(int n, Double d) throws SQLException {
        if (d == null) {
            this.preparedStmt.setNull(n, 8);
        } else {
            this.preparedStmt.setDouble(n, d);
        }
    }

    public void setAsciiStreamWrapper(int n, AsciiStream asciiStream) throws SQLException {
        if (asciiStream == null) {
            this.preparedStmt.setNull(n, -1);
        } else {
            this.preparedStmt.setAsciiStream(n, asciiStream.getInputStream(), asciiStream.getLength());
        }
    }

    public void setBinaryStreamWrapper(int n, BinaryStream binaryStream) throws SQLException {
        if (binaryStream == null) {
            this.preparedStmt.setNull(n, -4);
        } else {
            this.preparedStmt.setBinaryStream(n, binaryStream.getInputStream(), binaryStream.getLength());
        }
    }

    public void setUnicodeStreamWrapper(int n, UnicodeStream unicodeStream) throws SQLException {
        if (unicodeStream == null) {
            this.preparedStmt.setNull(n, -1);
        } else {
            this.preparedStmt.setUnicodeStream(n, unicodeStream.getInputStream(), unicodeStream.getLength());
        }
    }
}

