/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.ForUpdate;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.DynamicProfileWrapper;
import sqlj.runtime.profile.ref.LocalStatement;
import sqlj.runtime.profile.ref.RTStatementWrapper;

public class PositionedProfile
extends DynamicProfileWrapper {
    static final int EMPTY = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BIGDECIMAL = 8;
    static final int STRING = 9;
    static final int BYTES = 10;
    static final int DATE = 11;
    static final int TIME = 12;
    static final int TIMESTAMP = 13;
    static final int OBJECT = 14;
    static final int ASCII = 16;
    static final int BINARY = 17;
    static final int UNICODE = 18;
    static final int BOOLEAN_WRAP = 21;
    static final int BYTE_WRAP = 22;
    static final int SHORT_WRAP = 23;
    static final int INT_WRAP = 24;
    static final int LONG_WRAP = 25;
    static final int FLOAT_WRAP = 26;
    static final int DOUBLE_WRAP = 27;

    public PositionedProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public RTStatement getStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        switch (entryInfo.getRole()) {
            case 6: {
                if (entryInfo.getStatementType() != 2) {
                    ProfileRefErrors.raise_EXPECTED_PREPARED_STATEMENT(entryInfo.getSQLString());
                }
                if (entryInfo.getExecuteType() != 8) {
                    ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
                }
                int n2 = (Integer)entryInfo.getDescriptor();
                int n3 = entryInfo.getParamInfo(n2).getMarkerIndex();
                return new PositionedStatement(entryInfo.getSQLString(), n3, n2, entryInfo.getParamCount());
            }
        }
        return this.baseProfile.getStatement(n);
    }

    public class PositionedStatement
    extends RTStatementWrapper {
        private int m_cursorMarkerNdx;
        private int m_cursorParamNum;
        private String m_origSqlText;
        private ForUpdate m_cursor = null;
        private Object[] m_params;
        private int[] m_paramTypes;
        private int m_numParams;
        private RTStatement m_dummyStmt = this.stmt;

        public PositionedStatement(String string, int n, int n2, int n3) {
            super(new LocalStatement());
            this.m_origSqlText = string;
            this.m_cursorMarkerNdx = n;
            this.m_cursorParamNum = n2;
            this.m_numParams = n3;
            this.m_params = new Object[this.m_numParams];
            this.m_paramTypes = new int[this.m_numParams];
            for (int i = 0; i < this.m_numParams; ++i) {
                this.m_params[i] = null;
                this.m_paramTypes[i] = 0;
            }
        }

        public void executeComplete() throws SQLException {
            super.executeComplete();
            this.stmt = this.m_dummyStmt;
        }

        public void setBoolean(int n, boolean bl) throws SQLException {
            this.m_paramTypes[n - 1] = 1;
            this.m_params[n - 1] = new Boolean(bl);
        }

        public void setBooleanWrapper(int n, Boolean bl) throws SQLException {
            this.m_paramTypes[n - 1] = 21;
            this.m_params[n - 1] = bl;
        }

        public void setByte(int n, byte by) throws SQLException {
            this.m_paramTypes[n - 1] = 2;
            this.m_params[n - 1] = new Byte(by);
        }

        public void setByteWrapper(int n, Byte by) throws SQLException {
            this.m_paramTypes[n - 1] = 22;
            this.m_params[n - 1] = by;
        }

        public void setShort(int n, short s) throws SQLException {
            this.m_paramTypes[n - 1] = 3;
            this.m_params[n - 1] = new Short(s);
        }

        public void setShortWrapper(int n, Short s) throws SQLException {
            this.m_paramTypes[n - 1] = 23;
            this.m_params[n - 1] = s;
        }

        public void setInt(int n, int n2) throws SQLException {
            this.m_paramTypes[n - 1] = 4;
            this.m_params[n - 1] = new Integer(n2);
        }

        public void setIntWrapper(int n, Integer n2) throws SQLException {
            this.m_paramTypes[n - 1] = 24;
            this.m_params[n - 1] = n2;
        }

        public void setLong(int n, long l) throws SQLException {
            this.m_paramTypes[n - 1] = 5;
            this.m_params[n - 1] = new Long(l);
        }

        public void setLongWrapper(int n, Long l) throws SQLException {
            this.m_paramTypes[n - 1] = 25;
            this.m_params[n - 1] = l;
        }

        public void setFloat(int n, float f) throws SQLException {
            this.m_paramTypes[n - 1] = 6;
            this.m_params[n - 1] = new Float(f);
        }

        public void setFloatWrapper(int n, Float f) throws SQLException {
            this.m_paramTypes[n - 1] = 26;
            this.m_params[n - 1] = f;
        }

        public void setDouble(int n, double d) throws SQLException {
            this.m_paramTypes[n - 1] = 7;
            this.m_params[n - 1] = new Double(d);
        }

        public void setDoubleWrapper(int n, Double d) throws SQLException {
            this.m_paramTypes[n - 1] = 27;
            this.m_params[n - 1] = d;
        }

        public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
            this.m_paramTypes[n - 1] = 8;
            this.m_params[n - 1] = bigDecimal;
        }

        public void setString(int n, String string) throws SQLException {
            this.m_paramTypes[n - 1] = 9;
            this.m_params[n - 1] = string;
        }

        public void setBytes(int n, byte[] byArray) throws SQLException {
            this.m_paramTypes[n - 1] = 10;
            this.m_params[n - 1] = byArray;
        }

        public void setDate(int n, Date date) throws SQLException {
            this.m_paramTypes[n - 1] = 11;
            this.m_params[n - 1] = date;
        }

        public void setTime(int n, Time time) throws SQLException {
            this.m_paramTypes[n - 1] = 12;
            this.m_params[n - 1] = time;
        }

        public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
            this.m_paramTypes[n - 1] = 13;
            this.m_params[n - 1] = timestamp;
        }

        public void setAsciiStreamWrapper(int n, AsciiStream asciiStream) throws SQLException {
            this.m_paramTypes[n - 1] = 16;
            this.m_params[n - 1] = asciiStream;
        }

        public void setBinaryStreamWrapper(int n, BinaryStream binaryStream) throws SQLException {
            this.m_paramTypes[n - 1] = 17;
            this.m_params[n - 1] = binaryStream;
        }

        public void setUnicodeStreamWrapper(int n, UnicodeStream unicodeStream) throws SQLException {
            this.m_paramTypes[n - 1] = 18;
            this.m_params[n - 1] = unicodeStream;
        }

        public void setObject(int n, Object object) throws SQLException {
            if (n == this.m_cursorParamNum) {
                if (object instanceof ForUpdate) {
                    this.m_cursor = (ForUpdate)object;
                } else {
                    ProfileRefErrors.raise_EXPECTED_FOR_UPDATE(n, object.getClass().getName());
                }
            } else {
                this.m_paramTypes[n - 1] = 14;
                this.m_params[n - 1] = object;
            }
        }

        public int executeUpdate() throws SQLException {
            this.createStatement();
            return this.stmt.executeUpdate();
        }

        private void createStatement() throws SQLException {
            this.stmt.executeComplete();
            String string = this.m_origSqlText.substring(0, this.m_cursorMarkerNdx) + " " + this.m_cursor.getCursorName() + " " + this.m_origSqlText.substring(this.m_cursorMarkerNdx + 1);
            this.stmt = PositionedProfile.this.baseDynamicProfile.prepareStatement(string);
            if (this.m_dummyStmt.getMaxFieldSize() != 0) {
                this.stmt.setMaxFieldSize(this.m_dummyStmt.getMaxFieldSize());
            }
            if (this.m_dummyStmt.getMaxRows() != 0) {
                this.stmt.setMaxRows(this.m_dummyStmt.getMaxRows());
            }
            if (this.m_dummyStmt.getQueryTimeout() != 0) {
                this.stmt.setQueryTimeout(this.m_dummyStmt.getQueryTimeout());
            }
            block27: for (int i = 0; i < this.m_numParams; ++i) {
                switch (this.m_paramTypes[i]) {
                    case 0: {
                        continue block27;
                    }
                    case 1: {
                        this.stmt.setBoolean(i + 1, (Boolean)this.m_params[i]);
                        continue block27;
                    }
                    case 21: {
                        this.stmt.setBooleanWrapper(i + 1, (Boolean)this.m_params[i]);
                        continue block27;
                    }
                    case 2: {
                        this.stmt.setByte(i + 1, (Byte)this.m_params[i]);
                        continue block27;
                    }
                    case 3: {
                        this.stmt.setShort(i + 1, (Short)this.m_params[i]);
                        continue block27;
                    }
                    case 4: {
                        this.stmt.setInt(i + 1, (Integer)this.m_params[i]);
                        continue block27;
                    }
                    case 5: {
                        this.stmt.setLong(i + 1, (Long)this.m_params[i]);
                        continue block27;
                    }
                    case 6: {
                        this.stmt.setFloat(i + 1, ((Float)this.m_params[i]).floatValue());
                        continue block27;
                    }
                    case 7: {
                        this.stmt.setDouble(i + 1, (Double)this.m_params[i]);
                        continue block27;
                    }
                    case 22: {
                        this.stmt.setByteWrapper(i + 1, (Byte)this.m_params[i]);
                        continue block27;
                    }
                    case 23: {
                        this.stmt.setShortWrapper(i + 1, (Short)this.m_params[i]);
                        continue block27;
                    }
                    case 24: {
                        this.stmt.setIntWrapper(i + 1, (Integer)this.m_params[i]);
                        continue block27;
                    }
                    case 25: {
                        this.stmt.setLongWrapper(i + 1, (Long)this.m_params[i]);
                        continue block27;
                    }
                    case 26: {
                        this.stmt.setFloatWrapper(i + 1, (Float)this.m_params[i]);
                        continue block27;
                    }
                    case 27: {
                        this.stmt.setDoubleWrapper(i + 1, (Double)this.m_params[i]);
                        continue block27;
                    }
                    case 8: {
                        this.stmt.setBigDecimal(i + 1, (BigDecimal)this.m_params[i]);
                        continue block27;
                    }
                    case 9: {
                        this.stmt.setString(i + 1, (String)this.m_params[i]);
                        continue block27;
                    }
                    case 10: {
                        this.stmt.setBytes(i + 1, (byte[])this.m_params[i]);
                        continue block27;
                    }
                    case 11: {
                        this.stmt.setDate(i + 1, (Date)this.m_params[i]);
                        continue block27;
                    }
                    case 12: {
                        this.stmt.setTime(i + 1, (Time)this.m_params[i]);
                        continue block27;
                    }
                    case 13: {
                        this.stmt.setTimestamp(i + 1, (Timestamp)this.m_params[i]);
                        continue block27;
                    }
                    case 14: {
                        this.stmt.setObject(i + 1, this.m_params[i]);
                        continue block27;
                    }
                    case 16: {
                        this.stmt.setAsciiStreamWrapper(i + 1, (AsciiStream)this.m_params[i]);
                        continue block27;
                    }
                    case 17: {
                        this.stmt.setBinaryStreamWrapper(i + 1, (BinaryStream)this.m_params[i]);
                        continue block27;
                    }
                    case 18: {
                        this.stmt.setUnicodeStreamWrapper(i + 1, (UnicodeStream)this.m_params[i]);
                    }
                }
            }
        }
    }
}

