/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCCallable;
import sqlj.runtime.profile.ref.RTStatementJDBCPrepared;

public class JDBCProfile
implements DynamicProfile {
    private ProfileData profileData;
    private Connection conn;

    public JDBCProfile(Connection connection, ProfileData profileData) {
        this.profileData = profileData;
        this.conn = connection;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public RTStatement getStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareStatement(this.getSQLString(n));
        }
        return this.prepareCall(this.getSQLString(n));
    }

    protected String getSQLString(int n) throws SQLException {
        return this.profileData.getEntryInfo(n).getSQLString();
    }

    public RTCallableStatement prepareCall(String string) throws SQLException {
        RTStatementJDBCCallable rTStatementJDBCCallable = new RTStatementJDBCCallable(this.conn.prepareCall(string));
        return rTStatementJDBCCallable;
    }

    public RTStatement prepareStatement(String string) throws SQLException {
        return new RTStatementJDBCPrepared(this.conn.prepareStatement(string));
    }

    public void close() throws SQLException {
    }
}

