/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.DynamicProfileWrapper;
import sqlj.runtime.profile.ref.LocalStatement;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTResultSetJDBC;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class IterConvertProfile
extends DynamicProfileWrapper {
    static /* synthetic */ Class class$sqlj$runtime$profile$RTResultSet;
    static /* synthetic */ Class class$sqlj$runtime$ResultSetIterator;

    public IterConvertProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public RTStatement getStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getRole() == 18) {
            if (entryInfo.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entryInfo.getSQLString());
            }
            if (entryInfo.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
            }
            return new IterConvertStatement(this, entryInfo);
        }
        return super.getStatement(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IterConvertStatement
    extends LocalStatement
    implements RTCallableStatement {
        private static final Class[] ITER_CONSTRUCTOR_ARGS = new Class[]{class$sqlj$runtime$profile$RTResultSet == null ? (class$sqlj$runtime$profile$RTResultSet = IterConvertProfile.class$("sqlj.runtime.profile.RTResultSet")) : class$sqlj$runtime$profile$RTResultSet};
        private ResultSet m_rs = null;
        private EntryInfo m_entry;
        private Profile m_profile;

        public IterConvertStatement(ConnectedProfile connectedProfile, EntryInfo entryInfo) throws SQLException {
            this.m_entry = entryInfo;
            this.m_profile = connectedProfile.getProfileData().getProfile();
        }

        public void registerOutParameter(int n, int n2) throws SQLException {
        }

        public void setObject(int n, Object object) throws SQLException {
            if (object instanceof ResultSet && n == 2) {
                this.m_rs = (ResultSet)object;
            } else {
                ProfileRefErrors.raise_UNEXPECTED_CALL("setObject");
            }
        }

        private ResultSet getResultSetParam() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getResultSetParam");
            }
            return this.m_rs;
        }

        public int executeUpdate() {
            return 0;
        }

        public Object getObject(int n, Class clazz) throws SQLException {
            if (n == 1) {
                return IterConvertStatement.createIterator(this.m_profile, this.m_entry.getParamInfo(n), this.toRTResultSet(this.getResultSetParam()));
            }
            ProfileRefErrors.raise_UNEXPECTED_CALL("getObject");
            return null;
        }

        public static Object createIterator(Profile profile, TypeInfo typeInfo, RTResultSet rTResultSet) throws SQLException {
            Class clazz;
            if (rTResultSet == null) {
                return null;
            }
            if ((class$sqlj$runtime$ResultSetIterator == null ? (class$sqlj$runtime$ResultSetIterator = IterConvertProfile.class$("sqlj.runtime.ResultSetIterator")) : class$sqlj$runtime$ResultSetIterator).equals(clazz = profile.getJavaType(typeInfo))) {
                return UntypedSelectProfile.UntypedSelectStatement.newUntypedIterator(rTResultSet);
            }
            if ((class$sqlj$runtime$ResultSetIterator == null ? (class$sqlj$runtime$ResultSetIterator = IterConvertProfile.class$("sqlj.runtime.ResultSetIterator")) : class$sqlj$runtime$ResultSetIterator).isAssignableFrom(clazz)) {
                return IterConvertStatement.construct(clazz, ITER_CONSTRUCTOR_ARGS, new Object[]{rTResultSet});
            }
            ProfileRefErrors.raise_INVALID_ITERATOR(clazz);
            return null;
        }

        public static Object construct(Class clazz, Class[] classArray, Object[] objectArray) throws SQLException {
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(classArray);
                return constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                ProfileRefErrors.raise_EXCEPTION_IN_CONSTRUCTOR(constructor.toString(), throwable);
                return null;
            }
        }

        protected RTResultSet toRTResultSet(ResultSet resultSet) throws SQLException {
            return new RTResultSetJDBC(resultSet);
        }
    }
}

