/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.javac.ExpressionNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.Token;

public abstract class UnaryOperatorNode
extends ExpressionNode {
    String operatorText;
    ExpressionNode operand;
    boolean prefix;
    int row;
    int col;

    UnaryOperatorNode(JavaParserImpl javaParserImpl, Token token, ExpressionNode expressionNode) {
        super(javaParserImpl);
        this.prefix = true;
        this.operatorText = token.getText();
        this.operand = expressionNode;
        this.row = token.beginLine;
        this.col = token.beginColumn;
    }

    UnaryOperatorNode(JavaParserImpl javaParserImpl, ExpressionNode expressionNode, Token token) {
        super(javaParserImpl);
        this.operand = expressionNode;
        this.operatorText = token.getText();
        this.prefix = false;
        this.row = expressionNode.getRow();
        this.col = expressionNode.getColumn();
    }

    int getRow() {
        return this.row;
    }

    int getColumn() {
        return this.col;
    }

    public final void getTextTo(StringBuffer stringBuffer) {
        if (this.prefix) {
            stringBuffer.append(this.operatorText);
            this.operand.getTextTo(stringBuffer);
        } else {
            this.operand.getTextTo(stringBuffer);
            stringBuffer.append(this.operatorText);
        }
    }

    void scopeChanged() {
        this.operand.setScope(this.getScope());
    }
}

