/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.error.ErrorLog;
import sqlj.javac.ASTBlock;
import sqlj.javac.ExpressionNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.JavaParserImplTreeConstants;
import sqlj.javac.Node;
import sqlj.javac.SymTabEntry;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private static Node prunedNode = new SimpleNode(20);
    private String name = null;
    private int beginLine = -1;
    private int beginColumn = -1;
    protected Node enclosingClass = null;
    protected Node definingUnit = null;
    protected Hashtable symtab = null;
    private Node javaScope = null;
    private Parselet scope = null;
    protected TypeDescriptor desc = null;
    private Object info = null;
    static int totalCount = 0;
    int lastNodeCountTime = 0;

    SimpleNode() {
        this(-1);
    }

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JavaParserImpl javaParserImpl, int n) {
        this(n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (node instanceof ASTBlock && !node.hasSQL()) {
            node = prunedNode;
        }
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return this.id < 0 ? "<unknown>" : JavaParserImplTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i);
            if (simpleNode == null) continue;
            simpleNode.dump(string + " ");
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public int setName(String string, ErrorLog errorLog) {
        this.setName(string);
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setBeginLine(int n) {
        this.beginLine = n;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginColumn(int n) {
        this.beginColumn = n;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public Vector jjtGetChildren() {
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            vector.addElement(this.jjtGetChild(i));
        }
        return vector;
    }

    public Node jjtGetLastChild() {
        if (this.jjtGetNumChildren() > 0) {
            return this.jjtGetChild(this.jjtGetNumChildren() - 1);
        }
        return null;
    }

    public void addSymTab(Node node) {
        if (node == null || node.getSymTab() == null) {
            return;
        }
        Enumeration enumeration = node.getSymTab().elements();
        if (this.symtab == null) {
            this.symtab = new Hashtable();
        }
        while (enumeration.hasMoreElements()) {
            SymTabEntry symTabEntry = (SymTabEntry)enumeration.nextElement();
            if (symTabEntry.isType) {
                this.insertSymTab(symTabEntry.typ.getName(), symTabEntry);
                continue;
            }
            this.insertSymTab(symTabEntry.var.getName(), symTabEntry);
        }
    }

    public Hashtable getSymTab() {
        return this.symtab;
    }

    public void insertSymTab(String string, SymTabEntry symTabEntry) {
        this.symtab.put(string, symTabEntry);
    }

    public void insertSymTab(Node node, Node node2, int n) {
        if (node2.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(node.getName(), new SymTabEntry(node, node2, n));
        }
    }

    public void insertSymTab(Node node, Node node2, int n, ExpressionNode expressionNode) {
        if (node2.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(node.getName(), new SymTabEntry(node, node2, n, expressionNode));
        }
    }

    public void insertSymTab(Node node, int n) {
    }

    public Node findName(String string, int n, int n2) {
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            Node node = symTabEntry.var;
            Node node2 = symTabEntry.typ;
            int n3 = symTabEntry.mod;
            if (this instanceof ASTBlock) {
                if (n > node.getBeginLine() || n == node.getBeginLine() && n2 > node.getBeginColumn()) {
                    return node2;
                }
            } else {
                return node2;
            }
        }
        return null;
    }

    public int getModifiers(String string, int n, int n2) {
        Node node;
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            if (this instanceof ASTBlock) {
                if (n > symTabEntry.var.getBeginLine() || n == symTabEntry.var.getBeginLine() && n2 > symTabEntry.var.getBeginColumn()) {
                    return symTabEntry.mod;
                }
            } else {
                return symTabEntry.mod;
            }
        }
        return (node = (Node)this.getScope()) == null ? 0 : node.getModifiers(string, n, n2);
    }

    public JSClass lookupVarDecl(String string, int n, int n2) throws ClassNotFoundException {
        Node node = this.findName(string, n, n2);
        if (node != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)node.getDescriptor();
            return classDescriptor == null ? null : classDescriptor.getReflection();
        }
        Node node2 = (Node)this.getScope();
        return node2 == null ? null : node2.lookupVarDecl(string, n, n2);
    }

    public SymTabEntry getSymTabEntry(String string, int n, int n2) {
        SimpleNode simpleNode;
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            if (this instanceof ASTBlock) {
                if (n > symTabEntry.var.getBeginLine() || n == symTabEntry.var.getBeginLine() && n2 > symTabEntry.var.getBeginColumn()) {
                    return symTabEntry;
                }
            } else {
                return symTabEntry;
            }
        }
        return (simpleNode = (SimpleNode)this.getScope()) == null ? null : simpleNode.getSymTabEntry(string, n, n2);
    }

    public void printSymTab() {
        Enumeration enumeration = this.symtab.elements();
        while (enumeration.hasMoreElements()) {
            SymTabEntry symTabEntry = (SymTabEntry)enumeration.nextElement();
            if (!symTabEntry.isType) {
                System.out.println("Var name is: " + symTabEntry.var.getName() + ".");
            }
            System.out.println("Type name is: " + symTabEntry.typ.getName() + ".");
        }
    }

    public String getVarName() {
        return null;
    }

    public void setScope(Parselet parselet) {
        if (this.scope != null) {
            throw new IllegalArgumentException("scope already set");
        }
        this.scope = parselet;
    }

    public Parselet getScope() {
        return this.scope == null ? this.jjtGetParent() : this.scope;
    }

    public Node getJavaScope() {
        if (this.javaScope != null) {
            return this.javaScope;
        }
        Parselet parselet = this;
        if (this.getScope() == null) {
            throw new NullPointerException("Internal error -- null scope for node " + this.toString());
        }
        while (!((parselet = parselet.getScope()) instanceof Node)) {
        }
        this.javaScope = parselet;
        return this.javaScope;
    }

    public Parselet getEnclosingClass() {
        if (this.enclosingClass != null) {
            return this.enclosingClass;
        }
        this.enclosingClass = (Node)this.getJavaScope().getEnclosingClass();
        return this.enclosingClass;
    }

    public Parselet getDefiningUnit() {
        if (this.definingUnit != null) {
            return this.definingUnit;
        }
        this.definingUnit = (Node)this.getJavaScope().getDefiningUnit();
        return this.definingUnit;
    }

    public ClassNameResolver getClassResolver() {
        return this.getJavaScope().getClassResolver();
    }

    public TypeDescriptor getDescriptor() {
        if (this.desc != null) {
            return this.desc;
        }
        this.desc = new TypeDescriptor();
        return this.desc;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public Object getInfo() {
        return this.info;
    }

    public boolean generate(OutputContext outputContext) throws IOException {
        return true;
    }

    protected void setDescriptor(TypeDescriptor typeDescriptor) {
        this.desc = typeDescriptor;
    }

    public boolean hasSQL() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (!this.jjtGetChild(i).hasSQL()) continue;
            return true;
        }
        return false;
    }

    public int numNodes() {
        return this.numNodes(++totalCount);
    }

    public int numNodes(int n) {
        int n2;
        if (this.lastNodeCountTime == n) {
            n2 = 0;
        } else {
            this.lastNodeCountTime = n;
            n2 = 1;
            for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                n2 += this.jjtGetChild(i).numNodes(n);
            }
        }
        return n2;
    }
}

