/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen.engine;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentationWriter
extends PrintWriter {
    private IndentationFilter os_;

    public IndentationWriter(Writer writer) {
        this(writer, 0);
    }

    public IndentationWriter(Writer writer, int n) {
        this(new IndentationFilter(writer, n));
    }

    private IndentationWriter(IndentationFilter indentationFilter) {
        super(indentationFilter);
        this.os_ = indentationFilter;
    }

    public void indentation(boolean bl) {
        this.os_.indentation(bl);
    }

    public void println() {
        super.println();
        this.os_.lastNew();
    }

    public void println(boolean bl) {
        super.println(bl);
        this.os_.lastNew();
    }

    public void println(char c) {
        super.println(c);
        this.os_.lastNew();
    }

    public void println(char[] cArray) {
        super.println(cArray);
        this.os_.lastNew();
    }

    public void println(double d) {
        super.println(d);
        this.os_.lastNew();
    }

    public void println(float f) {
        super.println(f);
        this.os_.lastNew();
    }

    public void println(int n) {
        super.println(n);
        this.os_.lastNew();
    }

    public void println(long l) {
        super.println(l);
        this.os_.lastNew();
    }

    public void println(Object object) {
        super.println(object);
        this.os_.lastNew();
    }

    public void println(String string) {
        super.println(string);
        this.os_.lastNew();
    }

    private static class IndentationFilter
    extends FilterWriter {
        private boolean indent_;
        private boolean lastNew_ = true;
        private int braceDepth_ = 0;
        private int spacesInTab_ = 2;
        private int init_;

        public IndentationFilter(Writer writer, int n) {
            super(writer);
            this.init_ = n;
            this.indent_ = true;
        }

        public void indentation(boolean bl) {
            this.indent_ = bl;
        }

        public void write(int n) throws IOException {
            this.checkInit(n);
            this.out.write(n);
        }

        private void checkInit(int n) throws IOException {
            if (n == 125 && this.braceDepth_ > 0) {
                --this.braceDepth_;
            }
            if (this.lastNew_ && this.indent_) {
                for (int i = 0; i < this.spacesInTab_ * this.braceDepth_ + this.init_; ++i) {
                    this.out.write(32);
                }
            }
            if (n == 123) {
                ++this.braceDepth_;
            }
            this.lastNew_ = false;
        }

        private void checkRest(int n) {
            if (n == 125 && this.braceDepth_ > 0) {
                --this.braceDepth_;
            } else if (n == 123) {
                ++this.braceDepth_;
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                this.checkInit(cArray[n]);
            }
            for (int i = 1; i < n2; ++i) {
                this.checkRest(cArray[i + n]);
            }
            this.out.write(cArray, n, n2);
        }

        public void write(String string, int n, int n2) throws IOException {
            if (n2 > 0) {
                this.checkInit(string.charAt(n));
            }
            for (int i = 1; i < n2; ++i) {
                this.checkRest(string.charAt(i + n));
            }
            this.out.write(string, n, n2);
        }

        public void lastNew() {
            this.lastNew_ = true;
        }
    }
}

