/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.codegen.ElemJSClass;
import sqlj.codegen.JSClassType;
import sqlj.framework.BaseJSClass;
import sqlj.framework.ClassResolver;
import sqlj.framework.JSClass;
import sqlj.framework.JSConstructor;
import sqlj.framework.JSMethod;
import sqlj.syntax.CursorElem;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.Type;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;

class CursorJSClass
extends ElemJSClass {
    private static final JSClass[] EMPTY_ARGS = new JSClass[0];
    private static final JSClass SUPERCLASS = JSClassType.ResultSetIterImpl_TYPE.toClass();
    private JSMethod[] m_methods = null;
    private JSConstructor[] m_constructors = null;

    public CursorJSClass(BaseJSClass baseJSClass, CursorElem cursorElem) throws ClassNotFoundException {
        super(baseJSClass, cursorElem, new JSClass[]{cursorElem.isByName() ? NamedIterator_TYPE : PositionedIterator_TYPE});
        this.createConstructors();
        this.setMethods(this.createMethods(cursorElem));
    }

    public CursorJSClass(IntoBindExpr intoBindExpr) throws ClassNotFoundException {
        super(new DummyBaseClass(), new JSClass[]{PositionedIterator_TYPE});
        this.createConstructors();
        this.setMethods(this.createMethods(intoBindExpr));
    }

    public void createConstructors() {
        this.m_constructors = new JSConstructor[]{new ElemJSClass.JSConstructorImpl((ElemJSClass)this, 1, new JSClass[]{JSClassType.RTResultSet_TYPE.toClass()})};
    }

    private void setMethods(Vector vector) {
        this.m_methods = new JSMethod[vector.size()];
        vector.copyInto(this.m_methods);
    }

    private Vector createMethods(CursorElem cursorElem) throws ClassNotFoundException {
        Vector<JSMethod> vector = new Vector<JSMethod>();
        if (cursorElem.isByName()) {
            Enumeration enumeration = cursorElem.getColumnNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = cursorElem.getColumnType(string).getName();
                vector.addElement(this.newColumnAccessMethod(this.resolveClass(string2), string));
            }
        } else {
            Enumeration enumeration = cursorElem.getColumnTypes();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                String string = ((Type)enumeration.nextElement()).getName();
                vector.addElement(this.newColumnAccessMethod(this.resolveClass(string), n));
                ++n;
            }
        }
        return vector;
    }

    private Vector createMethods(IntoBindExpr intoBindExpr) throws ClassNotFoundException {
        Vector<JSMethod> vector = new Vector<JSMethod>();
        Enumeration enumeration = intoBindExpr.getParselets();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Parselet parselet = (Parselet)enumeration.nextElement();
            BaseJSClass baseJSClass = ((ExpressionDescriptor)parselet.getDescriptor()).getBaseReflection();
            JSClass jSClass = this.resolveClass(baseJSClass);
            vector.addElement(this.newColumnAccessMethod(jSClass, n));
            ++n;
        }
        return vector;
    }

    private JSMethod newColumnAccessMethod(JSClass jSClass, int n) {
        return this.newColumnAccessMethod(jSClass, CursorJSClass.getColumnAccessName(n));
    }

    public static String getColumnAccessName(int n) {
        return "getCol" + n;
    }

    private JSMethod newColumnAccessMethod(JSClass jSClass, String string) {
        return new ElemJSClass.JSMethodImpl(this, string, 1, jSClass, EMPTY_ARGS);
    }

    public JSClass getSuperclass() {
        return SUPERCLASS;
    }

    public JSMethod[] getDeclaredMethods() throws SecurityException {
        return this.m_methods;
    }

    public JSConstructor[] getDeclaredConstructors() throws SecurityException {
        return this.m_constructors;
    }

    private static class DummyBaseClass
    extends BaseJSClass {
        private static final ClassResolver m_dummyResolver = new ClassResolver(){

            public BaseJSClass getClass(String string) throws ClassNotFoundException {
                throw new ClassNotFoundException(string);
            }

            public BaseJSClass getQualifiedClass(String string) {
                return null;
            }

            public boolean isLoadedClass(String string) {
                return false;
            }

            public void addClass(BaseJSClass baseJSClass) {
            }
        };

        public DummyBaseClass() {
            super("dummy*Iterator", 0, m_dummyResolver, SUPERCLASS.getName());
        }

        protected JSClass createJSClass() throws ClassNotFoundException {
            throw new ClassNotFoundException("this should never be called");
        }
    }

    public static class Base
    extends ElemJSClass.Base {
        private CursorElem m_elem;

        Base(CursorElem cursorElem) {
            super(cursorElem, SUPERCLASS.getName());
            this.m_elem = cursorElem;
        }

        protected JSClass createJSClass() throws ClassNotFoundException {
            return new CursorJSClass((BaseJSClass)this, this.m_elem);
        }
    }
}

