/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.jdt.MethodVisitor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.NodeProcessor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.NodeProcessorForMDM;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClassVisitor
extends ASTVisitor {
    private ClassInfo classInfo_;
    private Map<String, IBinding> bindingsMap_;
    private NodeProcessor nodeProcessor_;

    public ClassVisitor(ClassInfo classInfo, Map<String, IBinding> map) {
        this.classInfo_ = classInfo;
        this.nodeProcessor_ = classInfo.getArtifactOptionsSet().getOptionValueBoolean(PossibleArgs.ALLOW_MDM_BEAN_RULES) ? new NodeProcessorForMDM(map, this.classInfo_) : new NodeProcessor(map, this.classInfo_);
        this.bindingsMap_ = map;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        if (importDeclaration.isOnDemand()) {
            this.classInfo_.addImportDeclaration(importDeclaration.getName().getFullyQualifiedName() + ".*");
        } else {
            this.classInfo_.addImportDeclaration(importDeclaration.getName().getFullyQualifiedName());
        }
        return true;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        this.classInfo_.setPackageName(packageDeclaration.getName().getFullyQualifiedName());
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ToolsLogger.getLogger().log(Level.FINEST, "gathering info for: " + typeDeclaration.toString());
        ITypeBinding iTypeBinding = typeDeclaration.resolveBinding();
        if (iTypeBinding == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", typeDeclaration.toString()), null, 10228, (ASTNode)typeDeclaration, null);
        }
        this.classInfo_.setInterface(typeDeclaration.isInterface());
        this.classInfo_.setTypeName(typeDeclaration.getName().getFullyQualifiedName());
        List list = typeDeclaration.typeParameters();
        if (list != null && list.size() > 0) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("MSG_ERR_GENERIC_INTERFACE", new Object[0]), null, 10393, (ASTNode)typeDeclaration, null);
        }
        if (!this.classInfo_.isInterface()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NOT_INTERFACE", this.classInfo_.getTypeName()), null, 10229, (ASTNode)typeDeclaration, null);
        }
        MethodVisitor methodVisitor = new MethodVisitor(this.classInfo_, this.bindingsMap_, this.nodeProcessor_);
        typeDeclaration.accept((ASTVisitor)methodVisitor);
        this.classInfo_.setModifier(this.nodeProcessor_.getModifierAsString(typeDeclaration.modifiers()));
        return true;
    }
}

