/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.generic;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.generic.GenericConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.generic.GenericResultSetExecutionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;

public class GenericStatementExecutionHandler
extends StatementExecutionHandler {
    protected GenericConnectionExecutionHandler connectionProxyHandler_;

    public GenericStatementExecutionHandler(ConnectionExecutionHandler connectionExecutionHandler, Statement statement, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string, Method method, Object ... objectArray) throws SQLException {
        super(connectionExecutionHandler, statement, n2, n3, n4, stringArray, nArray, n5, string, method, objectArray);
        if (this.currentStates_.getProfilerHelperInstance() == null && this.logger_.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(this.logger_, this, "", DataLogger.getShortName(this) + " profilerHelperInstance is null", false);
        }
        this.connectionProxyHandler_ = (GenericConnectionExecutionHandler)connectionExecutionHandler;
    }

    protected ResultSetExecutionHandler wrapResultSet(ResultSet resultSet) throws SQLException {
        return new GenericResultSetExecutionHandler(this, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        boolean bl2 = false;
        Connection connection = this.connExecutionHandler_.physicalConnection_;
        synchronized (connection) {
            Object object = null;
            try {
                if (this.logger_.isLoggable(Level.FINER)) {
                    if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                        return method.invoke((Object)this.physicalStatement_, objectArray);
                    }
                    DataLogger.logAtLevelFiner(this.logger_, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
                    bl2 = true;
                }
                if (string.equals("executeQuery") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.executeQuery((String)objectArray[0]);
                } else if (string.equals("execute") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.execute((String)objectArray[0]);
                } else if (string.equals("executeUpdate") && objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                    object = this.executeUpdate((String)objectArray[0]);
                } else if (string.equals("setEscapeProcessing")) {
                    this.setEscapeProcessing((Boolean)objectArray[0]);
                } else if (string.equals("getUpdateCount")) {
                    object = this.getUpdateCount();
                } else if (string.equals("addBatch")) {
                    if (objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                        this.addBatch((String)objectArray[0]);
                    } else {
                        object = this.prepStmtHandle_ != null ? method.invoke(this.prepStmtHandle_.getUnderlyingObject(), objectArray) : method.invoke((Object)this.physicalStatement_, objectArray);
                    }
                } else if (string.equals("executeBatch")) {
                    object = this.executeBatch();
                } else if (string.equals("clearBatch")) {
                    this.clearBatch();
                } else if (string.equals("close")) {
                    this.close();
                } else if (string.equals("getGeneratedKeys")) {
                    object = this instanceof PreparedStatementExecutionHandler ? this.getGeneratedKeys() : this.getGeneratedKeysAsResultSet();
                } else if (string.equals("execute") && objectArray != null && objectArray.length == 2 && objectArray[0] != null) {
                    int n2 = this.connExecutionHandler_.getTypeOfParameterForAGK(method);
                    object = this.executeForAGKs((String)objectArray[0], objectArray[1], n2);
                } else if (string.equals("executeUpdate") && objectArray != null && objectArray.length == 2 && objectArray[0] != null) {
                    int n3 = this.connExecutionHandler_.getTypeOfParameterForAGK(method);
                    object = this.executeUpdateForAGKs((String)objectArray[0], objectArray[1], n3);
                } else if (string.equals("executeQuery") && objectArray == null) {
                    object = this.executeQuery();
                } else if (string.equals("executeUpdate") && objectArray == null) {
                    object = this.executeUpdate();
                } else if (string.equals("execute") && objectArray == null) {
                    object = this.execute();
                } else if (string.equals("close")) {
                    this.close();
                } else {
                    object = string.equals("getMoreResults") ? (objectArray == null ? Boolean.valueOf(this.getMoreResults()) : Boolean.valueOf(this.getMoreResults((Integer)objectArray[0]))) : (string.equals("equals") || string.equals("hashCode") || string.equals("toString") ? method.invoke((Object)this.physicalStatement_, objectArray) : (this.prepStmtHandle_ != null ? method.invoke(this.prepStmtHandle_.getUnderlyingObject(), objectArray) : method.invoke((Object)this.physicalStatement_, objectArray)));
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                DataLogger.logThrowable(this.logger_, throwable);
                this.dumpLogs(throwable);
                throw throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10455);
            }
            catch (SQLException sQLException) {
                DataLogger.logThrowable(this.logger_, sQLException);
                this.dumpLogs(sQLException);
                throw sQLException;
            }
            if (bl2) {
                DataLogger.exit(this.logger_, this, "invoke: " + string, object);
            }
            return object;
        }
    }

    @Override
    protected boolean shouldDumpLogs(Throwable throwable) {
        if (this.isRepositoryConnection()) {
            return false;
        }
        String string = DataProperties.getProperty("pdq.dumpLogsOnSqlCodes");
        if (string != null) {
            return Log.isLoggable(throwable);
        }
        return false;
    }

    protected ConnectionExecutionHandler wrapConnection(Connection connection) {
        return this.connExecutionHandler_;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordNonQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, long l8, long l9, int n2) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordNonQueryStmt(this.connExecutionHandler_, this.sqlStr_, null, null, sqlStatementKey, null, null, this.getCurrentSqlType(), false, this.definitionTraceInfo_, stringArray, null, null, l8, l9, n2);
        return sqlStatementInfo;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement, ResultSet resultSet, long l8, long l9, int n2, int n3) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordQueryStmt(this.connExecutionHandler_, this.sqlStr_, null, null, sqlStatementKey, null, null, null, this.getCurrentSqlType(), this.definitionTraceInfo_, stringArray, null, l8, l9, n2, n3);
        return sqlStatementInfo;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordBatchedQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordQueryStmt(this.connExecutionHandler_, this.sqlStr_, null, null, sqlStatementKey, null, null, null, this.getCurrentSqlType(), this.definitionTraceInfo_, stringArray, null, 0L, 0L, 0, 0);
        return sqlStatementInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetExecutionHandler executeQuery() throws SQLException {
        boolean bl2;
        boolean bl3;
        SqlStatementKey sqlStatementKey;
        ResultSet resultSet = null;
        ResultSetExecutionHandler resultSetExecutionHandler = null;
        boolean bl4 = true;
        try {
            resultSet = ((PreparedStatement)this.physicalStatement_).executeQuery();
            if (resultSet != null) {
                resultSetExecutionHandler = this.wrapResultSet(resultSet);
            }
            bl4 = false;
            sqlStatementKey = null;
            bl3 = false;
            bl2 = true;
        }
        catch (Throwable throwable) {
            SqlStatementKey sqlStatementKey2 = null;
            boolean bl5 = false;
            boolean bl6 = true;
            String[][] stringArray = null;
            StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
            if (this.currentStates_.getCaptureMode() == 5) {
                Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
                synchronized (object) {
                    sqlStatementKey2 = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                    bl5 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey2);
                    if (bl5) {
                        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey2);
                        this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey2);
                    } else if (!bl4 && (bl6 = this.isCapturableNonParameter())) {
                        if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                            stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                            if (this.definitionTraceInfo_ == null) {
                                this.definitionTraceInfo_ = stringArray;
                            }
                        }
                        sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey2, stringArray, (PreparedStatement)this.physicalStatement_, resultSet, 0L, 0L, 0, 0);
                        this.defStackTrcCaptured_ = true;
                    }
                }
                if (bl5) {
                    object = sqlStatementInfo;
                    synchronized (object) {
                        if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                            String[][] stringArray2 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                            if (!this.isPStmtAPI_) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(stringArray2, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            } else if (!this.defStackTrcCaptured_) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                                this.defStackTrcCaptured_ = true;
                            } else {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(null, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            }
                        }
                        this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.connExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), 0L, 0L, 0, 0);
                    }
                }
                if (bl6 && (bl5 || !bl5 && !bl4)) {
                    this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl5);
                }
            }
            throw throwable;
        }
        String[][] stringArray = null;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        if (this.currentStates_.getCaptureMode() == 5) {
            Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object) {
                sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                bl3 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl3) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl4 && (bl2 = this.isCapturableNonParameter())) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                        stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (this.definitionTraceInfo_ == null) {
                            this.definitionTraceInfo_ = stringArray;
                        }
                    }
                    sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey, stringArray, (PreparedStatement)this.physicalStatement_, resultSet, 0L, 0L, 0, 0);
                    this.defStackTrcCaptured_ = true;
                }
            }
            if (bl3) {
                object = sqlStatementInfo;
                synchronized (object) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        String[][] stringArray3 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.isPStmtAPI_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(stringArray3, stringArray3, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        } else if (!this.defStackTrcCaptured_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, stringArray3, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            this.defStackTrcCaptured_ = true;
                        } else {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, stringArray3, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.connExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), 0L, 0L, 0, 0);
                }
            }
            if (bl2 && (bl3 || !bl3 && !bl4)) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl3);
            }
        }
        return resultSetExecutionHandler;
    }

    public int executeUpdate() throws SQLException {
        int n2 = 0;
        boolean bl2 = true;
        try {
            n2 = ((PreparedStatement)this.physicalStatement_).executeUpdate();
            bl2 = false;
        }
        finally {
            this.checkAndCaptureNonQueryStmt(bl2, true, 0L, 0L, 0);
        }
        return n2;
    }

    public boolean execute() throws SQLException {
        if (this.isSELECTorXQUERY()) {
            this.resultSet_ = this.executeQuery();
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            bl2 = ((PreparedStatement)this.physicalStatement_).execute();
            bl3 = false;
        }
        finally {
            this.checkAndCaptureNonQueryStmt(bl3, true, 0L, 0L, 0);
        }
        return bl2;
    }

    protected Object getGeneratedKeys() throws SQLException {
        ResultSet resultSet = this.physicalStatement_.getGeneratedKeys();
        if (resultSet != null) {
            return this.wrapResultSet(resultSet);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int[] executeBatch() throws SQLException {
        int[] nArray = null;
        boolean bl2 = true;
        try {
            nArray = this.physicalStatement_.executeBatch();
            bl2 = false;
        }
        finally {
            if (this instanceof PreparedStatementExecutionHandler) {
                this.checkAndCaptureNonQueryStmt(bl2, true, 0L, 0L, 0);
            } else {
                try {
                    if (this.currentStates_.getCaptureMode() == 5 && this.currentStates_.getStackTraceDepth() != 0 && this.currentStates_.getMaxStackTracesCaptured() != 0) {
                        this.currentStates_.getProfilerHelperInstance().captureBatchingExecutionTrace(this.batchStatements_, this.currentStates_.getStackTraceDepth(), this.currentStates_.getMaxStackTracesCaptured(), this.currentStates_.getPackagePrefixArray());
                    }
                }
                finally {
                    this.batchStatements_.clear();
                }
            }
        }
        return nArray;
    }
}

