/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.model;

import com.ibm.cloud.objectstorage.services.s3.model.SSEAlgorithm;
import java.io.Serializable;

public class SSEAwsKeyManagementParams
implements Serializable {
    private String awsKmsKeyId;
    private String awsKmsEncryptionContext;
    private String sseAlgorithm = SSEAlgorithm.KMS.getAlgorithm();

    public SSEAwsKeyManagementParams() {
        this.awsKmsEncryptionContext = null;
        this.awsKmsKeyId = null;
    }

    public SSEAwsKeyManagementParams(String awsKmsKeyId) {
        if (awsKmsKeyId == null || awsKmsKeyId.trim().isEmpty()) {
            throw new IllegalArgumentException("AWS Key Management System Key id cannot be null");
        }
        this.awsKmsKeyId = awsKmsKeyId;
        this.awsKmsEncryptionContext = null;
    }

    public SSEAwsKeyManagementParams(String awsKmsKeyId, SSEAlgorithm sseAlgorithm) {
        this(awsKmsKeyId);
        this.setSseAlgorith(sseAlgorithm);
    }

    public SSEAwsKeyManagementParams(String awsKmsKeyId, String sseAlgorithm) {
        if (awsKmsKeyId == null || awsKmsKeyId.trim().isEmpty()) {
            throw new IllegalArgumentException("AWS Key Management System Key id cannot be null");
        }
        this.setAwsKmsKeyId(awsKmsKeyId);
        this.setSseAlgorith(sseAlgorithm);
    }

    public SSEAwsKeyManagementParams(SSEAlgorithm sseAlgorithm) {
        this();
        this.setSseAlgorith(sseAlgorithm);
    }

    public String getAwsKmsKeyId() {
        return this.awsKmsKeyId;
    }

    public SSEAwsKeyManagementParams withAwsKmsKeyId(String awsKmsKeyId) {
        this.setAwsKmsKeyId(awsKmsKeyId);
        return this;
    }

    public SSEAwsKeyManagementParams withSseAlgorithm(String sseAlgorithm) {
        this.setSseAlgorith(sseAlgorithm);
        return this;
    }

    private void setSseAlgorith(String sseAlgorithm) {
        if (sseAlgorithm == null) {
            throw new IllegalArgumentException("AWS Key Management System SSEAlgorithm cannot be null");
        }
        this.sseAlgorithm = sseAlgorithm;
    }

    private void setSseAlgorith(SSEAlgorithm sseAlgorithm) {
        if (sseAlgorithm == null) {
            throw new IllegalArgumentException("AWS Key Management System SSEAlgorithm cannot be null");
        }
        this.sseAlgorithm = sseAlgorithm.getAlgorithm();
    }

    private void setAwsKmsKeyId(String awsKmsKeyId) {
        this.awsKmsKeyId = awsKmsKeyId;
    }

    public String getEncryption() {
        return this.sseAlgorithm;
    }

    public String getAwsKmsEncryptionContext() {
        return this.awsKmsEncryptionContext;
    }

    public SSEAwsKeyManagementParams withAwsKmsEncryptionContext(String awsKmsEncryptionContext) {
        this.setAwsKmsEncryptionContext(awsKmsEncryptionContext);
        return this;
    }

    private void setAwsKmsEncryptionContext(String awsKmsEncryptionContext) {
        this.awsKmsEncryptionContext = awsKmsEncryptionContext;
    }
}

