/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.RotationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ServiceCredentialsSecretSourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServiceCredentialsSecretPrototype
extends SecretPrototype {
    protected ServiceCredentialsSecretPrototype() {
    }

    protected ServiceCredentialsSecretPrototype(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)((Object)builder.sourceService), (String)"sourceService cannot be null");
        this.customMetadata = builder.customMetadata;
        this.description = builder.description;
        this.labels = builder.labels;
        this.name = builder.name;
        this.rotation = builder.rotation;
        this.secretGroupId = builder.secretGroupId;
        this.secretType = builder.secretType;
        this.sourceService = builder.sourceService;
        this.ttl = builder.ttl;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Map<String, Object> customMetadata;
        private String description;
        private List<String> labels;
        private String name;
        private RotationPolicy rotation;
        private String secretGroupId;
        private String secretType;
        private ServiceCredentialsSecretSourceService sourceService;
        private String ttl;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype serviceCredentialsSecretPrototype) {
            this.customMetadata = serviceCredentialsSecretPrototype.customMetadata;
            this.description = serviceCredentialsSecretPrototype.description;
            this.labels = serviceCredentialsSecretPrototype.labels;
            this.name = serviceCredentialsSecretPrototype.name;
            this.rotation = serviceCredentialsSecretPrototype.rotation;
            this.secretGroupId = serviceCredentialsSecretPrototype.secretGroupId;
            this.secretType = serviceCredentialsSecretPrototype.secretType;
            this.sourceService = serviceCredentialsSecretPrototype.sourceService;
            this.ttl = serviceCredentialsSecretPrototype.ttl;
            this.versionCustomMetadata = serviceCredentialsSecretPrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String name, String secretType, ServiceCredentialsSecretSourceService sourceService) {
            this.name = name;
            this.secretType = secretType;
            this.sourceService = sourceService;
        }

        public ServiceCredentialsSecretPrototype build() {
            return new ServiceCredentialsSecretPrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rotation(RotationPolicy rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder sourceService(ServiceCredentialsSecretSourceService sourceService) {
            this.sourceService = sourceService;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

