/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.UrlHelper;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.SecretsManager;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretsLocksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLocks;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretsLocksPaginatedCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class SecretsLocksPager {
    protected boolean hasNext;
    protected ListSecretsLocksOptions options;
    protected SecretsManager client;
    protected PageContext pageContext;

    protected SecretsLocksPager() {
    }

    public SecretsLocksPager(SecretsManager client, ListSecretsLocksOptions options) {
        if (options.offset() != null && options.offset() != 0L) {
            throw new IllegalArgumentException("The options 'offset' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<SecretLocks> getNext() {
        String queryParam;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListSecretsLocksOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.offset(this.pageContext.getNext());
        }
        this.options = builder.build();
        SecretsLocksPaginatedCollection result = (SecretsLocksPaginatedCollection)((Object)this.client.listSecretsLocks(this.options).execute().getResult());
        Long next = null;
        if (result.getNext() != null && (queryParam = UrlHelper.getQueryParam((String)result.getNext().getHref(), (String)"offset")) != null) {
            next = Long.valueOf(queryParam);
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getSecretsLocks();
    }

    public List<SecretLocks> getAll() {
        ArrayList<SecretLocks> results = new ArrayList<SecretLocks>();
        while (this.hasNext()) {
            List<SecretLocks> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private Long next;

        private PageContext() {
        }

        public Long getNext() {
            return this.next;
        }

        public void setNext(Long next) {
            this.next = next;
        }
    }
}

