/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.UrlHelper;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.SecretsManager;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretVersionLocksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLock;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersionLocksPaginatedCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class SecretVersionLocksPager {
    protected boolean hasNext;
    protected ListSecretVersionLocksOptions options;
    protected SecretsManager client;
    protected PageContext pageContext;

    protected SecretVersionLocksPager() {
    }

    public SecretVersionLocksPager(SecretsManager client, ListSecretVersionLocksOptions options) {
        if (options.offset() != null && options.offset() != 0L) {
            throw new IllegalArgumentException("The options 'offset' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<SecretLock> getNext() {
        String queryParam;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListSecretVersionLocksOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.offset(this.pageContext.getNext());
        }
        this.options = builder.build();
        SecretVersionLocksPaginatedCollection result = (SecretVersionLocksPaginatedCollection)((Object)this.client.listSecretVersionLocks(this.options).execute().getResult());
        Long next = null;
        if (result.getNext() != null && (queryParam = UrlHelper.getQueryParam((String)result.getNext().getHref(), (String)"offset")) != null) {
            next = Long.valueOf(queryParam);
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getLocks();
    }

    public List<SecretLock> getAll() {
        ArrayList<SecretLock> results = new ArrayList<SecretLock>();
        while (this.hasNext()) {
            List<SecretLock> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private Long next;

        private PageContext() {
        }

        public Long getNext() {
            return this.next;
        }

        public void setNext(Long next) {
            this.next = next;
        }
    }
}

