/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.RotationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PublicCertificatePrototype
extends SecretPrototype {
    protected PublicCertificatePrototype() {
    }

    protected PublicCertificatePrototype(Builder builder) {
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.ca, (String)"ca cannot be null");
        Validator.notNull((Object)builder.dns, (String)"dns cannot be null");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.description = builder.description;
        this.secretGroupId = builder.secretGroupId;
        this.labels = builder.labels;
        this.commonName = builder.commonName;
        this.altNames = builder.altNames;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.ca = builder.ca;
        this.dns = builder.dns;
        this.bundleCerts = builder.bundleCerts;
        this.rotation = builder.rotation;
        this.customMetadata = builder.customMetadata;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String description;
        private String secretGroupId;
        private List<String> labels;
        private String commonName;
        private List<String> altNames;
        private String keyAlgorithm;
        private String ca;
        private String dns;
        private Boolean bundleCerts;
        private RotationPolicy rotation;
        private Map<String, Object> customMetadata;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype publicCertificatePrototype) {
            this.secretType = publicCertificatePrototype.secretType;
            this.name = publicCertificatePrototype.name;
            this.description = publicCertificatePrototype.description;
            this.secretGroupId = publicCertificatePrototype.secretGroupId;
            this.labels = publicCertificatePrototype.labels;
            this.commonName = publicCertificatePrototype.commonName;
            this.altNames = publicCertificatePrototype.altNames;
            this.keyAlgorithm = publicCertificatePrototype.keyAlgorithm;
            this.ca = publicCertificatePrototype.ca;
            this.dns = publicCertificatePrototype.dns;
            this.bundleCerts = publicCertificatePrototype.bundleCerts;
            this.rotation = publicCertificatePrototype.rotation;
            this.customMetadata = publicCertificatePrototype.customMetadata;
            this.versionCustomMetadata = publicCertificatePrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, String ca, String dns) {
            this.secretType = secretType;
            this.name = name;
            this.ca = ca;
            this.dns = dns;
        }

        public PublicCertificatePrototype build() {
            return new PublicCertificatePrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder addAltNames(String altNames) {
            Validator.notNull((Object)altNames, (String)"altNames cannot be null");
            if (this.altNames == null) {
                this.altNames = new ArrayList<String>();
            }
            this.altNames.add(altNames);
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public Builder altNames(List<String> altNames) {
            this.altNames = altNames;
            return this;
        }

        public Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public Builder ca(String ca) {
            this.ca = ca;
            return this;
        }

        public Builder dns(String dns) {
            this.dns = dns;
            return this;
        }

        public Builder bundleCerts(Boolean bundleCerts) {
            this.bundleCerts = bundleCerts;
            return this;
        }

        public Builder rotation(RotationPolicy rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

