/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.RotationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PrivateCertificatePrototype
extends SecretPrototype {
    protected PrivateCertificatePrototype() {
    }

    protected PrivateCertificatePrototype(Builder builder) {
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.certificateTemplate, (String)"certificateTemplate cannot be null");
        Validator.notNull((Object)builder.commonName, (String)"commonName cannot be null");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.description = builder.description;
        this.secretGroupId = builder.secretGroupId;
        this.labels = builder.labels;
        this.certificateTemplate = builder.certificateTemplate;
        this.commonName = builder.commonName;
        this.altNames = builder.altNames;
        this.ipSans = builder.ipSans;
        this.uriSans = builder.uriSans;
        this.otherSans = builder.otherSans;
        this.csr = builder.csr;
        this.format = builder.format;
        this.privateKeyFormat = builder.privateKeyFormat;
        this.excludeCnFromSans = builder.excludeCnFromSans;
        this.ttl = builder.ttl;
        this.rotation = builder.rotation;
        this.customMetadata = builder.customMetadata;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String description;
        private String secretGroupId;
        private List<String> labels;
        private String certificateTemplate;
        private String commonName;
        private List<String> altNames;
        private String ipSans;
        private String uriSans;
        private List<String> otherSans;
        private String csr;
        private String format;
        private String privateKeyFormat;
        private Boolean excludeCnFromSans;
        private String ttl;
        private RotationPolicy rotation;
        private Map<String, Object> customMetadata;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype privateCertificatePrototype) {
            this.secretType = privateCertificatePrototype.secretType;
            this.name = privateCertificatePrototype.name;
            this.description = privateCertificatePrototype.description;
            this.secretGroupId = privateCertificatePrototype.secretGroupId;
            this.labels = privateCertificatePrototype.labels;
            this.certificateTemplate = privateCertificatePrototype.certificateTemplate;
            this.commonName = privateCertificatePrototype.commonName;
            this.altNames = privateCertificatePrototype.altNames;
            this.ipSans = privateCertificatePrototype.ipSans;
            this.uriSans = privateCertificatePrototype.uriSans;
            this.otherSans = privateCertificatePrototype.otherSans;
            this.csr = privateCertificatePrototype.csr;
            this.format = privateCertificatePrototype.format;
            this.privateKeyFormat = privateCertificatePrototype.privateKeyFormat;
            this.excludeCnFromSans = privateCertificatePrototype.excludeCnFromSans;
            this.ttl = privateCertificatePrototype.ttl;
            this.rotation = privateCertificatePrototype.rotation;
            this.customMetadata = privateCertificatePrototype.customMetadata;
            this.versionCustomMetadata = privateCertificatePrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, String certificateTemplate, String commonName) {
            this.secretType = secretType;
            this.name = name;
            this.certificateTemplate = certificateTemplate;
            this.commonName = commonName;
        }

        public PrivateCertificatePrototype build() {
            return new PrivateCertificatePrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder addAltNames(String altNames) {
            Validator.notNull((Object)altNames, (String)"altNames cannot be null");
            if (this.altNames == null) {
                this.altNames = new ArrayList<String>();
            }
            this.altNames.add(altNames);
            return this;
        }

        public Builder addOtherSans(String otherSans) {
            Validator.notNull((Object)otherSans, (String)"otherSans cannot be null");
            if (this.otherSans == null) {
                this.otherSans = new ArrayList<String>();
            }
            this.otherSans.add(otherSans);
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder certificateTemplate(String certificateTemplate) {
            this.certificateTemplate = certificateTemplate;
            return this;
        }

        public Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public Builder altNames(List<String> altNames) {
            this.altNames = altNames;
            return this;
        }

        public Builder ipSans(String ipSans) {
            this.ipSans = ipSans;
            return this;
        }

        public Builder uriSans(String uriSans) {
            this.uriSans = uriSans;
            return this;
        }

        public Builder otherSans(List<String> otherSans) {
            this.otherSans = otherSans;
            return this;
        }

        public Builder csr(String csr) {
            this.csr = csr;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder privateKeyFormat(String privateKeyFormat) {
            this.privateKeyFormat = privateKeyFormat;
            return this;
        }

        public Builder excludeCnFromSans(Boolean excludeCnFromSans) {
            this.excludeCnFromSans = excludeCnFromSans;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder rotation(RotationPolicy rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface PrivateKeyFormat {
        public static final String DER = "der";
        public static final String PKCS8 = "pkcs8";
    }

    public static interface Format {
        public static final String PEM = "pem";
        public static final String PEM_BUNDLE = "pem_bundle";
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

