/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListSecretsOptions
extends GenericModel {
    protected Long offset;
    protected Long limit;
    protected String sort;
    protected String search;
    protected List<String> groups;
    protected List<String> secretTypes;
    protected List<String> matchAllLabels;

    protected ListSecretsOptions() {
    }

    protected ListSecretsOptions(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.sort = builder.sort;
        this.search = builder.search;
        this.groups = builder.groups;
        this.secretTypes = builder.secretTypes;
        this.matchAllLabels = builder.matchAllLabels;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long offset() {
        return this.offset;
    }

    public Long limit() {
        return this.limit;
    }

    public String sort() {
        return this.sort;
    }

    public String search() {
        return this.search;
    }

    public List<String> groups() {
        return this.groups;
    }

    public List<String> secretTypes() {
        return this.secretTypes;
    }

    public List<String> matchAllLabels() {
        return this.matchAllLabels;
    }

    public static class Builder {
        private Long offset;
        private Long limit;
        private String sort;
        private String search;
        private List<String> groups;
        private List<String> secretTypes;
        private List<String> matchAllLabels;

        private Builder(ListSecretsOptions listSecretsOptions) {
            this.offset = listSecretsOptions.offset;
            this.limit = listSecretsOptions.limit;
            this.sort = listSecretsOptions.sort;
            this.search = listSecretsOptions.search;
            this.groups = listSecretsOptions.groups;
            this.secretTypes = listSecretsOptions.secretTypes;
            this.matchAllLabels = listSecretsOptions.matchAllLabels;
        }

        public Builder() {
        }

        public ListSecretsOptions build() {
            return new ListSecretsOptions(this);
        }

        public Builder addGroups(String groups) {
            Validator.notNull((Object)groups, (String)"groups cannot be null");
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(groups);
            return this;
        }

        public Builder addSecretTypes(String secretTypes) {
            Validator.notNull((Object)secretTypes, (String)"secretTypes cannot be null");
            if (this.secretTypes == null) {
                this.secretTypes = new ArrayList<String>();
            }
            this.secretTypes.add(secretTypes);
            return this;
        }

        public Builder addMatchAllLabels(String matchAllLabels) {
            Validator.notNull((Object)matchAllLabels, (String)"matchAllLabels cannot be null");
            if (this.matchAllLabels == null) {
                this.matchAllLabels = new ArrayList<String>();
            }
            this.matchAllLabels.add(matchAllLabels);
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder search(String search) {
            this.search = search;
            return this;
        }

        public Builder groups(List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder secretTypes(List<String> secretTypes) {
            this.secretTypes = secretTypes;
            return this;
        }

        public Builder matchAllLabels(List<String> matchAllLabels) {
            this.matchAllLabels = matchAllLabels;
            return this;
        }
    }

    public static interface SecretTypes {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

