/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListSecretsLocksOptions
extends GenericModel {
    protected Long offset;
    protected Long limit;
    protected String search;
    protected List<String> groups;

    protected ListSecretsLocksOptions() {
    }

    protected ListSecretsLocksOptions(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.search = builder.search;
        this.groups = builder.groups;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long offset() {
        return this.offset;
    }

    public Long limit() {
        return this.limit;
    }

    public String search() {
        return this.search;
    }

    public List<String> groups() {
        return this.groups;
    }

    public static class Builder {
        private Long offset;
        private Long limit;
        private String search;
        private List<String> groups;

        private Builder(ListSecretsLocksOptions listSecretsLocksOptions) {
            this.offset = listSecretsLocksOptions.offset;
            this.limit = listSecretsLocksOptions.limit;
            this.search = listSecretsLocksOptions.search;
            this.groups = listSecretsLocksOptions.groups;
        }

        public Builder() {
        }

        public ListSecretsLocksOptions build() {
            return new ListSecretsLocksOptions(this);
        }

        public Builder addGroups(String groups) {
            Validator.notNull((Object)groups, (String)"groups cannot be null");
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(groups);
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder search(String search) {
            this.search = search;
            return this;
        }

        public Builder groups(List<String> groups) {
            this.groups = groups;
            return this;
        }
    }
}

