/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListConfigurationsOptions
extends GenericModel {
    protected Long offset;
    protected Long limit;
    protected String sort;
    protected String search;
    protected List<String> secretTypes;

    protected ListConfigurationsOptions() {
    }

    protected ListConfigurationsOptions(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.sort = builder.sort;
        this.search = builder.search;
        this.secretTypes = builder.secretTypes;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long offset() {
        return this.offset;
    }

    public Long limit() {
        return this.limit;
    }

    public String sort() {
        return this.sort;
    }

    public String search() {
        return this.search;
    }

    public List<String> secretTypes() {
        return this.secretTypes;
    }

    public static class Builder {
        private Long offset;
        private Long limit;
        private String sort;
        private String search;
        private List<String> secretTypes;

        private Builder(ListConfigurationsOptions listConfigurationsOptions) {
            this.offset = listConfigurationsOptions.offset;
            this.limit = listConfigurationsOptions.limit;
            this.sort = listConfigurationsOptions.sort;
            this.search = listConfigurationsOptions.search;
            this.secretTypes = listConfigurationsOptions.secretTypes;
        }

        public Builder() {
        }

        public ListConfigurationsOptions build() {
            return new ListConfigurationsOptions(this);
        }

        public Builder addSecretTypes(String secretTypes) {
            Validator.notNull((Object)secretTypes, (String)"secretTypes cannot be null");
            if (this.secretTypes == null) {
                this.secretTypes = new ArrayList<String>();
            }
            this.secretTypes.add(secretTypes);
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder search(String search) {
            this.search = search;
            return this;
        }

        public Builder secretTypes(List<String> secretTypes) {
            this.secretTypes = secretTypes;
            return this;
        }
    }

    public static interface SecretTypes {
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

