/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ConfigurationPrototype;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CustomCredentialsConfigurationCodeEngine;

public class CustomCredentialsConfigurationPrototype
extends ConfigurationPrototype {
    protected CustomCredentialsConfigurationPrototype() {
    }

    protected CustomCredentialsConfigurationPrototype(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.configType, (String)"configType cannot be null");
        Validator.notNull((Object)((Object)builder.codeEngine), (String)"codeEngine cannot be null");
        this.name = builder.name;
        this.configType = builder.configType;
        this.apiKeyRef = builder.apiKeyRef;
        this.codeEngine = builder.codeEngine;
        this.taskTimeout = builder.taskTimeout;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String name;
        private String configType;
        private String apiKeyRef;
        private CustomCredentialsConfigurationCodeEngine codeEngine;
        private String taskTimeout;

        public Builder(ConfigurationPrototype customCredentialsConfigurationPrototype) {
            this.name = customCredentialsConfigurationPrototype.name;
            this.configType = customCredentialsConfigurationPrototype.configType;
            this.apiKeyRef = customCredentialsConfigurationPrototype.apiKeyRef;
            this.codeEngine = customCredentialsConfigurationPrototype.codeEngine;
            this.taskTimeout = customCredentialsConfigurationPrototype.taskTimeout;
        }

        public Builder() {
        }

        public Builder(String name, String configType, CustomCredentialsConfigurationCodeEngine codeEngine) {
            this.name = name;
            this.configType = configType;
            this.codeEngine = codeEngine;
        }

        public CustomCredentialsConfigurationPrototype build() {
            return new CustomCredentialsConfigurationPrototype(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        public Builder apiKeyRef(String apiKeyRef) {
            this.apiKeyRef = apiKeyRef;
            return this;
        }

        public Builder codeEngine(CustomCredentialsConfigurationCodeEngine codeEngine) {
            this.codeEngine = codeEngine;
            return this;
        }

        public Builder taskTimeout(String taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }
    }

    public static interface ConfigType {
        public static final String PUBLIC_CERT_CONFIGURATION_DNS_CLOUD_INTERNET_SERVICES = "public_cert_configuration_dns_cloud_internet_services";
        public static final String PUBLIC_CERT_CONFIGURATION_DNS_CLASSIC_INFRASTRUCTURE = "public_cert_configuration_dns_classic_infrastructure";
        public static final String PUBLIC_CERT_CONFIGURATION_CA_LETS_ENCRYPT = "public_cert_configuration_ca_lets_encrypt";
        public static final String PRIVATE_CERT_CONFIGURATION_ROOT_CA = "private_cert_configuration_root_ca";
        public static final String PRIVATE_CERT_CONFIGURATION_INTERMEDIATE_CA = "private_cert_configuration_intermediate_ca";
        public static final String PRIVATE_CERT_CONFIGURATION_TEMPLATE = "private_cert_configuration_template";
        public static final String IAM_CREDENTIALS_CONFIGURATION = "iam_credentials_configuration";
        public static final String CUSTOM_CREDENTIALS_CONFIGURATION = "custom_credentials_configuration";
    }
}

