/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLockPrototype;
import java.util.ArrayList;
import java.util.List;

public class CreateSecretVersionLocksBulkOptions
extends GenericModel {
    protected String secretId;
    protected String id;
    protected List<SecretLockPrototype> locks;
    protected String mode;

    protected CreateSecretVersionLocksBulkOptions() {
    }

    protected CreateSecretVersionLocksBulkOptions(Builder builder) {
        Validator.notEmpty((String)builder.secretId, (String)"secretId cannot be empty");
        Validator.notEmpty((String)builder.id, (String)"id cannot be empty");
        Validator.notNull((Object)builder.locks, (String)"locks cannot be null");
        this.secretId = builder.secretId;
        this.id = builder.id;
        this.locks = builder.locks;
        this.mode = builder.mode;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String secretId() {
        return this.secretId;
    }

    public String id() {
        return this.id;
    }

    public List<SecretLockPrototype> locks() {
        return this.locks;
    }

    public String mode() {
        return this.mode;
    }

    public static class Builder {
        private String secretId;
        private String id;
        private List<SecretLockPrototype> locks;
        private String mode;

        private Builder(CreateSecretVersionLocksBulkOptions createSecretVersionLocksBulkOptions) {
            this.secretId = createSecretVersionLocksBulkOptions.secretId;
            this.id = createSecretVersionLocksBulkOptions.id;
            this.locks = createSecretVersionLocksBulkOptions.locks;
            this.mode = createSecretVersionLocksBulkOptions.mode;
        }

        public Builder() {
        }

        public Builder(String secretId, String id, List<SecretLockPrototype> locks) {
            this.secretId = secretId;
            this.id = id;
            this.locks = locks;
        }

        public CreateSecretVersionLocksBulkOptions build() {
            return new CreateSecretVersionLocksBulkOptions(this);
        }

        public Builder addLocks(SecretLockPrototype locks) {
            Validator.notNull((Object)((Object)locks), (String)"locks cannot be null");
            if (this.locks == null) {
                this.locks = new ArrayList<SecretLockPrototype>();
            }
            this.locks.add(locks);
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locks(List<SecretLockPrototype> locks) {
            this.locks = locks;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }
    }

    public static interface Mode {
        public static final String REMOVE_PREVIOUS = "remove_previous";
        public static final String REMOVE_PREVIOUS_AND_DELETE = "remove_previous_and_delete";
    }
}

