/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.common.SdkCommon;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.Configuration;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ConfigurationAction;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ConfigurationMetadataPaginatedCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateConfigurationActionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateConfigurationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateNotificationsRegistrationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretActionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretGroupOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretLocksBulkOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretVersionActionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretVersionLocksBulkOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretVersionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteConfigurationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteNotificationsRegistrationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretGroupOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretLocksBulkOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretTaskOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretVersionDataOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretVersionLocksBulkOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetConfigurationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetNotificationsRegistrationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetNotificationsRegistrationTestOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretByNameTypeOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretGroupOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretMetadataOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretTaskOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretVersionMetadataOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretVersionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListConfigurationsOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretGroupsOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretLocksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretTasksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretVersionLocksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretVersionsOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretsLocksOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ListSecretsOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.NotificationsRegistration;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ReplaceSecretTaskOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.Secret;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretAction;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretGroup;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretGroupCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLocks;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLocksPaginatedCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretMetadata;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretMetadataPaginatedCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretTask;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretTaskCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersion;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersionLocksPaginatedCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersionMetadata;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersionMetadataCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretsLocksPaginatedCollection;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.UpdateConfigurationOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.UpdateSecretGroupOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.UpdateSecretMetadataOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.UpdateSecretVersionMetadataOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.VersionAction;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class SecretsManager
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "secrets_manager";
    public static final String DEFAULT_SERVICE_URL = "https://provide-here-your-smgr-instanceuuid.us-south.secrets-manager.appdomain.cloud";
    public static final String PARAMETERIZED_SERVICE_URL = "https://{instance_id}.{region}.secrets-manager.appdomain.cloud";
    private static final Map<String, String> defaultUrlVariables = SecretsManager.createDefaultUrlVariables();

    private static Map<String, String> createDefaultUrlVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance_id", "provide-here-your-smgr-instanceuuid");
        map.put("region", "us-south");
        return map;
    }

    public static SecretsManager newInstance() {
        return SecretsManager.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static SecretsManager newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        SecretsManager service = new SecretsManager(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public SecretsManager(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public static String constructServiceUrl(Map<String, String> providedUrlVariables) {
        return BaseService.constructServiceUrl((String)PARAMETERIZED_SERVICE_URL, defaultUrlVariables, providedUrlVariables);
    }

    public ServiceCall<SecretGroup> createSecretGroup(CreateSecretGroupOptions createSecretGroupOptions) {
        Validator.notNull((Object)((Object)createSecretGroupOptions), (String)"createSecretGroupOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretGroup");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createSecretGroupOptions.name());
        if (createSecretGroupOptions.description() != null) {
            contentJson.addProperty("description", createSecretGroupOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretGroup>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretGroupCollection> listSecretGroups(ListSecretGroupsOptions listSecretGroupsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretGroups");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretGroupCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretGroupCollection> listSecretGroups() {
        return this.listSecretGroups(null);
    }

    public ServiceCall<SecretGroup> getSecretGroup(GetSecretGroupOptions getSecretGroupOptions) {
        Validator.notNull((Object)((Object)getSecretGroupOptions), (String)"getSecretGroupOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getSecretGroupOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretGroup");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretGroup>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretGroup> updateSecretGroup(UpdateSecretGroupOptions updateSecretGroupOptions) {
        Validator.notNull((Object)((Object)updateSecretGroupOptions), (String)"updateSecretGroupOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateSecretGroupOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateSecretGroup");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateSecretGroupOptions.secretGroupPatch()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretGroup>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSecretGroup(DeleteSecretGroupOptions deleteSecretGroupOptions) {
        Validator.notNull((Object)((Object)deleteSecretGroupOptions), (String)"deleteSecretGroupOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteSecretGroupOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecretGroup");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Secret> createSecret(CreateSecretOptions createSecretOptions) {
        Validator.notNull((Object)((Object)createSecretOptions), (String)"createSecretOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecret");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createSecretOptions.secretPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretMetadataPaginatedCollection> listSecrets(ListSecretsOptions listSecretsOptions) {
        if (listSecretsOptions == null) {
            listSecretsOptions = new ListSecretsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecrets");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listSecretsOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(listSecretsOptions.offset())});
        }
        if (listSecretsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listSecretsOptions.limit())});
        }
        if (listSecretsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listSecretsOptions.sort())});
        }
        if (listSecretsOptions.search() != null) {
            builder.query(new Object[]{"search", String.valueOf(listSecretsOptions.search())});
        }
        if (listSecretsOptions.groups() != null) {
            builder.query(new Object[]{"groups", RequestUtils.join(listSecretsOptions.groups(), (String)",")});
        }
        if (listSecretsOptions.secretTypes() != null) {
            builder.query(new Object[]{"secret_types", RequestUtils.join(listSecretsOptions.secretTypes(), (String)",")});
        }
        if (listSecretsOptions.matchAllLabels() != null) {
            builder.query(new Object[]{"match_all_labels", RequestUtils.join(listSecretsOptions.matchAllLabels(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretMetadataPaginatedCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretMetadataPaginatedCollection> listSecrets() {
        return this.listSecrets(null);
    }

    public ServiceCall<Secret> getSecret(GetSecretOptions getSecretOptions) {
        Validator.notNull((Object)((Object)getSecretOptions), (String)"getSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getSecretOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecret");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSecret(DeleteSecretOptions deleteSecretOptions) {
        Validator.notNull((Object)((Object)deleteSecretOptions), (String)"deleteSecretOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteSecretOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecret");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteSecretOptions.forceDelete() != null) {
            builder.query(new Object[]{"force_delete", String.valueOf(deleteSecretOptions.forceDelete())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretMetadata> getSecretMetadata(GetSecretMetadataOptions getSecretMetadataOptions) {
        Validator.notNull((Object)((Object)getSecretMetadataOptions), (String)"getSecretMetadataOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getSecretMetadataOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/metadata", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretMetadata> updateSecretMetadata(UpdateSecretMetadataOptions updateSecretMetadataOptions) {
        Validator.notNull((Object)((Object)updateSecretMetadataOptions), (String)"updateSecretMetadataOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", updateSecretMetadataOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/metadata", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateSecretMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateSecretMetadataOptions.secretMetadataPatch()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretAction> createSecretAction(CreateSecretActionOptions createSecretActionOptions) {
        Validator.notNull((Object)((Object)createSecretActionOptions), (String)"createSecretActionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", createSecretActionOptions.id());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/actions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretAction");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createSecretActionOptions.secretActionPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretAction>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Secret> getSecretByNameType(GetSecretByNameTypeOptions getSecretByNameTypeOptions) {
        Validator.notNull((Object)((Object)getSecretByNameTypeOptions), (String)"getSecretByNameTypeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_type", getSecretByNameTypeOptions.secretType());
        pathParamsMap.put("name", getSecretByNameTypeOptions.name());
        pathParamsMap.put("secret_group_name", getSecretByNameTypeOptions.secretGroupName());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secret_groups/{secret_group_name}/secret_types/{secret_type}/secrets/{name}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretByNameType");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Secret>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersion> createSecretVersion(CreateSecretVersionOptions createSecretVersionOptions) {
        Validator.notNull((Object)((Object)createSecretVersionOptions), (String)"createSecretVersionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", createSecretVersionOptions.secretId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretVersion");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createSecretVersionOptions.secretVersionPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersion>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersionMetadataCollection> listSecretVersions(ListSecretVersionsOptions listSecretVersionsOptions) {
        Validator.notNull((Object)((Object)listSecretVersionsOptions), (String)"listSecretVersionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", listSecretVersionsOptions.secretId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretVersions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersionMetadataCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersion> getSecretVersion(GetSecretVersionOptions getSecretVersionOptions) {
        Validator.notNull((Object)((Object)getSecretVersionOptions), (String)"getSecretVersionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", getSecretVersionOptions.secretId());
        pathParamsMap.put("id", getSecretVersionOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretVersion");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersion>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSecretVersionData(DeleteSecretVersionDataOptions deleteSecretVersionDataOptions) {
        Validator.notNull((Object)((Object)deleteSecretVersionDataOptions), (String)"deleteSecretVersionDataOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", deleteSecretVersionDataOptions.secretId());
        pathParamsMap.put("id", deleteSecretVersionDataOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/secret_data", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecretVersionData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersionMetadata> getSecretVersionMetadata(GetSecretVersionMetadataOptions getSecretVersionMetadataOptions) {
        Validator.notNull((Object)((Object)getSecretVersionMetadataOptions), (String)"getSecretVersionMetadataOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", getSecretVersionMetadataOptions.secretId());
        pathParamsMap.put("id", getSecretVersionMetadataOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/metadata", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretVersionMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersionMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersionMetadata> updateSecretVersionMetadata(UpdateSecretVersionMetadataOptions updateSecretVersionMetadataOptions) {
        Validator.notNull((Object)((Object)updateSecretVersionMetadataOptions), (String)"updateSecretVersionMetadataOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", updateSecretVersionMetadataOptions.secretId());
        pathParamsMap.put("id", updateSecretVersionMetadataOptions.id());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/metadata", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateSecretVersionMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateSecretVersionMetadataOptions.secretVersionMetadataPatch()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersionMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<VersionAction> createSecretVersionAction(CreateSecretVersionActionOptions createSecretVersionActionOptions) {
        Validator.notNull((Object)((Object)createSecretVersionActionOptions), (String)"createSecretVersionActionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", createSecretVersionActionOptions.secretId());
        pathParamsMap.put("id", createSecretVersionActionOptions.id());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/actions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretVersionAction");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createSecretVersionActionOptions.secretVersionActionPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<VersionAction>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretTaskCollection> listSecretTasks(ListSecretTasksOptions listSecretTasksOptions) {
        Validator.notNull((Object)((Object)listSecretTasksOptions), (String)"listSecretTasksOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", listSecretTasksOptions.secretId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/tasks", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretTasks");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretTaskCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretTask> getSecretTask(GetSecretTaskOptions getSecretTaskOptions) {
        Validator.notNull((Object)((Object)getSecretTaskOptions), (String)"getSecretTaskOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", getSecretTaskOptions.secretId());
        pathParamsMap.put("id", getSecretTaskOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/tasks/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getSecretTask");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretTask>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretTask> replaceSecretTask(ReplaceSecretTaskOptions replaceSecretTaskOptions) {
        Validator.notNull((Object)((Object)replaceSecretTaskOptions), (String)"replaceSecretTaskOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", replaceSecretTaskOptions.secretId());
        pathParamsMap.put("id", replaceSecretTaskOptions.id());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/tasks/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"replaceSecretTask");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)replaceSecretTaskOptions.taskPut()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretTask>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSecretTask(DeleteSecretTaskOptions deleteSecretTaskOptions) {
        Validator.notNull((Object)((Object)deleteSecretTaskOptions), (String)"deleteSecretTaskOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", deleteSecretTaskOptions.secretId());
        pathParamsMap.put("id", deleteSecretTaskOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/tasks/{id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecretTask");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretsLocksPaginatedCollection> listSecretsLocks(ListSecretsLocksOptions listSecretsLocksOptions) {
        if (listSecretsLocksOptions == null) {
            listSecretsLocksOptions = new ListSecretsLocksOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets_locks"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretsLocks");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listSecretsLocksOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(listSecretsLocksOptions.offset())});
        }
        if (listSecretsLocksOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listSecretsLocksOptions.limit())});
        }
        if (listSecretsLocksOptions.search() != null) {
            builder.query(new Object[]{"search", String.valueOf(listSecretsLocksOptions.search())});
        }
        if (listSecretsLocksOptions.groups() != null) {
            builder.query(new Object[]{"groups", RequestUtils.join(listSecretsLocksOptions.groups(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretsLocksPaginatedCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretsLocksPaginatedCollection> listSecretsLocks() {
        return this.listSecretsLocks(null);
    }

    public ServiceCall<SecretLocksPaginatedCollection> listSecretLocks(ListSecretLocksOptions listSecretLocksOptions) {
        Validator.notNull((Object)((Object)listSecretLocksOptions), (String)"listSecretLocksOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", listSecretLocksOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/locks", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretLocks");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listSecretLocksOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(listSecretLocksOptions.offset())});
        }
        if (listSecretLocksOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listSecretLocksOptions.limit())});
        }
        if (listSecretLocksOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listSecretLocksOptions.sort())});
        }
        if (listSecretLocksOptions.search() != null) {
            builder.query(new Object[]{"search", String.valueOf(listSecretLocksOptions.search())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretLocksPaginatedCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretLocks> createSecretLocksBulk(CreateSecretLocksBulkOptions createSecretLocksBulkOptions) {
        Validator.notNull((Object)((Object)createSecretLocksBulkOptions), (String)"createSecretLocksBulkOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", createSecretLocksBulkOptions.id());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/locks_bulk", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretLocksBulk");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createSecretLocksBulkOptions.mode() != null) {
            builder.query(new Object[]{"mode", String.valueOf(createSecretLocksBulkOptions.mode())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("locks", GsonSingleton.getGson().toJsonTree(createSecretLocksBulkOptions.locks()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretLocks>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretLocks> deleteSecretLocksBulk(DeleteSecretLocksBulkOptions deleteSecretLocksBulkOptions) {
        Validator.notNull((Object)((Object)deleteSecretLocksBulkOptions), (String)"deleteSecretLocksBulkOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", deleteSecretLocksBulkOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{id}/locks_bulk", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecretLocksBulk");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteSecretLocksBulkOptions.name() != null) {
            builder.query(new Object[]{"name", RequestUtils.join(deleteSecretLocksBulkOptions.name(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretLocks>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretVersionLocksPaginatedCollection> listSecretVersionLocks(ListSecretVersionLocksOptions listSecretVersionLocksOptions) {
        Validator.notNull((Object)((Object)listSecretVersionLocksOptions), (String)"listSecretVersionLocksOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", listSecretVersionLocksOptions.secretId());
        pathParamsMap.put("id", listSecretVersionLocksOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/locks", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listSecretVersionLocks");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listSecretVersionLocksOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(listSecretVersionLocksOptions.offset())});
        }
        if (listSecretVersionLocksOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listSecretVersionLocksOptions.limit())});
        }
        if (listSecretVersionLocksOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listSecretVersionLocksOptions.sort())});
        }
        if (listSecretVersionLocksOptions.search() != null) {
            builder.query(new Object[]{"search", String.valueOf(listSecretVersionLocksOptions.search())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretVersionLocksPaginatedCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretLocks> createSecretVersionLocksBulk(CreateSecretVersionLocksBulkOptions createSecretVersionLocksBulkOptions) {
        Validator.notNull((Object)((Object)createSecretVersionLocksBulkOptions), (String)"createSecretVersionLocksBulkOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", createSecretVersionLocksBulkOptions.secretId());
        pathParamsMap.put("id", createSecretVersionLocksBulkOptions.id());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/locks_bulk", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createSecretVersionLocksBulk");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createSecretVersionLocksBulkOptions.mode() != null) {
            builder.query(new Object[]{"mode", String.valueOf(createSecretVersionLocksBulkOptions.mode())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("locks", GsonSingleton.getGson().toJsonTree(createSecretVersionLocksBulkOptions.locks()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretLocks>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SecretLocks> deleteSecretVersionLocksBulk(DeleteSecretVersionLocksBulkOptions deleteSecretVersionLocksBulkOptions) {
        Validator.notNull((Object)((Object)deleteSecretVersionLocksBulkOptions), (String)"deleteSecretVersionLocksBulkOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("secret_id", deleteSecretVersionLocksBulkOptions.secretId());
        pathParamsMap.put("id", deleteSecretVersionLocksBulkOptions.id());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/secrets/{secret_id}/versions/{id}/locks_bulk", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteSecretVersionLocksBulk");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteSecretVersionLocksBulkOptions.name() != null) {
            builder.query(new Object[]{"name", RequestUtils.join(deleteSecretVersionLocksBulkOptions.name(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SecretLocks>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Configuration> createConfiguration(CreateConfigurationOptions createConfigurationOptions) {
        Validator.notNull((Object)((Object)createConfigurationOptions), (String)"createConfigurationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createConfigurationOptions.configurationPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigurationMetadataPaginatedCollection> listConfigurations(ListConfigurationsOptions listConfigurationsOptions) {
        if (listConfigurationsOptions == null) {
            listConfigurationsOptions = new ListConfigurationsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listConfigurations");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listConfigurationsOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(listConfigurationsOptions.offset())});
        }
        if (listConfigurationsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(listConfigurationsOptions.limit())});
        }
        if (listConfigurationsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listConfigurationsOptions.sort())});
        }
        if (listConfigurationsOptions.search() != null) {
            builder.query(new Object[]{"search", String.valueOf(listConfigurationsOptions.search())});
        }
        if (listConfigurationsOptions.secretTypes() != null) {
            builder.query(new Object[]{"secret_types", RequestUtils.join(listConfigurationsOptions.secretTypes(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ConfigurationMetadataPaginatedCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigurationMetadataPaginatedCollection> listConfigurations() {
        return this.listConfigurations(null);
    }

    public ServiceCall<Configuration> getConfiguration(GetConfigurationOptions getConfigurationOptions) {
        Validator.notNull((Object)((Object)getConfigurationOptions), (String)"getConfigurationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("name", getConfigurationOptions.name());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations/{name}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getConfigurationOptions.xSmAcceptConfigurationType() != null) {
            builder.header(new Object[]{"X-Sm-Accept-Configuration-Type", getConfigurationOptions.xSmAcceptConfigurationType()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Configuration> updateConfiguration(UpdateConfigurationOptions updateConfigurationOptions) {
        Validator.notNull((Object)((Object)updateConfigurationOptions), (String)"updateConfigurationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("name", updateConfigurationOptions.name());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations/{name}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (updateConfigurationOptions.xSmAcceptConfigurationType() != null) {
            builder.header(new Object[]{"X-Sm-Accept-Configuration-Type", updateConfigurationOptions.xSmAcceptConfigurationType()});
        }
        builder.bodyContent(GsonSingleton.getGsonWithSerializeNulls().toJson(updateConfigurationOptions.configurationPatch()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteConfiguration(DeleteConfigurationOptions deleteConfigurationOptions) {
        Validator.notNull((Object)((Object)deleteConfigurationOptions), (String)"deleteConfigurationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("name", deleteConfigurationOptions.name());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations/{name}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteConfigurationOptions.xSmAcceptConfigurationType() != null) {
            builder.header(new Object[]{"X-Sm-Accept-Configuration-Type", deleteConfigurationOptions.xSmAcceptConfigurationType()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ConfigurationAction> createConfigurationAction(CreateConfigurationActionOptions createConfigurationActionOptions) {
        Validator.notNull((Object)((Object)createConfigurationActionOptions), (String)"createConfigurationActionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("name", createConfigurationActionOptions.name());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/configurations/{name}/actions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createConfigurationAction");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createConfigurationActionOptions.xSmAcceptConfigurationType() != null) {
            builder.header(new Object[]{"X-Sm-Accept-Configuration-Type", createConfigurationActionOptions.xSmAcceptConfigurationType()});
        }
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)createConfigurationActionOptions.configActionPrototype()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ConfigurationAction>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<NotificationsRegistration> createNotificationsRegistration(CreateNotificationsRegistrationOptions createNotificationsRegistrationOptions) {
        Validator.notNull((Object)((Object)createNotificationsRegistrationOptions), (String)"createNotificationsRegistrationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/notifications/registration"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createNotificationsRegistration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("event_notifications_instance_crn", createNotificationsRegistrationOptions.eventNotificationsInstanceCrn());
        contentJson.addProperty("event_notifications_source_name", createNotificationsRegistrationOptions.eventNotificationsSourceName());
        if (createNotificationsRegistrationOptions.eventNotificationsSourceDescription() != null) {
            contentJson.addProperty("event_notifications_source_description", createNotificationsRegistrationOptions.eventNotificationsSourceDescription());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<NotificationsRegistration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<NotificationsRegistration> getNotificationsRegistration(GetNotificationsRegistrationOptions getNotificationsRegistrationOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/notifications/registration"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getNotificationsRegistration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<NotificationsRegistration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<NotificationsRegistration> getNotificationsRegistration() {
        return this.getNotificationsRegistration(null);
    }

    public ServiceCall<Void> deleteNotificationsRegistration(DeleteNotificationsRegistrationOptions deleteNotificationsRegistrationOptions) {
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/notifications/registration"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteNotificationsRegistration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteNotificationsRegistration() {
        return this.deleteNotificationsRegistration(null);
    }

    public ServiceCall<Void> getNotificationsRegistrationTest(GetNotificationsRegistrationTestOptions getNotificationsRegistrationTestOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/api/v2/notifications/registration/test"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getNotificationsRegistrationTest");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> getNotificationsRegistrationTest() {
        return this.getNotificationsRegistrationTest(null);
    }
}

