/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.AnalyzerConfiguration;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class SearchIndexDefinition
extends GenericModel {
    protected AnalyzerConfiguration analyzer;
    protected String index;

    protected SearchIndexDefinition() {
    }

    protected SearchIndexDefinition(Builder builder) {
        Validator.notNull((Object)builder.index, (String)"index cannot be null");
        this.analyzer = builder.analyzer;
        this.index = builder.index;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public AnalyzerConfiguration analyzer() {
        return this.analyzer;
    }

    public String index() {
        return this.index;
    }

    public static class Builder {
        private AnalyzerConfiguration analyzer;
        private String index;

        private Builder(SearchIndexDefinition searchIndexDefinition) {
            this.analyzer = searchIndexDefinition.analyzer;
            this.index = searchIndexDefinition.index;
        }

        public Builder() {
        }

        public Builder(String index) {
            this.index = index;
        }

        public SearchIndexDefinition build() {
            return new SearchIndexDefinition(this);
        }

        public Builder analyzer(AnalyzerConfiguration analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }
    }
}

