/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteIndexOptions
extends GenericModel {
    protected String db;
    protected String ddoc;
    protected String type;
    protected String index;

    protected DeleteIndexOptions() {
    }

    protected DeleteIndexOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.ddoc, (String)"ddoc cannot be empty");
        Validator.notEmpty((String)builder.type, (String)"type cannot be empty");
        Validator.notEmpty((String)builder.index, (String)"index cannot be empty");
        this.db = builder.db;
        this.ddoc = builder.ddoc;
        this.type = builder.type;
        this.index = builder.index;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String type() {
        return this.type;
    }

    public String index() {
        return this.index;
    }

    public static class Builder {
        private String db;
        private String ddoc;
        private String type;
        private String index;

        private Builder(DeleteIndexOptions deleteIndexOptions) {
            this.db = deleteIndexOptions.db;
            this.ddoc = deleteIndexOptions.ddoc;
            this.type = deleteIndexOptions.type;
            this.index = deleteIndexOptions.index;
        }

        public Builder() {
        }

        public Builder(String db, String ddoc, String type, String index) {
            this.db = db;
            this.ddoc = ddoc;
            this.type = type;
            this.index = index;
        }

        public DeleteIndexOptions build() {
            return new DeleteIndexOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }
    }

    public static interface Type {
        public static final String JSON = "json";
        public static final String SPECIAL = "special";
        public static final String TEXT = "text";
    }
}

