/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.cloudant.v1.model.Attachment;
import com.ibm.cloud.cloudant.v1.model.DocumentRevisionStatus;
import com.ibm.cloud.cloudant.v1.model.Revisions;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Document
extends DynamicModel<Object> {
    @SerializedName(value="_attachments")
    protected Map<String, Attachment> attachments;
    @SerializedName(value="_conflicts")
    protected List<String> conflicts;
    @SerializedName(value="_deleted")
    protected Boolean deleted;
    @SerializedName(value="_deleted_conflicts")
    protected List<String> deletedConflicts;
    @SerializedName(value="_id")
    protected String id;
    @SerializedName(value="_local_seq")
    protected String localSeq;
    @SerializedName(value="_rev")
    protected String rev;
    @SerializedName(value="_revisions")
    protected Revisions revisions;
    @SerializedName(value="_revs_info")
    protected List<DocumentRevisionStatus> revsInfo;

    public Document() {
        super((TypeToken)new TypeToken<Object>(){});
    }

    protected Document(Builder builder) {
        super((TypeToken)new TypeToken<Object>(){});
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.deleted = builder.deleted;
        this.deletedConflicts = builder.deletedConflicts;
        this.id = builder.id;
        this.localSeq = builder.localSeq;
        this.rev = builder.rev;
        this.revisions = builder.revisions;
        this.revsInfo = builder.revsInfo;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<String> conflicts) {
        this.conflicts = conflicts;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<String> getDeletedConflicts() {
        return this.deletedConflicts;
    }

    public void setDeletedConflicts(List<String> deletedConflicts) {
        this.deletedConflicts = deletedConflicts;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLocalSeq() {
        return this.localSeq;
    }

    public void setLocalSeq(String localSeq) {
        this.localSeq = localSeq;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public Revisions getRevisions() {
        return this.revisions;
    }

    public void setRevisions(Revisions revisions) {
        this.revisions = revisions;
    }

    public List<DocumentRevisionStatus> getRevsInfo() {
        return this.revsInfo;
    }

    public void setRevsInfo(List<DocumentRevisionStatus> revsInfo) {
        this.revsInfo = revsInfo;
    }

    public static class Builder {
        private Map<String, Attachment> attachments;
        private List<String> conflicts;
        private Boolean deleted;
        private List<String> deletedConflicts;
        private String id;
        private String localSeq;
        private String rev;
        private Revisions revisions;
        private List<DocumentRevisionStatus> revsInfo;
        private Map<String, Object> dynamicProperties;

        private Builder(Document document) {
            this.attachments = document.attachments;
            this.conflicts = document.conflicts;
            this.deleted = document.deleted;
            this.deletedConflicts = document.deletedConflicts;
            this.id = document.id;
            this.localSeq = document.localSeq;
            this.rev = document.rev;
            this.revisions = document.revisions;
            this.revsInfo = document.revsInfo;
            this.dynamicProperties = document.getProperties();
        }

        public Builder() {
        }

        public Document build() {
            return new Document(this);
        }

        public Builder addConflicts(String conflicts) {
            Validator.notNull((Object)conflicts, (String)"conflicts cannot be null");
            if (this.conflicts == null) {
                this.conflicts = new ArrayList<String>();
            }
            this.conflicts.add(conflicts);
            return this;
        }

        public Builder addDeletedConflicts(String deletedConflicts) {
            Validator.notNull((Object)deletedConflicts, (String)"deletedConflicts cannot be null");
            if (this.deletedConflicts == null) {
                this.deletedConflicts = new ArrayList<String>();
            }
            this.deletedConflicts.add(deletedConflicts);
            return this;
        }

        public Builder addRevsInfo(DocumentRevisionStatus revsInfo) {
            Validator.notNull((Object)((Object)revsInfo), (String)"revsInfo cannot be null");
            if (this.revsInfo == null) {
                this.revsInfo = new ArrayList<DocumentRevisionStatus>();
            }
            this.revsInfo.add(revsInfo);
            return this;
        }

        public Builder attachments(Map<String, Attachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(List<String> conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deletedConflicts(List<String> deletedConflicts) {
            this.deletedConflicts = deletedConflicts;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder localSeq(String localSeq) {
            this.localSeq = localSeq;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder revisions(Revisions revisions) {
            this.revisions = revisions;
            return this;
        }

        public Builder revsInfo(List<DocumentRevisionStatus> revsInfo) {
            this.revsInfo = revsInfo;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull((Object)name, (String)"name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

