/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features.pagination;

import com.ibm.cloud.cloudant.features.pagination.OptionsHandler;
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

abstract class BasePageIterator<B, O, R, I>
implements Iterator<List<I>> {
    protected final Cloudant client;
    protected final long pageSize;
    protected final OptionsHandler<B, O> optsHandler;
    protected final AtomicReference<O> nextPageOptionsRef = new AtomicReference();
    protected volatile boolean hasNext = true;

    BasePageIterator(Cloudant client, O options, OptionsHandler<B, O> optsHandler) {
        this.client = client;
        this.optsHandler = optsHandler;
        this.pageSize = this.optsHandler.getPageSizeFromOptionsLimit(options);
        this.buildAndSetOptions(this.optsHandler.applyLimit(this.optsHandler.builderFromOptions(options), this.pageSize));
    }

    @Override
    public final boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public List<I> next() {
        if (this.hasNext()) {
            return Collections.unmodifiableList(this.nextRequest());
        }
        throw new NoSuchElementException();
    }

    List<I> nextRequest() {
        ServiceCall<R> request = this.nextRequestFunction().apply(this.client, this.nextPageOptionsRef.get());
        Object result = request.execute().getResult();
        List<I> items = this.itemsGetter().apply(result);
        if ((long)items.size() < this.pageSize) {
            this.hasNext = false;
        } else {
            O options = this.nextPageOptionsRef.get();
            B optionsBuilder = this.optsHandler.builderFromOptions(this.nextPageOptionsRef.get());
            this.setNextPageOptions(optionsBuilder, result);
            optionsBuilder = this.optsHandler.removeOptsForSubsequentPage(options, optionsBuilder);
            this.buildAndSetOptions(optionsBuilder);
        }
        return items;
    }

    protected void buildAndSetOptions(B optionsBuilder) {
        this.nextPageOptionsRef.set(this.optsHandler.optionsFromBuilder(optionsBuilder));
    }

    abstract Function<R, List<I>> itemsGetter();

    abstract void setNextPageOptions(B var1, R var2);

    abstract BiFunction<Cloudant, O, ServiceCall<R>> nextRequestFunction();
}

