/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.cloudant.v1.model.Analyzer;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnalyzerConfiguration
extends GenericModel {
    protected String name;
    protected List<String> stopwords;
    @SerializedName(value="default")
    protected Analyzer xDefault;
    protected Map<String, Analyzer> fields;

    protected AnalyzerConfiguration() {
    }

    protected AnalyzerConfiguration(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.name = builder.name;
        this.stopwords = builder.stopwords;
        this.xDefault = builder.xDefault;
        this.fields = builder.fields;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    public Analyzer xDefault() {
        return this.xDefault;
    }

    public Map<String, Analyzer> fields() {
        return this.fields;
    }

    public static class Builder {
        private String name;
        private List<String> stopwords;
        private Analyzer xDefault;
        private Map<String, Analyzer> fields;

        private Builder(AnalyzerConfiguration analyzerConfiguration) {
            this.name = analyzerConfiguration.name;
            this.stopwords = analyzerConfiguration.stopwords;
            this.xDefault = analyzerConfiguration.xDefault;
            this.fields = analyzerConfiguration.fields;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public AnalyzerConfiguration build() {
            return new AnalyzerConfiguration(this);
        }

        public Builder addStopwords(String stopwords) {
            Validator.notNull((Object)stopwords, (String)"stopwords cannot be null");
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(stopwords);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder stopwords(List<String> stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public Builder xDefault(Analyzer xDefault) {
            this.xDefault = xDefault;
            return this;
        }

        public Builder fields(Map<String, Analyzer> fields) {
            this.fields = fields;
            return this;
        }
    }

    public static interface Name {
        public static final String CLASSIC = "classic";
        public static final String EMAIL = "email";
        public static final String KEYWORD = "keyword";
        public static final String PERFIELD = "perfield";
        public static final String SIMPLE = "simple";
        public static final String SIMPLE_ASCIIFOLDING = "simple_asciifolding";
        public static final String STANDARD = "standard";
        public static final String WHITESPACE = "whitespace";
        public static final String ARABIC = "arabic";
        public static final String ARMENIAN = "armenian";
        public static final String BASQUE = "basque";
        public static final String BRAZILIAN = "brazilian";
        public static final String BULGARIAN = "bulgarian";
        public static final String CATALAN = "catalan";
        public static final String CHINESE = "chinese";
        public static final String CJK = "cjk";
        public static final String CZECH = "czech";
        public static final String DANISH = "danish";
        public static final String DUTCH = "dutch";
        public static final String ENGLISH = "english";
        public static final String FINNISH = "finnish";
        public static final String FRENCH = "french";
        public static final String GALICIAN = "galician";
        public static final String GERMAN = "german";
        public static final String GREEK = "greek";
        public static final String HINDI = "hindi";
        public static final String HUNGARIAN = "hungarian";
        public static final String INDONESIAN = "indonesian";
        public static final String IRISH = "irish";
        public static final String ITALIAN = "italian";
        public static final String JAPANESE = "japanese";
        public static final String LATVIAN = "latvian";
        public static final String NORWEGIAN = "norwegian";
        public static final String PERSIAN = "persian";
        public static final String POLISH = "polish";
        public static final String PORTUGUESE = "portuguese";
        public static final String ROMANIAN = "romanian";
        public static final String RUSSIAN = "russian";
        public static final String SPANISH = "spanish";
        public static final String SWEDISH = "swedish";
        public static final String THAI = "thai";
        public static final String TURKISH = "turkish";
    }
}

