/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncNamedReadWriteLock;
import com.ibm.asyncutil.locks.AsyncReadWriteLock;
import com.ibm.asyncutil.locks.FairAsyncReadWriteLock;
import com.ibm.asyncutil.util.StageSupport;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class FairAsyncNamedReadWriteLock<T>
implements AsyncNamedReadWriteLock<T> {
    private final ConcurrentHashMap<T, AtomicReference<NamedNode>> map = new ConcurrentHashMap();

    @Override
    public CompletionStage<AsyncReadWriteLock.ReadLockToken> acquireReadLock(T name) {
        NodeBox<NamedNode> created = new NodeBox<NamedNode>();
        block5: while (true) {
            created.ref = null;
            AtomicReference<NamedNode> headRef = this.computeIfAbsentReader(name, created);
            if (headRef == created.ref) {
                return StageSupport.completedStage((AsyncReadWriteLock.ReadLockToken)created.node);
            }
            block6: while (true) {
                NamedNode head = headRef.get();
                switch (head.internalEnter()) {
                    case SPECIAL: {
                        Thread.yield();
                        continue block5;
                    }
                    case TERMINATED: {
                        continue block6;
                    }
                    case NORMAL: {
                        return head.readFuture;
                    }
                }
            }
            break;
        }
    }

    @Override
    public CompletionStage<AsyncReadWriteLock.WriteLockToken> acquireWriteLock(T name) {
        NodeBox<NamedNode> created = new NodeBox<NamedNode>();
        block5: while (true) {
            NamedNode head;
            created.ref = null;
            AtomicReference<NamedNode> headRef = this.computeIfAbsentWriter(name, created);
            if (headRef == created.ref) {
                head = (NamedNode)created.node;
                NamedNode pred = new NamedNode(name, Integer.MIN_VALUE);
                pred.next = head;
                head.prev = pred;
                return StageSupport.completedStage(pred.writeLockToken);
            }
            block6: while (true) {
                head = headRef.get();
                switch (head.internalTerminate()) {
                    case SPECIAL: {
                        Thread.yield();
                        continue block5;
                    }
                    case TERMINATED: {
                        continue block6;
                    }
                    case NORMAL: {
                        NamedNode newHead = new NamedNode(name, 1, head);
                        head.next = newHead;
                        headRef.set(newHead);
                        return head.writeLockToken;
                    }
                }
            }
            break;
        }
    }

    @Override
    public Optional<AsyncReadWriteLock.ReadLockToken> tryReadLock(T name) {
        NodeBox<NamedNode> created = new NodeBox<NamedNode>();
        AtomicReference<NamedNode> headRef = this.computeIfAbsentReader(name, created);
        if (headRef == created.ref) {
            return Optional.of((AsyncReadWriteLock.ReadLockToken)created.node);
        }
        NamedNode h = headRef.get();
        return h.tryReadLock() ? Optional.of(h) : Optional.empty();
    }

    @Override
    public Optional<AsyncReadWriteLock.WriteLockToken> tryWriteLock(T name) {
        NodeBox<NamedNode> created = new NodeBox<NamedNode>();
        AtomicReference<NamedNode> headRef = this.computeIfAbsentWriter(name, created);
        if (headRef == created.ref) {
            NamedNode head = (NamedNode)created.node;
            NamedNode pred = new NamedNode(name, Integer.MIN_VALUE);
            pred.next = head;
            head.prev = pred;
            return Optional.of(pred.writeLockToken);
        }
        return Optional.empty();
    }

    private AtomicReference<NamedNode> computeIfAbsentReader(T name, NodeBox<NamedNode> box) {
        return this.map.computeIfAbsent(name, keyName -> {
            NamedNode node = new NamedNode(keyName, 1);
            node.readFuture.complete(node);
            AtomicReference<NamedNode> ref = new AtomicReference<NamedNode>();
            box.node = node;
            ref.lazySet((NamedNode)box.node);
            box.ref = ref;
            return ref;
        });
    }

    private AtomicReference<NamedNode> computeIfAbsentWriter(T name, NodeBox<NamedNode> box) {
        return this.map.computeIfAbsent(name, keyName -> {
            AtomicReference<NamedNode> ref = new AtomicReference<NamedNode>();
            box.node = new NamedNode(keyName, 1, null);
            ref.lazySet((NamedNode)box.node);
            box.ref = ref;
            return ref;
        });
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    private static final class NodeBox<E> {
        E node = null;
        AtomicReference<E> ref = null;

        private NodeBox() {
        }
    }

    private final class NamedNode
    extends FairAsyncReadWriteLock.Node {
        private final T name;

        NamedNode(T name, int initState) {
            super(initState);
            this.name = name;
        }

        NamedNode(T name, int initState, NamedNode prev) {
            super(initState, prev);
            this.name = name;
        }

        @Override
        void onExit(int state) {
            if (state == 0) {
                AtomicReference removed = (AtomicReference)FairAsyncNamedReadWriteLock.this.map.remove(this.name);
                if (removed == null) {
                    throw new ConcurrentModificationException("lock name's hashCode or equality has changed since time of acquisition:" + this.name);
                }
                assert (removed.get() == this);
            }
        }

        @Override
        boolean isSpecialEnterState(int state) {
            return state == 0;
        }

        @Override
        boolean isSpecialTerminateState(int state) {
            return state == 0;
        }
    }
}

