/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.ext.DebugInterceptor;

public class SQLManagerBuilder {
    Properties beetlPs;
    Interceptor[] inters;
    private String defaultSchema;
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private NameConversion nc;
    private ConnectionSource ds;
    private List<Interceptor> interceptorList = new LinkedList<Interceptor>();

    SQLManagerBuilder(ConnectionSource ds) {
        this.ds = ds;
    }

    public SQLManager build() {
        DBStyle dbStyle = this.getDbStyle();
        SQLLoader sqlLoader = this.getSqlLoader();
        NameConversion nc = this.getNc();
        Interceptor[] inters = this.getInters();
        String defaultSchema = this.getDefaultSchema();
        Properties ps = this.getBeetlPs();
        SQLManager sm = new SQLManager(dbStyle, sqlLoader, this.ds, nc, inters, defaultSchema, ps);
        return sm;
    }

    public SQLManagerBuilder addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
        return this;
    }

    public SQLManagerBuilder addInterDebug() {
        this.interceptorList.add(new DebugInterceptor());
        return this;
    }

    private Properties getBeetlPs() {
        if (this.beetlPs == null) {
            this.beetlPs = new Properties();
        }
        return this.beetlPs;
    }

    public SQLManagerBuilder setBeetlPs(Properties beetlPs) {
        this.beetlPs = beetlPs;
        return this;
    }

    private String getDefaultSchema() {
        return this.defaultSchema;
    }

    public SQLManagerBuilder setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    private Interceptor[] getInters() {
        if (this.inters == null) {
            this.inters = new Interceptor[0];
        }
        if (this.interceptorList.size() > 0) {
            HashMap<String, Interceptor> map = new HashMap<String, Interceptor>();
            for (Interceptor inter : this.interceptorList) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            for (Interceptor inter : this.inters) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            this.inters = new Interceptor[map.size()];
            int i = 0;
            for (Interceptor inter : map.values()) {
                this.inters[i++] = inter;
            }
        }
        return this.inters;
    }

    public SQLManagerBuilder setInters(Interceptor[] inters) {
        this.inters = inters;
        return this;
    }

    private DBStyle getDbStyle() {
        if (this.dbStyle == null) {
            this.dbStyle = new MySqlStyle();
        }
        return this.dbStyle;
    }

    public SQLManagerBuilder setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
        return this;
    }

    private SQLLoader getSqlLoader() {
        if (this.sqlLoader == null) {
            this.sqlLoader = new ClasspathLoader();
        }
        return this.sqlLoader;
    }

    public SQLManagerBuilder setSqlLoader(String root) {
        this.sqlLoader = new ClasspathLoader(root);
        return this;
    }

    public SQLManagerBuilder setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
        return this;
    }

    private NameConversion getNc() {
        if (this.nc == null) {
            this.nc = new DefaultNameConversion();
        }
        return this.nc;
    }

    public SQLManagerBuilder setNc(NameConversion nc) {
        this.nc = nc;
        return this;
    }
}

