/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.OutputStream;
import org.beetl.core.io.IOUtil;

public class NoLockByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 32;
    protected byte[] buf;
    protected int pos;

    public NoLockByteArrayOutputStream() {
        this(32);
    }

    public NoLockByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void write(int src) {
        int newPos = this.pos + 1;
        if (newPos > this.buf.length) {
            this.buf = IOUtil.copyOf(this.buf, Math.max(this.buf.length << 1, newPos));
        }
        this.buf[this.pos] = (byte)src;
        this.pos = newPos;
    }

    @Override
    public void write(byte[] src, int off, int len) {
        int newPos = this.pos + len;
        if (newPos > this.buf.length) {
            this.buf = IOUtil.copyOf(this.buf, Math.max(this.buf.length << 1, newPos));
        }
        System.arraycopy(src, off, this.buf, this.pos, len);
        this.pos = newPos;
    }

    public void reset() {
        this.pos = 0;
    }

    public byte[] toByteArray() {
        return IOUtil.copyOf(this.buf, this.pos);
    }

    public int size() {
        return this.pos;
    }
}

